/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.Instruction;
import org.biojava.utils.bytecode.LocalVariable;

class LocalVariableInstruction
implements Instruction {
    private final LocalVariable var;
    private final byte opcode;
    private final byte specialOpCodeBase;

    LocalVariableInstruction(byte op, byte special, LocalVariable var) {
        if (var == null) {
            throw new NullPointerException("LocalVariable can not be null");
        }
        this.opcode = op;
        this.specialOpCodeBase = special;
        this.var = var;
    }

    public void writeCode(CodeContext ctx) throws CodeException {
        int slot = ctx.resolveLocal(this.var);
        if (slot <= 3) {
            ctx.writeByte((byte)(this.specialOpCodeBase + slot));
        } else if (slot < 256) {
            ctx.writeByte(this.opcode);
            ctx.writeByte((byte)slot);
        } else {
            ctx.writeByte((byte)-60);
            ctx.writeByte(this.opcode);
            ctx.writeShort(slot);
        }
    }

    public int stackDepth() {
        return this.stackDelta();
    }

    public int stackDelta() {
        return 1;
    }
}

