/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import cern.jet.math.Bessel;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class NormalInverseGaussianDist
extends ContinuousDistribution {
    protected double mu;
    protected double delta;
    protected double alpha;
    protected double beta;
    protected double gamma;

    public NormalInverseGaussianDist(double alpha, double beta, double mu, double delta) {
        this.setParams(alpha, beta, mu, delta);
    }

    public double density(double x) {
        return NormalInverseGaussianDist.density(this.alpha, this.beta, this.mu, this.delta, x);
    }

    public double cdf(double x) {
        return NormalInverseGaussianDist.cdf(this.alpha, this.beta, this.mu, this.delta, x);
    }

    public double barF(double x) {
        return NormalInverseGaussianDist.barF(this.alpha, this.beta, this.mu, this.delta, x);
    }

    public double getMean() {
        return NormalInverseGaussianDist.getMean(this.alpha, this.beta, this.mu, this.delta);
    }

    public double getVariance() {
        return NormalInverseGaussianDist.getVariance(this.alpha, this.beta, this.mu, this.delta);
    }

    public double getStandardDeviation() {
        return NormalInverseGaussianDist.getStandardDeviation(this.alpha, this.beta, this.mu, this.delta);
    }

    public static double density(double alpha, double beta, double mu, double delta, double x) {
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (Math.abs(beta) >= alpha) {
            throw new IllegalArgumentException("|beta| >= alpha");
        }
        double gamma = Math.sqrt(alpha * alpha - beta * beta);
        if (x <= 0.0) {
            return 0.0;
        }
        double z = (x - mu) / delta;
        double w = Math.sqrt(1.0 + z * z);
        double r = alpha * Math.exp(delta * (gamma + beta * z)) * Bessel.k1(alpha * delta * w) / (Math.PI * w);
        return r;
    }

    public static double cdf(double alpha, double beta, double mu, double delta, double x) {
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (Math.abs(beta) >= alpha) {
            throw new IllegalArgumentException("|beta| >= alpha");
        }
        double gamma = Math.sqrt(alpha * alpha - beta * beta);
        if (x <= 0.0) {
            return 0.0;
        }
        double z = (x - mu) / delta;
        if (z > 0.0 && gamma + (beta - alpha) * z >= 100.0) {
            return 1.0;
        }
        if (z < 0.0 && gamma + (beta + alpha) * z <= -1000.0) {
            return 0.0;
        }
        double w = Math.sqrt(1.0 + z * z);
        throw new UnsupportedOperationException("NormalInverseGaussianDist:   cdf NOT IMPLEMENTED");
    }

    public static double barF(double alpha, double beta, double mu, double delta, double x) {
        return 1.0 - NormalInverseGaussianDist.cdf(alpha, beta, mu, delta, x);
    }

    public static double inverseF(double alpha, double beta, double mu, double delta, double u) {
        throw new UnsupportedOperationException(" Inversion NOT IMPLEMENTED");
    }

    public static double[] getMLE(double[] x, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] parameters = new double[4];
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += x[i];
        }
        throw new UnsupportedOperationException("getMLE is not implemented");
    }

    public static NormalInverseGaussianDist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = NormalInverseGaussianDist.getMLE(x, n);
        return new NormalInverseGaussianDist(parameters[0], parameters[1], parameters[2], parameters[3]);
    }

    public static double getMean(double alpha, double beta, double mu, double delta) {
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (Math.abs(beta) >= alpha) {
            throw new IllegalArgumentException("|beta| >= alpha");
        }
        double gamma = Math.sqrt(alpha * alpha - beta * beta);
        return mu + delta * beta / gamma;
    }

    public static double getVariance(double alpha, double beta, double mu, double delta) {
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (Math.abs(beta) >= alpha) {
            throw new IllegalArgumentException("|beta| >= alpha");
        }
        double gamma = Math.sqrt(alpha * alpha - beta * beta);
        return delta * alpha * alpha / (gamma * gamma * gamma);
    }

    public static double getStandardDeviation(double alpha, double beta, double mu, double delta) {
        return Math.sqrt(NormalInverseGaussianDist.getVariance(alpha, beta, mu, delta));
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getMu() {
        return this.mu;
    }

    public double getDelta() {
        return this.delta;
    }

    public void setParams(double alpha, double beta, double mu, double delta) {
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (Math.abs(beta) >= alpha) {
            throw new IllegalArgumentException("|beta| >= alpha");
        }
        this.gamma = Math.sqrt(alpha * alpha - beta * beta);
        this.mu = mu;
        this.delta = delta;
        this.beta = beta;
        this.alpha = alpha;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.alpha, this.beta, this.mu, this.delta};
        return retour;
    }

    public String toString() {
        return this.getClass().getName() + ": alpha = " + this.alpha + ", beta = " + this.beta + ", mu = " + this.mu + ", delta = " + this.delta;
    }
}

