/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.BetaDist;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.util.Num;

public class StudentDist
extends ContinuousDistribution {
    private int n;
    private double factor;
    private static final int STUDENT_N1 = 20;
    private static final double STUDENT_X1 = 8.01;
    private static final int STUDENT_KMAX = 200;
    private static final double STUDENT_EPS = 5.0E-17;
    private static double[] W = new double[5];

    public StudentDist(int n) {
        this.setN(n);
    }

    public double density(double x) {
        return this.factor * Math.pow(1.0 + x * x / (double)this.n, -((double)this.n + 1.0) / 2.0);
    }

    public double cdf(double x) {
        return StudentDist.cdf(this.n, x);
    }

    public double inverseF(double u) {
        return StudentDist.inverseF(this.n, u);
    }

    public double getMean() {
        return StudentDist.getMean(this.n);
    }

    public double getVariance() {
        return StudentDist.getVariance(this.n);
    }

    public double getStandardDeviation() {
        return StudentDist.getStandardDeviation(this.n);
    }

    public static double density(int n, double x) {
        double factor = Math.exp(Num.lnGamma((double)(n + 1) / 2.0) - Num.lnGamma((double)n / 2.0)) / Math.sqrt((double)n * Math.PI);
        return factor * Math.pow(1.0 + x * x / (double)n, -((double)n + 1.0) / 2.0);
    }

    public static double cdf(int n, double x) {
        int k;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n == 1) {
            return 0.5 + Math.atan(x) / Math.PI;
        }
        if (n == 2) {
            double z = 1.0 + x * x / 2.0;
            return 0.5 + x * Math.sqrt(z) / (2.0 * z * 1.4142135623730951);
        }
        if (x <= -100.0) {
            return 0.0;
        }
        if (x >= 100.0) {
            return 1.0;
        }
        if (n <= 20 && x <= 8.01) {
            double b = 1.0 + x * x / (double)n;
            double y = x / Math.sqrt(n);
            double z = 1.0;
            for (int k2 = n - 2; k2 >= 2; k2 -= 2) {
                z = 1.0 + z * ((double)k2 - 1.0) / ((double)k2 * b);
            }
            if (n % 2 == 0) {
                return (1.0 + z * y / Math.sqrt(b)) / 2.0;
            }
            return 0.5 + (Math.atan(y) + z * y / b) / Math.PI;
        }
        if (x < 8.01) {
            double a = (double)n - 0.5;
            double b = 48.0 * a * a;
            double z2 = a * Math.log1p(x * x / (double)n);
            double z = Math.sqrt(z2);
            double y = (((((64.0 * z2 + 788.0) * z2 + 9801.0) * z2 + 89775.0) * z2 + 543375.0) * z2 + 1788885.0) * z / (210.0 * b * b * b);
            y -= (((4.0 * z2 + 33.0) * z2 + 240.0) * z2 + 855.0) * z / (10.0 * b * b);
            y += z + (z2 + 3.0) * z / b;
            if (x >= 0.0) {
                return NormalDist.barF01(-y);
            }
            return NormalDist.barF01(y);
        }
        double b = 1.0 + x * x / (double)n;
        double y = Num.lnGamma((double)(n + 1) / 2.0) - Num.lnGamma((double)n / 2.0);
        y = Math.exp(y);
        y *= 1.0 / (Math.sqrt(Math.PI * (double)n) * Math.pow(b, (double)(n + 1) / 2.0));
        double z = (y *= 2.0 * Math.sqrt((double)n * b)) / (double)n;
        double prec = 10.0;
        double z2 = 10.0;
        for (k = 2; k < 200 && prec > 5.0E-17; k += 2) {
            prec = Math.abs((z += (y *= (double)(k - 1) / ((double)k * b)) / (double)(n + k)) - z2);
            z2 = z;
        }
        if (k >= 200) {
            System.err.println("student: k >= STUDENT_KMAX");
        }
        if (x >= 0.0) {
            return 1.0 - z / 2.0;
        }
        return z / 2.0;
    }

    public static double cdf2(int n, int d, double x) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (d <= 0) {
            throw new IllegalArgumentException("student2:   d <= 0");
        }
        if (x >= 0.0) {
            return 0.5 * (1.0 + BetaDist.cdf(0.5, 0.5 * (double)n, d, x * x / ((double)n + x * x)));
        }
        return 0.5 * BetaDist.cdf(0.5 * (double)n, 0.5, d, (double)n / ((double)n + x * x));
    }

    public static double barF(int n, double x) {
        return 1.0 - StudentDist.cdf(n, x);
    }

    public static double inverseF(int n, double u) {
        double DWARF = 1.0E-31;
        double PIOVR2 = 1.5707963268;
        if (n < 1) {
            throw new IllegalArgumentException("Calling student with n < 1");
        }
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("Calling student with u < 0 or u > 1");
        }
        if (u <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (n == 1) {
            double arg = Math.PI * (1.0 - u);
            if (Math.sin(arg) > 1.0E-31) {
                return Math.cos(arg) / Math.sin(arg);
            }
            return Math.cos(arg) / 1.0E-31;
        }
        if (n == 2) {
            double T = u <= 0.5 ? 2.0 * u : 2.0 * (1.0 - u);
            if (T <= 1.0E-31) {
                T = 1.0E-31;
            }
            double vtemp = Math.sqrt(2.0 / (T * (2.0 - T)) - 2.0);
            if (u <= 0.5) {
                return -vtemp;
            }
            return vtemp;
        }
        if (u <= 1.0E-31 || 1.0 - u <= 1.0E-31) {
            double T = 1.0E31;
            if (u < 0.5) {
                return -T;
            }
            return T;
        }
        double ux2 = u * 2.0;
        double p2tail = ux2 < 2.0 - ux2 ? ux2 : 2.0 - ux2;
        StudentDist.W[2] = 1.0 / ((double)n - 0.5);
        StudentDist.W[1] = 48.0 / (W[2] * W[2]);
        StudentDist.W[3] = ((20700.0 * W[2] / W[1] - 98.0) * W[2] - 16.0) * W[2] + 96.36;
        StudentDist.W[4] = ((94.5 / (W[1] + W[3]) - 3.0) / W[1] + 1.0) * Math.sqrt(W[2] * 1.5707963268) * (double)n;
        double X = W[4] * p2tail;
        double C = W[3];
        double Y = Math.pow(X, 2.0 / (double)n);
        if (Y <= 0.05 + W[2]) {
            double Y2 = ((double)n + 6.0) / ((double)n + Y) - 0.089 * W[4] - 0.822;
            Y2 = Y2 * ((double)n + 2.0) * 3.0;
            Y2 = (1.0 / Y2 + 0.5 / ((double)n + 4.0)) * Y - 1.0;
            Y2 = Y2 * ((double)n + 1.0) / ((double)n + 2.0);
            Y = Y2 + 1.0 / Y;
        } else {
            X = NormalDist.inverseF01(p2tail * 0.5);
            Y = X * X;
            if ((double)n < 5.0) {
                C += 0.3 * ((double)n - 4.5) * (X + 0.6);
            }
            C = (((0.05 * W[4] * X - 5.0) * X - 7.0) * X - 2.0) * X + W[1] + C;
            Y = (((((0.4 * Y + 6.3) * Y + 36.0) * Y + 94.5) / C - Y - 3.0) / W[1] + 1.0) * X;
            Y = (Y = W[2] * Y * Y) <= 0.002 ? 0.5 * Y * Y + Y : Math.exp(Y) - 1.0;
        }
        double T = Math.sqrt((double)n * Y);
        if (u < 0.5) {
            return -T;
        }
        return T;
    }

    public static double[] getMLE(double[] x, int m) {
        double fn0;
        double sum = 0.0;
        double[] parameters = new double[1];
        if (m <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        double var = 0.0;
        for (int i = 0; i < m; ++i) {
            var += x[i] * x[i];
        }
        Function f = new Function(x, m);
        double n0 = Math.round(2.0 * (var /= (double)m) / (var - 1.0));
        double min = fn0 = f.evaluate(n0);
        double fn1 = f.evaluate(n0 + 1.0);
        double fn_1 = f.evaluate(n0 - 1.0);
        parameters[0] = n0;
        if (fn_1 > fn0) {
            double n = n0 - 1.0;
            while (true) {
                double d;
                double y = f.evaluate(n);
                if (d > min && n >= 1.0) {
                    min = y;
                    parameters[0] = n;
                    n -= 1.0;
                    continue;
                }
                break;
            }
        } else if (fn1 > fn0) {
            double n = n0 + 1.0;
            while (true) {
                double d;
                double y = f.evaluate(n);
                if (!(d > min)) break;
                min = y;
                parameters[0] = n;
                n += 1.0;
            }
        }
        return parameters;
    }

    @Deprecated
    public static double[] getMaximumLikelihoodEstimate(double[] x, int m) {
        return StudentDist.getMLE(x, m);
    }

    public static StudentDist getInstanceFromMLE(double[] x, int m) {
        double[] parameters = StudentDist.getMaximumLikelihoodEstimate(x, m);
        return new StudentDist((int)parameters[0]);
    }

    public static double getMean(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        return 0.0;
    }

    public static double getVariance(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("n <= 2");
        }
        return (double)n / ((double)n - 2.0);
    }

    public static double getStandardDeviation(int n) {
        return Math.sqrt(StudentDist.getVariance(n));
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        this.n = n;
        this.factor = Math.exp(Num.lnGamma((double)(n + 1) / 2.0) - Num.lnGamma((double)n / 2.0)) / Math.sqrt((double)n * Math.PI);
    }

    public double[] getParams() {
        double[] retour = new double[]{this.n};
        return retour;
    }

    public String toString() {
        return this.getClass().getName() + " : n = " + this.n;
    }

    private static class Function
    implements MathFunction {
        private int n;
        private double[] xi;

        public Function(double[] x, int n) {
            this.n = n;
            this.xi = new double[n];
            System.arraycopy(x, 0, this.xi, 0, n);
        }

        public double evaluate(double x) {
            double sum = 0.0;
            if (x <= 0.0) {
                return 1.0E200;
            }
            for (int i = 0; i < this.n; ++i) {
                sum += Math.log(StudentDist.density((int)Math.round(x), this.xi[i]));
            }
            return sum;
        }
    }
}

