/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.analysis.GcBiasDetailMetrics;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.SinglePassSamProgram;
import picard.analysis.directed.GcBiasMetricsCollector;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.metrics.GcBiasMetrics;
import picard.util.RExecutor;

@CommandLineProgramProperties(usage="Tool to collect information about GC bias in the reads in a given BAM file. Computes the number of windows (of size specified by WINDOW_SIZE) in the genome at each GC% and counts the number of read starts in each GC bin.  What is output and plotted is the \"normalized coverage\" in each bin - i.e. the number of reads per window normalized to the average number of reads per window across the whole genome..\n", usageShort="Collects information about GC bias in the reads in the provided SAM or BAM", programGroup=Metrics.class)
public class CollectGcBiasMetrics
extends SinglePassSamProgram {
    private static final String R_SCRIPT = "picard/analysis/gcBias.R";
    @Option(shortName="CHART", doc="The PDF file to render the chart to.")
    public File CHART_OUTPUT;
    @Option(shortName="S", doc="The text file to write summary metrics to.", optional=true)
    public File SUMMARY_OUTPUT;
    @Option(doc="The size of windows on the genome that are used to bin reads.")
    public int WINDOW_SIZE = 100;
    @Option(doc="For summary metrics, exclude GC windows that include less than this fraction of the genome.")
    public double MINIMUM_GENOME_FRACTION = 1.0E-5;
    @Option(shortName="BS", doc="Whether the SAM or BAM file consists of bisulfite sequenced reads.")
    public boolean IS_BISULFITE_SEQUENCED = false;
    @Option(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.")
    public Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet((Object[])new MetricAccumulationLevel[]{MetricAccumulationLevel.ALL_READS});
    private GcBiasMetricsCollector multiCollector;
    private final int windowSize = this.WINDOW_SIZE;
    final int[] windowsByGc = new int[101];
    private static final int WINDOWS = 101;
    private final Map<String, byte[]> gcByRef = new HashMap<String, byte[]>();

    public static void main(String[] args) {
        System.exit(new CollectGcBiasMetrics().instanceMain(args));
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        ReferenceSequence ref;
        IOUtil.assertFileIsWritable((File)this.CHART_OUTPUT);
        if (this.SUMMARY_OUTPUT != null) {
            IOUtil.assertFileIsWritable((File)this.SUMMARY_OUTPUT);
        }
        IOUtil.assertFileIsReadable((File)this.REFERENCE_SEQUENCE);
        ReferenceSequenceFile refFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)this.REFERENCE_SEQUENCE);
        while ((ref = refFile.nextSequence()) != null) {
            byte[] refBases = ref.getBases();
            String refName = ref.getName();
            StringUtil.toUpperCase((byte[])refBases);
            int refLength = refBases.length;
            int lastWindowStart = refLength - this.windowSize;
            byte[] gc = this.calculateAllGcs(refBases, this.windowsByGc, lastWindowStart);
            this.gcByRef.put(refName, gc);
        }
        this.multiCollector = new GcBiasMetricsCollector(this.METRIC_ACCUMULATION_LEVEL, this.gcByRef, this.windowsByGc, header.getReadGroups(), this.windowSize, this.IS_BISULFITE_SEQUENCED);
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence ref) {
        this.multiCollector.acceptRecord(rec, ref);
    }

    @Override
    protected void finish() {
        this.multiCollector.finish();
        MetricsFile file = this.getMetricsFile();
        MetricsFile detailMetricsFile = this.getMetricsFile();
        MetricsFile summaryMetricsFile = this.getMetricsFile();
        this.multiCollector.addAllLevelsToFile(file);
        List gcBiasMetricsList = file.getMetrics();
        for (GcBiasMetrics gcbm : gcBiasMetricsList) {
            List gcDetailList = gcbm.DETAILS.getMetrics();
            for (GcBiasDetailMetrics d : gcDetailList) {
                detailMetricsFile.addMetric((MetricBase)d);
            }
            summaryMetricsFile.addMetric((MetricBase)gcbm.SUMMARY);
        }
        detailMetricsFile.write(this.OUTPUT);
        summaryMetricsFile.write(this.SUMMARY_OUTPUT);
        NumberFormat fmt = NumberFormat.getIntegerInstance();
        fmt.setGroupingUsed(true);
        RExecutor.executeFromClasspath(R_SCRIPT, this.OUTPUT.getAbsolutePath(), this.SUMMARY_OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath(), String.valueOf(this.WINDOW_SIZE));
    }

    private byte[] calculateAllGcs(byte[] refBases, int[] windowsByGc, int lastWindowStart) {
        CalculateGcState state = new CalculateGcState();
        int refLength = refBases.length;
        byte[] gc = new byte[refLength + 1];
        for (int i = 1; i < lastWindowStart; ++i) {
            int windowEnd = i + this.windowSize;
            int windowGc = this.calculateGc(refBases, i, windowEnd, state);
            gc[i] = (byte)windowGc;
            if (windowGc == -1) continue;
            int n = windowGc;
            windowsByGc[n] = windowsByGc[n] + 1;
        }
        return gc;
    }

    private int calculateGc(byte[] bases, int startIndex, int endIndex, CalculateGcState state) {
        if (state.init) {
            state.init = false;
            state.gcCount = 0;
            state.nCount = 0;
            for (int i = startIndex; i < endIndex; ++i) {
                byte base = bases[i];
                if (base == 71 || base == 67) {
                    ++state.gcCount;
                    continue;
                }
                if (base != 78) continue;
                ++state.nCount;
            }
        } else {
            byte newBase = bases[endIndex - 1];
            if (newBase == 71 || newBase == 67) {
                ++state.gcCount;
            } else if (newBase == 78) {
                ++state.nCount;
            }
            if (state.priorBase == 71 || state.priorBase == 67) {
                --state.gcCount;
            } else if (state.priorBase == 78) {
                --state.nCount;
            }
        }
        state.priorBase = bases[startIndex];
        if (state.nCount > 4) {
            return -1;
        }
        return state.gcCount * 100 / (endIndex - startIndex);
    }

    class CalculateGcState {
        boolean init = true;
        int nCount;
        int gcCount;
        byte priorBase;

        CalculateGcState() {
        }
    }
}

