/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.util.CollectionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import picard.PicardException;
import picard.analysis.CollectAlignmentSummaryMetrics;
import picard.analysis.CollectBaseDistributionByCycle;
import picard.analysis.CollectGcBiasMetrics;
import picard.analysis.CollectInsertSizeMetrics;
import picard.analysis.CollectRnaSeqMetrics;
import picard.analysis.MeanQualityByCycle;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.QualityScoreDistribution;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;

@CommandLineProgramProperties(usage="Takes an input BAM and reference sequence and runs one or more Picard metrics modules at the same time to cut down on I/O. Currently all programs are run with default options and fixed output extesions, but this may become more flexible in future.", usageShort="A \"meta-metrics\" calculating program that produces multiple metrics for the provided SAM/BAM", programGroup=Metrics.class)
public class CollectMultipleMetrics
extends CommandLineProgram {
    @Option(shortName="I", doc="Input SAM or BAM file.")
    public File INPUT;
    @Option(doc="If true (default), then the sort order in the header file will be ignored.", shortName="AS")
    public boolean ASSUME_SORTED = true;
    @Option(doc="Stop after processing N reads, mainly for debugging.")
    public int STOP_AFTER = 0;
    @Option(shortName="O", doc="Base name of output files.")
    public String OUTPUT;
    @Option(doc="List of metrics programs to apply during the pass through the SAM file.")
    public List<Program> PROGRAM = CollectionUtil.makeList((Object[])new Program[]{Program.CollectAlignmentSummaryMetrics, Program.CollectBaseDistributionByCycle, Program.CollectInsertSizeMetrics, Program.MeanQualityByCycle, Program.QualityScoreDistribution});
    private List<ProgramInterface> programsToRun;

    public static void main(String[] args) {
        new CollectMultipleMetrics().instanceMainWithExit(args);
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.PROGRAM.isEmpty()) {
            return new String[]{"No programs specified with PROGRAM"};
        }
        this.programsToRun = new ArrayList<Program>(this.PROGRAM);
        return super.customCommandLineValidation();
    }

    public void setProgramsToRun(List<ProgramInterface> programsToRun) {
        this.programsToRun = programsToRun;
    }

    @Override
    public int doWork() {
        if (this.OUTPUT.endsWith(".")) {
            this.OUTPUT = this.OUTPUT.substring(0, this.OUTPUT.length() - 1);
        }
        ArrayList<SinglePassSamProgram> programs = new ArrayList<SinglePassSamProgram>();
        for (ProgramInterface program : new HashSet<ProgramInterface>(this.programsToRun)) {
            if (program.needsReferenceSequence() && this.REFERENCE_SEQUENCE == null) {
                throw new PicardException("The " + program.toString() + " program needs a Reference Sequence, please set REFERENCE_SEQUENCE in the command line");
            }
            SinglePassSamProgram instance = program.makeInstance(this.OUTPUT, this.INPUT, this.REFERENCE_SEQUENCE);
            instance.INPUT = this.INPUT;
            instance.REFERENCE_SEQUENCE = this.REFERENCE_SEQUENCE;
            instance.setDefaultHeaders(this.getDefaultHeaders());
            programs.add(instance);
        }
        SinglePassSamProgram.makeItSo(this.INPUT, this.REFERENCE_SEQUENCE, this.ASSUME_SORTED, this.STOP_AFTER, programs);
        return 0;
    }

    public static enum Program implements ProgramInterface
    {
        CollectAlignmentSummaryMetrics{

            @Override
            public boolean needsReferenceSequence() {
                return false;
            }

            @Override
            public SinglePassSamProgram makeInstance(String outbase, File input, File reference) {
                CollectAlignmentSummaryMetrics program = new CollectAlignmentSummaryMetrics();
                program.OUTPUT = new File(outbase + ".alignment_summary_metrics");
                program.INPUT = input;
                program.REFERENCE_SEQUENCE = reference;
                return program;
            }
        }
        ,
        CollectInsertSizeMetrics{

            @Override
            public boolean needsReferenceSequence() {
                return false;
            }

            @Override
            public SinglePassSamProgram makeInstance(String outbase, File input, File reference) {
                CollectInsertSizeMetrics program = new CollectInsertSizeMetrics();
                program.OUTPUT = new File(outbase + ".insert_size_metrics");
                program.Histogram_FILE = new File(outbase + ".insert_size_histogram.pdf");
                program.INPUT = input;
                program.REFERENCE_SEQUENCE = reference;
                return program;
            }
        }
        ,
        QualityScoreDistribution{

            @Override
            public boolean needsReferenceSequence() {
                return false;
            }

            @Override
            public SinglePassSamProgram makeInstance(String outbase, File input, File reference) {
                QualityScoreDistribution program = new QualityScoreDistribution();
                program.OUTPUT = new File(outbase + ".quality_distribution_metrics");
                program.CHART_OUTPUT = new File(outbase + ".quality_distribution.pdf");
                program.INPUT = input;
                program.REFERENCE_SEQUENCE = reference;
                return program;
            }
        }
        ,
        MeanQualityByCycle{

            @Override
            public boolean needsReferenceSequence() {
                return false;
            }

            @Override
            public SinglePassSamProgram makeInstance(String outbase, File input, File reference) {
                MeanQualityByCycle program = new MeanQualityByCycle();
                program.OUTPUT = new File(outbase + ".quality_by_cycle_metrics");
                program.CHART_OUTPUT = new File(outbase + ".quality_by_cycle.pdf");
                program.INPUT = input;
                program.REFERENCE_SEQUENCE = reference;
                return program;
            }
        }
        ,
        CollectBaseDistributionByCycle{

            @Override
            public boolean needsReferenceSequence() {
                return false;
            }

            @Override
            public SinglePassSamProgram makeInstance(String outbase, File input, File reference) {
                CollectBaseDistributionByCycle program = new CollectBaseDistributionByCycle();
                program.OUTPUT = new File(outbase + ".base_distribution_by_cycle_metrics");
                program.CHART_OUTPUT = new File(outbase + ".base_distribution_by_cycle.pdf");
                program.INPUT = input;
                program.REFERENCE_SEQUENCE = reference;
                return program;
            }
        }
        ,
        CollectGcBiasMetrics{

            @Override
            public boolean needsReferenceSequence() {
                return true;
            }

            @Override
            public SinglePassSamProgram makeInstance(String outbase, File input, File reference) {
                CollectGcBiasMetrics program = new CollectGcBiasMetrics();
                program.OUTPUT = new File(outbase + ".gc_bias.detail_metrics");
                program.SUMMARY_OUTPUT = new File(outbase + ".gc_bias.summary_metrics");
                program.CHART_OUTPUT = new File(outbase + ".gc_bias.pdf");
                program.INPUT = input;
                program.METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet((Object[])new MetricAccumulationLevel[]{MetricAccumulationLevel.ALL_READS, MetricAccumulationLevel.LIBRARY});
                program.WINDOW_SIZE = 100;
                program.MINIMUM_GENOME_FRACTION = 1.0E-5;
                program.IS_BISULFITE_SEQUENCED = false;
                program.ASSUME_SORTED = false;
                program.REFERENCE_SEQUENCE = reference;
                return program;
            }
        }
        ,
        RnaSeqMetrics{

            @Override
            public boolean needsReferenceSequence() {
                return true;
            }

            @Override
            public SinglePassSamProgram makeInstance(String outbase, File input, File reference) {
                CollectRnaSeqMetrics program = new CollectRnaSeqMetrics();
                program.OUTPUT = new File(outbase + ".rna_metrics");
                program.CHART_OUTPUT = new File(outbase + ".rna_coverage.pdf");
                program.INPUT = input;
                program.REFERENCE_SEQUENCE = reference;
                return program;
            }
        };

    }

    public static interface ProgramInterface {
        public SinglePassSamProgram makeInstance(String var1, File var2, File var3);

        public boolean needsReferenceSequence();
    }
}

