/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.processor;

import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.util.Interval;
import java.io.File;

public abstract class VcfFileSegment {
    public abstract int start();

    public abstract int stop();

    public abstract String contig();

    public abstract File vcf();

    public Interval correspondingInterval() {
        return new Interval(this.contig(), this.start(), this.stop());
    }

    public String toString() {
        return this.vcf().getName() + "::" + this.contig() + ":" + this.start() + "-" + this.stop();
    }

    static VcfFileSegment ofWholeSequence(SAMSequenceRecord sequence, File vcf) {
        return new SequenceSizedChunk(sequence, vcf);
    }

    static class SequenceSizedChunk
    extends VcfFileSegment {
        final SAMSequenceRecord sequence;
        final File vcf;

        private SequenceSizedChunk(SAMSequenceRecord sequence, File vcf) {
            this.sequence = sequence;
            this.vcf = vcf;
        }

        @Override
        public String toString() {
            return this.vcf().getAbsolutePath() + "::" + this.sequence.getSequenceName() + ":1-" + this.sequence.getSequenceLength();
        }

        @Override
        public int start() {
            return 1;
        }

        @Override
        public int stop() {
            return this.sequence.getSequenceLength();
        }

        @Override
        public String contig() {
            return this.sequence.getSequenceName();
        }

        @Override
        public File vcf() {
            return this.vcf;
        }
    }
}

