/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.PositionalArguments;
import picard.cmdline.programgroups.Metrics;

@CommandLineProgramProperties(usage="Compare two metrics files", usageShort="Compare two metrics files", programGroup=Metrics.class)
public class CompareMetrics
extends CommandLineProgram {
    static final String USAGE = "Compare two metrics files";
    @PositionalArguments(minElements=2, maxElements=2)
    public List<File> metricsFiles;
    private static final Log log = Log.getInstance(CompareMetrics.class);

    @Override
    protected int doWork() {
        IOUtil.assertFilesAreReadable(this.metricsFiles);
        MetricsFile metricsA = new MetricsFile();
        MetricsFile metricsB = new MetricsFile();
        try {
            metricsA.read(new FileReader(this.metricsFiles.get(0)));
            metricsB.read(new FileReader(this.metricsFiles.get(1)));
            boolean areEqual = metricsA.areMetricsEqual(metricsB) && metricsA.areHistogramsEqual(metricsB);
            String status = areEqual ? "EQUAL" : "NOT EQUAL";
            log.info("Files " + this.metricsFiles.get(0) + " and " + this.metricsFiles.get(1) + "are " + status);
        }
        catch (Exception e) {
            throw new PicardException(e.getMessage());
        }
        return 0;
    }

    public static void main(String[] argv) {
        new CompareMetrics().instanceMainWithExit(argv);
    }
}

