/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.artifacts;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.SequenceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import picard.analysis.CollectOxoGMetrics;
import picard.analysis.artifacts.SequencingArtifactMetrics;
import picard.analysis.artifacts.Transition;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;

@CommandLineProgramProperties(usage="Extract OxoG metrics format from generalized artifact metrics.", usageShort="Extract OxoG metrics format from generalized artifact metrics.", programGroup=Metrics.class)
public class ConvertSequencingArtifactToOxoG
extends CommandLineProgram {
    static final String USAGE = "Extract OxoG metrics format from generalized artifact metrics.";
    @Option(shortName="I", doc="Basename for input artifact metrics")
    public File INPUT_BASE;
    @Option(shortName="O", doc="Basename for output OxoG metrics. Defaults to same basename as input metrics", optional=true)
    public File OUTPUT_BASE;

    public static void main(String[] args) {
        new ConvertSequencingArtifactToOxoG().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        Transition transition;
        if (this.OUTPUT_BASE == null) {
            this.OUTPUT_BASE = this.INPUT_BASE;
        }
        File PRE_ADAPTER_IN = new File(this.INPUT_BASE + ".pre_adapter_detail_metrics");
        File BAIT_BIAS_IN = new File(this.INPUT_BASE + ".bait_bias_detail_metrics");
        File OXOG_OUT = new File(this.OUTPUT_BASE + ".oxog_metrics");
        IOUtil.assertFileIsReadable(PRE_ADAPTER_IN);
        IOUtil.assertFileIsReadable(BAIT_BIAS_IN);
        IOUtil.assertFileIsWritable(OXOG_OUT);
        List<MetricBase> preAdapterDetailMetricsList = MetricsFile.readBeans(PRE_ADAPTER_IN);
        List<MetricBase> baitBiasDetailMetricsList = MetricsFile.readBeans(BAIT_BIAS_IN);
        String oxogSampleAlias = ((SequencingArtifactMetrics.PreAdapterDetailMetrics)preAdapterDetailMetricsList.get((int)0)).SAMPLE_ALIAS;
        HashSet<String> oxogLibraries = new HashSet<String>();
        HashSet<String> oxogContexts = new HashSet<String>();
        for (SequencingArtifactMetrics.PreAdapterDetailMetrics preAdapterDetailMetrics : preAdapterDetailMetricsList) {
            oxogLibraries.add(preAdapterDetailMetrics.LIBRARY);
            if (preAdapterDetailMetrics.REF_BASE != 'C') continue;
            oxogContexts.add(preAdapterDetailMetrics.CONTEXT);
        }
        HashMap preAdapterDetailMetricsMap = new HashMap();
        HashMap hashMap = new HashMap();
        for (String string : oxogLibraries) {
            HashMap contextsToPreAdapter = new HashMap();
            HashMap contextsToBaitBias = new HashMap();
            preAdapterDetailMetricsMap.put(string, contextsToPreAdapter);
            hashMap.put(string, contextsToBaitBias);
        }
        for (SequencingArtifactMetrics.PreAdapterDetailMetrics preAdapterDetailMetrics : preAdapterDetailMetricsList) {
            transition = Transition.transitionOf(preAdapterDetailMetrics.REF_BASE, preAdapterDetailMetrics.ALT_BASE);
            if (!this.isOxoG(transition)) continue;
            ((Map)preAdapterDetailMetricsMap.get(preAdapterDetailMetrics.LIBRARY)).put(preAdapterDetailMetrics.CONTEXT, preAdapterDetailMetrics);
        }
        for (SequencingArtifactMetrics.BaitBiasDetailMetrics baitBiasDetailMetrics : baitBiasDetailMetricsList) {
            transition = Transition.transitionOf(baitBiasDetailMetrics.REF_BASE, baitBiasDetailMetrics.ALT_BASE);
            if (!this.isOxoG(transition)) continue;
            ((Map)hashMap.get(baitBiasDetailMetrics.LIBRARY)).put(baitBiasDetailMetrics.CONTEXT, baitBiasDetailMetrics);
        }
        ArrayList<CollectOxoGMetrics.CpcgMetrics> oxogMetrics = new ArrayList<CollectOxoGMetrics.CpcgMetrics>();
        for (String library : oxogLibraries) {
            for (String context : oxogContexts) {
                CollectOxoGMetrics.CpcgMetrics m = new CollectOxoGMetrics.CpcgMetrics();
                m.SAMPLE_ALIAS = oxogSampleAlias;
                m.LIBRARY = library;
                m.CONTEXT = context;
                m.TOTAL_SITES = 0;
                SequencingArtifactMetrics.PreAdapterDetailMetrics preAdapter = (SequencingArtifactMetrics.PreAdapterDetailMetrics)((Map)preAdapterDetailMetricsMap.get(library)).get(SequenceUtil.reverseComplement(context));
                SequencingArtifactMetrics.BaitBiasDetailMetrics baitBiasFwd = (SequencingArtifactMetrics.BaitBiasDetailMetrics)((Map)hashMap.get(library)).get(context);
                SequencingArtifactMetrics.BaitBiasDetailMetrics baitBiasRev = (SequencingArtifactMetrics.BaitBiasDetailMetrics)((Map)hashMap.get(library)).get(SequenceUtil.reverseComplement(context));
                m.TOTAL_BASES = preAdapter.PRO_REF_BASES + preAdapter.PRO_ALT_BASES + preAdapter.CON_REF_BASES + preAdapter.CON_ALT_BASES;
                m.REF_TOTAL_BASES = preAdapter.PRO_REF_BASES + preAdapter.CON_REF_BASES;
                m.REF_NONOXO_BASES = preAdapter.CON_REF_BASES;
                m.REF_OXO_BASES = preAdapter.PRO_REF_BASES;
                m.ALT_NONOXO_BASES = preAdapter.CON_ALT_BASES;
                m.ALT_OXO_BASES = preAdapter.PRO_ALT_BASES;
                m.OXIDATION_ERROR_RATE = preAdapter.ERROR_RATE;
                m.OXIDATION_Q = preAdapter.QSCORE;
                m.C_REF_REF_BASES = baitBiasFwd.FWD_CXT_REF_BASES;
                m.G_REF_REF_BASES = baitBiasFwd.REV_CXT_REF_BASES;
                m.C_REF_ALT_BASES = baitBiasFwd.FWD_CXT_ALT_BASES;
                m.G_REF_ALT_BASES = baitBiasFwd.REV_CXT_ALT_BASES;
                m.C_REF_OXO_ERROR_RATE = baitBiasFwd.ERROR_RATE;
                m.C_REF_OXO_Q = baitBiasFwd.QSCORE;
                m.G_REF_OXO_ERROR_RATE = baitBiasRev.ERROR_RATE;
                m.G_REF_OXO_Q = baitBiasRev.QSCORE;
                oxogMetrics.add(m);
            }
        }
        MetricsFile metricsFile = this.getMetricsFile();
        for (CollectOxoGMetrics.CpcgMetrics m : oxogMetrics) {
            metricsFile.addMetric(m);
        }
        metricsFile.write(OXOG_OUT);
        return 0;
    }

    private boolean isOxoG(Transition t) {
        return t.equals((Object)Transition.CtoA) || t.equals((Object)Transition.GtoT);
    }
}

