/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.AsciiWriter;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.SamRecordIntervalIteratorFactory;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Prints a SAM or BAM file to the screen.", usageShort="Prints a SAM or BAM file to the screen", programGroup=SamOrBam.class)
public class ViewSam
extends CommandLineProgram {
    public final String USAGE = this.getStandardUsagePreamble() + "Prints a SAM or BAM file to the screen.";
    @Option(shortName="I", doc="The SAM or BAM file or GA4GH url to view.")
    public String INPUT;
    @Option(doc="Print out all reads, just the aligned reads or just the unaligned reads.")
    public AlignmentStatus ALIGNMENT_STATUS = AlignmentStatus.All;
    @Option(doc="Print out all reads, just the PF reads or just the non-PF reads.")
    public PfStatus PF_STATUS = PfStatus.All;
    @Option(doc="Print the SAM header only.", optional=true)
    public boolean HEADER_ONLY = false;
    @Option(doc="Print the alignment records only.", optional=true)
    public boolean RECORDS_ONLY = false;
    @Option(doc="An intervals file used to restrict what records are output.", optional=true)
    public File INTERVAL_LIST;

    public static void main(String[] args) {
        new ViewSam().instanceMain(args);
    }

    @Override
    protected int doWork() {
        return this.writeSamText(System.out);
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.HEADER_ONLY && this.RECORDS_ONLY) {
            return new String[]{"Cannot specify both HEADER_ONLY=true and RECORDS_ONLY=true."};
        }
        return super.customCommandLineValidation();
    }

    int writeSamText(PrintStream printStream) {
        try {
            CloseableIterator<SAMRecord> samRecordsIterator;
            SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(SamInputResource.of(this.INPUT));
            if (this.HEADER_ONLY || this.INTERVAL_LIST == null) {
                samRecordsIterator = samReader.iterator();
            } else {
                IOUtil.assertFileIsReadable(this.INTERVAL_LIST);
                List<Interval> intervals = IntervalList.fromFile(this.INTERVAL_LIST).uniqued().getIntervals();
                samRecordsIterator = new SamRecordIntervalIteratorFactory().makeSamRecordIntervalIterator(samReader, intervals, samReader.hasIndex());
            }
            AsciiWriter writer = new AsciiWriter(printStream);
            SAMFileHeader header = samReader.getFileHeader();
            if (!this.RECORDS_ONLY) {
                if (header.getTextHeader() != null) {
                    writer.write(header.getTextHeader());
                } else {
                    new SAMTextHeaderCodec().encode(writer, header, true);
                }
            }
            if (!this.HEADER_ONLY) {
                while (samRecordsIterator.hasNext()) {
                    SAMRecord rec = (SAMRecord)samRecordsIterator.next();
                    if (printStream.checkError()) {
                        return 1;
                    }
                    if (this.ALIGNMENT_STATUS == AlignmentStatus.Aligned && rec.getReadUnmappedFlag() || this.ALIGNMENT_STATUS == AlignmentStatus.Unaligned && !rec.getReadUnmappedFlag() || this.PF_STATUS == PfStatus.PF && rec.getReadFailsVendorQualityCheckFlag() || this.PF_STATUS == PfStatus.NonPF && !rec.getReadFailsVendorQualityCheckFlag()) continue;
                    writer.write(rec.getSAMString());
                }
            }
            writer.flush();
            if (printStream.checkError()) {
                return 1;
            }
            CloserUtil.close(writer);
            CloserUtil.close(samRecordsIterator);
            return 0;
        }
        catch (IOException e) {
            throw new PicardException("Exception writing SAM text", e);
        }
    }

    public static enum PfStatus {
        PF,
        NonPF,
        All;

    }

    public static enum AlignmentStatus {
        Aligned,
        Unaligned,
        All;

    }
}

