/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.List;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.plus.annotation.PreDestroyCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreDestroyAnnotationHandler
implements AnnotationParser.AnnotationHandler {
    WebAppContext _wac;
    LifeCycleCallbackCollection _callbacks;

    public PreDestroyAnnotationHandler(WebAppContext wac) {
        this._wac = wac;
        this._callbacks = (LifeCycleCallbackCollection)this._wac.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection");
    }

    @Override
    public void handleClass(String className, int version, int access, String signature, String superName, String[] interfaces, String annotation, List<AnnotationParser.Value> values) {
        Log.warn("@PreDestroy annotation not applicable for classes: " + className);
    }

    @Override
    public void handleField(String className, String fieldName, int access, String fieldType, String signature, Object value, String annotation, List<AnnotationParser.Value> values) {
        Log.warn("@PreDestroy annotation not applicable for fields: " + className + "." + fieldName);
    }

    @Override
    public void handleMethod(String className, String methodName, int access, String desc, String signature, String[] exceptions, String annotation, List<AnnotationParser.Value> values) {
        try {
            Type[] args = Type.getArgumentTypes((String)desc);
            if (args.length != 0) {
                Log.warn("Skipping PreDestroy annotation on " + className + "." + methodName + ": has parameters");
                return;
            }
            if (Type.getReturnType((String)desc) != Type.VOID_TYPE) {
                Log.warn("Skipping PreDestroy annotation on " + className + "." + methodName + ": is not void");
                return;
            }
            if (exceptions != null && exceptions.length != 0) {
                Log.warn("Skipping PreDestroy annotation on " + className + "." + methodName + ": throws checked exceptions");
                return;
            }
            if ((access & 8) > 0) {
                Log.warn("Skipping PreDestroy annotation on " + className + "." + methodName + ": is static");
                return;
            }
            PreDestroyCallback callback = new PreDestroyCallback();
            callback.setTarget(className, methodName);
            this._callbacks.add(callback);
        }
        catch (Exception e) {
            Log.warn(e);
        }
    }
}

