/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.tools.ngs;

import fi.csc.chipster.tools.gbrowser.SamBamUtils;
import fi.csc.chipster.tools.ngs.LocalNGSPreprocess;
import fi.csc.microarray.analyser.java.JavaAnalysisJobBase;
import fi.csc.microarray.messaging.JobState;
import java.io.File;

public class PreprocessNGSSingle
extends JavaAnalysisJobBase {
    @Override
    public String getSADL() {
        return "TOOL PreprocessNGSSingle.java: \"Convert SAM to BAM, sort and index BAM\" (Converts SAM to BAM and sorts and indexes BAM files. Please note that this preprocessing is required for visualising the data in the Chipster Genome browser. This tools is based on the Picard package.)\nINPUT data.bam: \"Input bam file\" TYPE GENERIC\nOUTPUT preprocessed.bam: \"Preprocessed bam file\"\nOUTPUT preprocessed.bam.bai: \"Preprocessed bam index file\"\n";
    }

    @Override
    protected void execute() {
        this.updateStateToClient(JobState.RUNNING, "preprocessing");
        try {
            File inputFile = new File(this.jobWorkDir, this.analysis.getInputFiles().get(0).getFileName());
            File outputFile = new File(this.jobWorkDir, this.analysis.getOutputFiles().get(0).getFileName().getID());
            File indexOutputFile = new File(this.jobWorkDir, this.analysis.getOutputFiles().get(1).getFileName().getID());
            SamBamUtils samBamUtil = new SamBamUtils(new SamBamUtils.SamBamUtilStateListener(){

                @Override
                public void stateChanged(SamBamUtils.SamBamUtilState newState) {
                    PreprocessNGSSingle.this.updateStateDetailToClient("preprocess: " + newState.getState());
                }
            }, LocalNGSPreprocess.CHROMOSOME_NORMALISER);
            samBamUtil.preprocessSamBam(inputFile, outputFile, indexOutputFile);
        }
        catch (Exception e) {
            this.updateState(JobState.FAILED, e.getMessage());
            return;
        }
        this.updateStateToClient(JobState.RUNNING, "preprocessing finished");
    }
}

