/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.emboss;

import fi.csc.microarray.analyser.JobCancelledException;
import fi.csc.microarray.analyser.ToolDescription;
import fi.csc.microarray.analyser.emboss.ACDDescription;
import fi.csc.microarray.analyser.emboss.ACDParameter;
import fi.csc.microarray.analyser.shell.ShellAnalysisJob;
import fi.csc.microarray.analyser.shell.ShellAnalysisJobBase;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.util.Exceptions;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class EmbossAnalysisJob
extends ShellAnalysisJobBase {
    public static EmbossParameterSecurityPolicy EMBOSS_PARAMETER_SECURITY_POLICY = new EmbossParameterSecurityPolicy();
    private String toolDirectory;
    private String descriptionDirectory;
    static final Logger logger = Logger.getLogger(EmbossAnalysisJob.class);
    private HashMap<String, String> outputFormats = new HashMap();
    private LinkedList<EmbossQualifier> qualifiers;
    private ACDDescription acdDescription;

    public EmbossAnalysisJob(String toolDirectory, String descriptionDirectory) {
        this.toolDirectory = toolDirectory;
        this.descriptionDirectory = descriptionDirectory;
    }

    @Override
    protected void preExecute() throws JobCancelledException {
        LinkedList<String> inputParameters;
        super.preExecute();
        try {
            inputParameters = new LinkedList<String>(this.inputMessage.getParameters(EMBOSS_PARAMETER_SECURITY_POLICY, this.analysis));
        }
        catch (JobMessage.ParameterValidityException e) {
            this.outputMessage.setErrorMessage(e.getMessage());
            this.outputMessage.setOutputText(Exceptions.getStackTrace(e));
            this.updateState(JobState.FAILED_USER_ERROR, "");
            return;
        }
        this.acdDescription = this.getACD();
        LinkedList<ACDParameter> acdParameters = this.acdDescription.getParameters();
        HashMap<String, String> varMap = new HashMap<String, String>();
        Integer index = 0;
        for (ToolDescription.ParameterDescription param : this.analysis.getParameters()) {
            varMap.put(param.getName(), inputParameters.get(index));
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        this.acdDescription.updateVariables(varMap);
        HashMap<String, ACDParameter> analysisToACD = new HashMap<String, ACDParameter>();
        for (ToolDescription.ParameterDescription param : this.analysis.getParameters()) {
            ACDParameter mapTo = null;
            for (ACDParameter acdParam : acdParameters) {
                if (!acdParam.getName().equals(param.getName())) continue;
                mapTo = acdParam;
                break;
            }
            analysisToACD.put(param.getName(), mapTo);
        }
        index = 0;
        this.qualifiers = new LinkedList();
        for (ToolDescription.ParameterDescription param : this.analysis.getParameters()) {
            if (param.getName().startsWith("chipster_output_type_")) {
                String value = !inputParameters.get(index).equals("<undefined>") ? inputParameters.get(index) : null;
                this.outputFormats.put(param.getName().substring("chipster_output_type_".length()), value);
                continue;
            }
            EmbossQualifier qualifier = new EmbossQualifier((ACDParameter)analysisToACD.get(param.getName()), inputParameters.get(index));
            EmbossQualifier.ValidityCheck check = qualifier.validate();
            if (!check.passed()) {
                this.outputMessage.setErrorMessage(check.getMessage());
                this.updateState(JobState.FAILED_USER_ERROR, "Incorrect field value: " + param.getName());
                logger.debug((Object)check.getMessage());
                return;
            }
            this.qualifiers.add(qualifier);
            Integer n = index;
            Integer n3 = index = Integer.valueOf(index + 1);
        }
        this.command = this.commandLine();
    }

    private ACDDescription getACD() {
        String appName = this.analysis.getID();
        return new ACDDescription(new File(this.descriptionDirectory, appName));
    }

    private String[] commandLine() {
        LinkedList<String> params = new LinkedList<String>();
        params.add(new File(this.toolDirectory, this.analysis.getDisplayName()).getAbsolutePath());
        for (EmbossQualifier qualifier : this.qualifiers) {
            if (qualifier.getValue().equals("")) continue;
            params.add("-" + qualifier.getName());
            params.add("\"" + qualifier.getValue() + "\"");
        }
        for (String name : this.inputMessage.payloadNames()) {
            params.add("-" + name);
            params.add(name);
        }
        for (ACDParameter param : this.acdDescription.getOutputParameters()) {
            String format = this.outputFormats.get(param.getName());
            if (format != null) {
                if (param.getType().equals("align")) {
                    params.add("-aformat");
                } else {
                    params.add("-osformat");
                }
                params.add(format);
            }
            params.add("-" + param.getName());
            params.add(param.getOutputFilename(true));
        }
        for (ACDParameter param : this.acdDescription.getGraphicsParameters()) {
            params.add("-" + param.getName());
            params.add("png");
            params.add("-goutfile");
            params.add(param.getOutputFilename(false));
        }
        params.add("-auto");
        String[] cmd = new String[]{};
        return params.toArray(cmd);
    }

    class EmbossQualifier {
        ACDParameter acdParameter;
        String value;

        public EmbossQualifier(ACDParameter acdParameter, String value) {
            this.acdParameter = acdParameter;
            this.value = value;
        }

        public String getName() {
            return this.acdParameter.getName();
        }

        public String getValue() {
            return this.acdParameter.normalize(this.value);
        }

        public ValidityCheck validate() {
            if (this.acdParameter.isRequired().booleanValue() && this.value.equals("")) {
                return new ValidityCheck(false, "Parameter \"" + this.acdParameter.getName() + "\" can not be empty.");
            }
            if (!this.value.equals("") && !this.acdParameter.validate(this.value)) {
                return new ValidityCheck(false, "Incorrect value \"" + this.getValue() + "\" for \"" + this.acdParameter.getName() + "\" parameter");
            }
            return new ValidityCheck(true, null);
        }

        class ValidityCheck {
            private boolean passed;
            private String message;

            public ValidityCheck(boolean passed, String message) {
                this.passed = passed;
                this.message = message;
            }

            public boolean passed() {
                return this.passed;
            }

            public String getMessage() {
                return this.message;
            }
        }
    }

    public static class EmbossParameterSecurityPolicy
    extends ShellAnalysisJob.ShellParameterSecurityPolicy {
        @Override
        public boolean isValueValid(String value, ToolDescription.ParameterDescription parameterDescription) {
            return super.isValueValid(value, parameterDescription);
        }
    }
}

