/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.readers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.LineReader;
import org.broad.tribble.readers.PositionalBufferedStream;

public class AsciiLineReader
implements LineReader {
    private static final int BUFFER_OVERFLOW_INCREASE_FACTOR = 2;
    private static final byte LINEFEED = 10;
    private static final byte CARRIAGE_RETURN = 13;
    PositionalBufferedStream is;
    char[] lineBuffer;

    public AsciiLineReader() {
        this(null);
    }

    public AsciiLineReader(InputStream is) {
        this(new PositionalBufferedStream(is));
    }

    public AsciiLineReader(PositionalBufferedStream is) {
        this.is = is;
        this.lineBuffer = new char[10000];
    }

    public long getPosition() {
        if (this.is == null) {
            throw new TribbleException("getPosition() called but no default stream was provided to the class on creation");
        }
        return this.is.getPosition();
    }

    public final String readLine(PositionalBufferedStream stream) throws IOException {
        int linePosition = 0;
        while (true) {
            int b;
            if ((b = stream.read()) == -1) {
                if (linePosition > 0) {
                    return new String(this.lineBuffer, 0, linePosition);
                }
                return null;
            }
            char c = (char)(b & 0xFF);
            if (c == '\n' || c == '\r') {
                if (c == '\r' && stream.peek() == 10) {
                    stream.read();
                }
                return new String(this.lineBuffer, 0, linePosition);
            }
            if (linePosition > this.lineBuffer.length - 3) {
                char[] temp = new char[2 * this.lineBuffer.length];
                System.arraycopy(this.lineBuffer, 0, temp, 0, this.lineBuffer.length);
                this.lineBuffer = temp;
            }
            this.lineBuffer[linePosition++] = c;
        }
    }

    @Override
    public final String readLine() throws IOException {
        if (this.is == null) {
            throw new TribbleException("readLine() called without an explicit stream argument but no default stream was provided to the class on creation");
        }
        return this.readLine(this.is);
    }

    @Override
    public void close() {
        if (this.is != null) {
            this.is.close();
        }
        this.lineBuffer = null;
    }

    public static void main(String[] args) throws Exception {
        File testFile = new File("test/data/hapmap_3.3.b37.sites.vcf");
        int i = 0;
        while (i < 3) {
            BufferedReader reader2 = new BufferedReader(new FileReader(testFile));
            long t0 = System.currentTimeMillis();
            long lineCount = 0L;
            while (reader2.readLine() != null) {
                ++lineCount;
            }
            long dt = System.currentTimeMillis() - t0;
            double rate = (double)lineCount / (double)dt;
            AsciiLineReader.printStatus("BR", lineCount, rate, dt);
            reader2.close();
            PositionalBufferedStream pbs = new PositionalBufferedStream(new FileInputStream(testFile));
            AsciiLineReader reader = new AsciiLineReader(pbs);
            t0 = System.currentTimeMillis();
            lineCount = 0L;
            while (reader.readLine() != null) {
                ++lineCount;
            }
            dt = System.currentTimeMillis() - t0;
            rate = (double)lineCount / (double)dt;
            AsciiLineReader.printStatus("AR", lineCount, rate, dt);
            pbs.close();
            ++i;
        }
    }

    private static final void printStatus(String name, long lineCount, double rate, long dt) {
        System.out.printf("%s: %d lines read.  Rate = %.2e lines per second.  DT = %d%n", name, lineCount, rate, dt);
    }
}

