/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.jms.JMSException;
import org.apache.activemq.broker.BrokerContext;
import org.apache.activemq.command.Command;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.transport.stomp.FrameTranslator;
import org.apache.activemq.transport.stomp.ProtocolConverter;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.transport.stomp.StompTransport;
import org.apache.activemq.transport.tcp.SslTransport;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StompTransportFilter
extends TransportFilter
implements StompTransport {
    private static final Log LOG = LogFactory.getLog(StompTransportFilter.class);
    private final ProtocolConverter protocolConverter;
    private final FrameTranslator frameTranslator;
    private boolean trace;

    public StompTransportFilter(Transport next, FrameTranslator translator, BrokerContext brokerContext) {
        super(next);
        this.frameTranslator = translator;
        this.protocolConverter = new ProtocolConverter(this, translator, brokerContext);
    }

    public void oneway(Object o) throws IOException {
        try {
            Command command = (Command)o;
            this.protocolConverter.onActiveMQCommand(command);
        }
        catch (JMSException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    public void onCommand(Object command) {
        try {
            if (this.trace) {
                LOG.trace("Received: \n" + command);
            }
            this.protocolConverter.onStompCommand((StompFrame)command);
        }
        catch (IOException e) {
            this.onException(e);
        }
        catch (JMSException e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    public void sendToActiveMQ(Command command) {
        TransportListener l = this.transportListener;
        if (l != null) {
            l.onCommand(command);
        }
    }

    public void sendToStomp(StompFrame command) throws IOException {
        Transport n;
        if (this.trace) {
            LOG.trace("Sending: \n" + command);
        }
        if ((n = this.next) != null) {
            n.oneway(command);
        }
    }

    public FrameTranslator getFrameTranslator() {
        return this.frameTranslator;
    }

    public X509Certificate[] getPeerCertificates() {
        if (this.next instanceof SslTransport) {
            X509Certificate[] peerCerts = ((SslTransport)this.next).getPeerCertificates();
            if (this.trace && peerCerts != null) {
                LOG.debug("Peer Identity has been verified\n");
            }
            return peerCerts;
        }
        return null;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }
}

