/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import javax.jms.ResourceAllocationException;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.BaseDestination;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.DurableTopicSubscription;
import org.apache.activemq.broker.region.LockOwner;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.policy.DispatchPolicy;
import org.apache.activemq.broker.region.policy.NoSubscriptionRecoveryPolicy;
import org.apache.activemq.broker.region.policy.SimpleDispatchPolicy;
import org.apache.activemq.broker.region.policy.SubscriptionRecoveryPolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerAck;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.filter.NonCachedMessageEvaluationContext;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.thread.Valve;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.util.SubscriptionKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Topic
extends BaseDestination
implements Task {
    protected static final Log LOG = LogFactory.getLog(Topic.class);
    private final TopicMessageStore topicStore;
    protected final CopyOnWriteArrayList<Subscription> consumers = new CopyOnWriteArrayList();
    protected final Valve dispatchValve = new Valve(true);
    private DispatchPolicy dispatchPolicy = new SimpleDispatchPolicy();
    private SubscriptionRecoveryPolicy subscriptionRecoveryPolicy;
    private final ConcurrentHashMap<SubscriptionKey, DurableTopicSubscription> durableSubcribers = new ConcurrentHashMap();
    private final TaskRunner taskRunner;
    private final LinkedList<Runnable> messagesWaitingForSpace = new LinkedList();
    private final Runnable sendMessagesWaitingForSpaceTask = new Runnable(){

        public void run() {
            try {
                Topic.this.taskRunner.wakeup();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };

    public Topic(BrokerService brokerService, ActiveMQDestination destination, TopicMessageStore store, DestinationStatistics parentStats, TaskRunnerFactory taskFactory) throws Exception {
        super(brokerService, store, destination, parentStats);
        this.topicStore = store;
        this.subscriptionRecoveryPolicy = new NoSubscriptionRecoveryPolicy();
        this.taskRunner = taskFactory.createTaskRunner(this, "Topic  " + destination.getPhysicalName());
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        if (this.store != null) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Subscription> getConsumers() {
        CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.consumers;
        synchronized (copyOnWriteArrayList) {
            return new ArrayList<Subscription>(this.consumers);
        }
    }

    public boolean lock(MessageReference node, LockOwner sub) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSubscription(ConnectionContext context, Subscription sub) throws Exception {
        super.addSubscription(context, sub);
        if (!sub.getConsumerInfo().isDurable()) {
            if (sub.getConsumerInfo().isRetroactive()) {
                this.dispatchValve.turnOff();
                try {
                    CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.consumers;
                    synchronized (copyOnWriteArrayList) {
                        sub.add(context, this);
                        this.consumers.add(sub);
                    }
                    this.subscriptionRecoveryPolicy.recover(context, this, sub);
                }
                finally {
                    this.dispatchValve.turnOn();
                }
            }
            CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.consumers;
            synchronized (copyOnWriteArrayList) {
                sub.add(context, this);
                this.consumers.add(sub);
            }
        }
        sub.add(context, this);
        DurableTopicSubscription dsub = (DurableTopicSubscription)sub;
        this.durableSubcribers.put(dsub.getSubscriptionKey(), dsub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubscription(ConnectionContext context, Subscription sub, long lastDeliveredSequenceId) throws Exception {
        if (!sub.getConsumerInfo().isDurable()) {
            super.removeSubscription(context, sub, lastDeliveredSequenceId);
            CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.consumers;
            synchronized (copyOnWriteArrayList) {
                this.consumers.remove(sub);
            }
        }
        sub.remove(context, this);
    }

    public void deleteSubscription(ConnectionContext context, SubscriptionKey key) throws Exception {
        if (this.topicStore != null) {
            this.topicStore.deleteSubscription(key.clientId, key.subscriptionName);
            DurableTopicSubscription removed = this.durableSubcribers.remove(key);
            if (removed != null) {
                this.destinationStatistics.getConsumers().decrement();
                removed.deactivate(false);
                this.consumers.remove(removed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(ConnectionContext context, final DurableTopicSubscription subscription) throws Exception {
        this.dispatchValve.turnOff();
        try {
            Object s1;
            if (this.topicStore == null) {
                return;
            }
            String clientId = subscription.getSubscriptionKey().getClientId();
            String subscriptionName = subscription.getSubscriptionKey().getSubscriptionName();
            String selector = subscription.getConsumerInfo().getSelector();
            SubscriptionInfo info = this.topicStore.lookupSubscription(clientId, subscriptionName);
            if (info != null) {
                s1 = info.getSelector();
                if (s1 == null ^ selector == null || s1 != null && !((String)s1).equals(selector)) {
                    this.topicStore.deleteSubscription(clientId, subscriptionName);
                    info = null;
                } else {
                    CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.consumers;
                    synchronized (copyOnWriteArrayList) {
                        this.consumers.add(subscription);
                    }
                }
            }
            if (info == null) {
                info = new SubscriptionInfo();
                info.setClientId(clientId);
                info.setSelector(selector);
                info.setSubscriptionName(subscriptionName);
                info.setDestination(this.getActiveMQDestination());
                info.setSubscribedDestination(subscription.getConsumerInfo().getDestination());
                s1 = this.consumers;
                synchronized (s1) {
                    this.consumers.add(subscription);
                    this.topicStore.addSubsciption(info, subscription.getConsumerInfo().isRetroactive());
                }
            }
            final NonCachedMessageEvaluationContext msgContext = new NonCachedMessageEvaluationContext();
            msgContext.setDestination(this.destination);
            if (subscription.isRecoveryRequired()) {
                this.topicStore.recoverSubscription(clientId, subscriptionName, new MessageRecoveryListener(){

                    public boolean recoverMessage(Message message) throws Exception {
                        message.setRegionDestination(Topic.this);
                        try {
                            msgContext.setMessageReference(message);
                            if (subscription.matches(message, msgContext)) {
                                subscription.add(message);
                            }
                        }
                        catch (IOException e) {
                            LOG.error((Object)("Failed to recover this message " + message));
                        }
                        return true;
                    }

                    public boolean recoverMessageReference(MessageId messageReference) throws Exception {
                        throw new RuntimeException("Should not be called.");
                    }

                    public boolean hasSpace() {
                        return true;
                    }

                    public boolean isDuplicate(MessageId id) {
                        return false;
                    }
                });
            }
        }
        finally {
            this.dispatchValve.turnOn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(ConnectionContext context, DurableTopicSubscription sub) throws Exception {
        CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.consumers;
        synchronized (copyOnWriteArrayList) {
            this.consumers.remove(sub);
        }
        sub.remove(context, this);
    }

    protected void recoverRetroactiveMessages(ConnectionContext context, Subscription subscription) throws Exception {
        if (subscription.getConsumerInfo().isRetroactive()) {
            this.subscriptionRecoveryPolicy.recover(context, this, subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(final ProducerBrokerExchange producerExchange, final Message message) throws Exception {
        boolean sendProducerAck;
        final ConnectionContext context = producerExchange.getConnectionContext();
        final ProducerInfo producerInfo = producerExchange.getProducerState().getInfo();
        boolean bl = sendProducerAck = !message.isResponseRequired() && producerInfo.getWindowSize() > 0 && !context.isInRecoveryMode();
        if (message.isExpired()) {
            this.broker.messageExpired(context, message);
            this.getDestinationStatistics().getExpired().increment();
            if (sendProducerAck) {
                ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), message.getSize());
                context.getConnection().dispatchAsync(ack);
            }
            return;
        }
        if (this.memoryUsage.isFull()) {
            this.isFull(context, this.memoryUsage);
            this.fastProducer(context, producerInfo);
            if (this.isProducerFlowControl() && context.isProducerFlowControl()) {
                if (this.warnOnProducerFlowControl) {
                    this.warnOnProducerFlowControl = false;
                    LOG.info((Object)("Usage Manager memory limit (" + this.memoryUsage.getLimit() + ") reached for " + this.getActiveMQDestination().getQualifiedName() + ". Producers will be throttled to the rate at which messages are removed from this destination to prevent flooding it." + " See http://activemq.apache.org/producer-flow-control.html for more info"));
                }
                if (this.systemUsage.isSendFailIfNoSpace()) {
                    throw new ResourceAllocationException("Usage Manager memory limit (" + this.memoryUsage.getLimit() + ") reached. Stopping producer (" + message.getProducerId() + ") to prevent flooding " + this.getActiveMQDestination().getQualifiedName() + "." + " See http://activemq.apache.org/producer-flow-control.html for more info");
                }
                if (producerInfo.getWindowSize() > 0 || message.isResponseRequired()) {
                    LinkedList<Runnable> ack = this.messagesWaitingForSpace;
                    synchronized (ack) {
                        this.messagesWaitingForSpace.add(new Runnable(){

                            public void run() {
                                block6: {
                                    try {
                                        if (message.isExpired()) {
                                            Topic.this.broker.messageExpired(context, message);
                                            Topic.this.getDestinationStatistics().getExpired().increment();
                                        } else {
                                            Topic.this.doMessageSend(producerExchange, message);
                                        }
                                        if (sendProducerAck) {
                                            ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), message.getSize());
                                            context.getConnection().dispatchAsync(ack);
                                        } else {
                                            Response response = new Response();
                                            response.setCorrelationId(message.getCommandId());
                                            context.getConnection().dispatchAsync(response);
                                        }
                                    }
                                    catch (Exception e) {
                                        if (sendProducerAck || context.isInRecoveryMode()) break block6;
                                        ExceptionResponse response = new ExceptionResponse(e);
                                        response.setCorrelationId(message.getCommandId());
                                        context.getConnection().dispatchAsync(response);
                                    }
                                }
                            }
                        });
                        if (!this.memoryUsage.notifyCallbackWhenNotFull(this.sendMessagesWaitingForSpaceTask)) {
                            this.sendMessagesWaitingForSpaceTask.run();
                        }
                        context.setDontSendReponse(true);
                        return;
                    }
                }
                if (this.memoryUsage.isFull()) {
                    if (context.isInTransaction()) {
                        int count = 0;
                        while (!this.memoryUsage.waitForSpace(1000L)) {
                            if (context.getStopping().get()) {
                                throw new IOException("Connection closed, send aborted.");
                            }
                            if (count <= 2 || !context.isInTransaction()) continue;
                            count = 0;
                            int size = context.getTransaction().size();
                            LOG.warn((Object)("Waiting for space to send  transacted message - transaction elements = " + size + " need more space to commit. Message = " + message));
                        }
                    } else {
                        this.waitForSpace(context, this.memoryUsage, "Usage Manager memory limit reached. Stopping producer (" + message.getProducerId() + ") to prevent flooding " + this.getActiveMQDestination().getQualifiedName() + "." + " See http://activemq.apache.org/producer-flow-control.html for more info");
                    }
                }
                if (message.isExpired()) {
                    this.getDestinationStatistics().getExpired().increment();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Expired message: " + message));
                    }
                    return;
                }
            }
        }
        this.doMessageSend(producerExchange, message);
        this.messageDelivered(context, message);
        if (sendProducerAck) {
            ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), message.getSize());
            context.getConnection().dispatchAsync(ack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void doMessageSend(ProducerBrokerExchange producerExchange, final Message message) throws IOException, Exception {
        final ConnectionContext context = producerExchange.getConnectionContext();
        message.setRegionDestination(this);
        message.getMessageId().setBrokerSequenceId(this.getDestinationSequenceId());
        Future<Object> result = null;
        if (this.topicStore != null && message.isPersistent() && !this.canOptimizeOutPersistence()) {
            if (this.systemUsage.getStoreUsage().isFull(this.getStoreUsageHighWaterMark())) {
                String logMessage = "Usage Manager Store is Full, " + this.getStoreUsageHighWaterMark() + "% of " + this.systemUsage.getStoreUsage().getLimit() + ". Stopping producer (" + message.getProducerId() + ") to prevent flooding " + this.getActiveMQDestination().getQualifiedName() + "." + " See http://activemq.apache.org/producer-flow-control.html for more info";
                if (this.systemUsage.isSendFailIfNoSpace()) {
                    throw new ResourceAllocationException(logMessage);
                }
                this.waitForSpace(context, this.systemUsage.getStoreUsage(), this.getStoreUsageHighWaterMark(), logMessage);
            }
            result = this.topicStore.asyncAddTopicMessage(context, message);
        }
        message.incrementReferenceCount();
        if (context.isInTransaction()) {
            context.getTransaction().addSynchronization(new Synchronization(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterCommit() throws Exception {
                    if (Topic.this.broker.isExpired(message)) {
                        Topic.this.getDestinationStatistics().getExpired().increment();
                        Topic.this.broker.messageExpired(context, message);
                        message.decrementReferenceCount();
                        return;
                    }
                    try {
                        Topic.this.dispatch(context, message);
                    }
                    finally {
                        message.decrementReferenceCount();
                    }
                }
            });
        } else {
            try {
                this.dispatch(context, message);
            }
            finally {
                message.decrementReferenceCount();
            }
        }
        if (result != null && !result.isCancelled()) {
            try {
                result.get();
            }
            catch (CancellationException e) {
                // empty catch block
            }
        }
    }

    private boolean canOptimizeOutPersistence() {
        return this.durableSubcribers.size() == 0;
    }

    public String toString() {
        return "Topic: destination=" + this.destination.getPhysicalName() + ", subscriptions=" + this.consumers.size();
    }

    @Override
    public void acknowledge(ConnectionContext context, Subscription sub, MessageAck ack, MessageReference node) throws IOException {
        if (this.topicStore != null && node.isPersistent()) {
            DurableTopicSubscription dsub = (DurableTopicSubscription)sub;
            SubscriptionKey key = dsub.getSubscriptionKey();
            this.topicStore.acknowledge(context, key.getClientId(), key.getSubscriptionName(), node.getMessageId(), ack);
        }
        this.messageConsumed(context, node);
    }

    @Override
    public void gc() {
    }

    public Message loadMessage(MessageId messageId) throws IOException {
        return this.topicStore != null ? this.topicStore.getMessage(messageId) : null;
    }

    @Override
    public void start() throws Exception {
        this.subscriptionRecoveryPolicy.start();
        if (this.memoryUsage != null) {
            this.memoryUsage.start();
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.taskRunner != null) {
            this.taskRunner.shutdown();
        }
        this.subscriptionRecoveryPolicy.stop();
        if (this.memoryUsage != null) {
            this.memoryUsage.stop();
        }
        if (this.topicStore != null) {
            this.topicStore.stop();
        }
    }

    @Override
    public Message[] browse() {
        final CopyOnWriteArraySet<Message> result = new CopyOnWriteArraySet<Message>();
        try {
            if (this.topicStore != null) {
                this.topicStore.recover(new MessageRecoveryListener(){

                    public boolean recoverMessage(Message message) throws Exception {
                        result.add(message);
                        return true;
                    }

                    public boolean recoverMessageReference(MessageId messageReference) throws Exception {
                        return true;
                    }

                    public boolean hasSpace() {
                        return true;
                    }

                    public boolean isDuplicate(MessageId id) {
                        return false;
                    }
                });
                Message[] msgs = this.subscriptionRecoveryPolicy.browse(this.getActiveMQDestination());
                if (msgs != null) {
                    for (int i = 0; i < msgs.length; ++i) {
                        result.add(msgs[i]);
                    }
                }
            }
        }
        catch (Throwable e) {
            LOG.warn((Object)("Failed to browse Topic: " + this.getActiveMQDestination().getPhysicalName()), e);
        }
        return result.toArray(new Message[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean iterate() {
        LinkedList<Runnable> linkedList = this.messagesWaitingForSpace;
        synchronized (linkedList) {
            while (!this.memoryUsage.isFull() && !this.messagesWaitingForSpace.isEmpty()) {
                Runnable op = this.messagesWaitingForSpace.removeFirst();
                op.run();
            }
        }
        return false;
    }

    public DispatchPolicy getDispatchPolicy() {
        return this.dispatchPolicy;
    }

    public void setDispatchPolicy(DispatchPolicy dispatchPolicy) {
        this.dispatchPolicy = dispatchPolicy;
    }

    public SubscriptionRecoveryPolicy getSubscriptionRecoveryPolicy() {
        return this.subscriptionRecoveryPolicy;
    }

    public void setSubscriptionRecoveryPolicy(SubscriptionRecoveryPolicy subscriptionRecoveryPolicy) {
        this.subscriptionRecoveryPolicy = subscriptionRecoveryPolicy;
    }

    @Override
    public final void wakeup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dispatch(ConnectionContext context, Message message) throws Exception {
        this.destinationStatistics.getEnqueues().increment();
        this.dispatchValve.increment();
        MessageEvaluationContext msgContext = null;
        try {
            if (!this.subscriptionRecoveryPolicy.add(context, message)) {
                return;
            }
            CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.consumers;
            synchronized (copyOnWriteArrayList) {
                if (this.consumers.isEmpty()) {
                    this.onMessageWithNoConsumers(context, message);
                    return;
                }
            }
            msgContext = context.getMessageEvaluationContext();
            msgContext.setDestination(this.destination);
            msgContext.setMessageReference(message);
            if (this.dispatchPolicy.dispatch(message, msgContext, this.consumers)) return;
            this.onMessageWithNoConsumers(context, message);
            return;
        }
        finally {
            this.dispatchValve.decrement();
            if (msgContext != null) {
                msgContext.clear();
            }
        }
    }

    @Override
    public void messageExpired(ConnectionContext context, Subscription subs, MessageReference reference) {
        this.broker.messageExpired(context, reference);
        this.destinationStatistics.getEnqueues().decrement();
        this.destinationStatistics.getExpired().increment();
        MessageAck ack = new MessageAck();
        ack.setAckType((byte)2);
        ack.setDestination(this.destination);
        ack.setMessageID(reference.getMessageId());
        try {
            this.acknowledge(context, subs, ack, reference);
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to remove expired Message from the store ", (Throwable)e);
        }
    }

    @Override
    protected Log getLog() {
        return LOG;
    }
}

