/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.tool.schema.spi.Exporter;

public class StandardTableExporter
implements Exporter<Table> {
    protected final Dialect dialect;

    public StandardTableExporter(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public String[] getSqlCreateStrings(Table table, Metadata metadata) {
        QualifiedNameParser.NameParts tableName = new QualifiedNameParser.NameParts(Identifier.toIdentifier(table.getCatalog(), table.isCatalogQuoted()), Identifier.toIdentifier(table.getSchema(), table.isSchemaQuoted()), table.getNameIdentifier());
        JdbcEnvironment jdbcEnvironment = metadata.getDatabase().getJdbcEnvironment();
        StringBuilder buf = new StringBuilder(this.tableCreateString(table.hasPrimaryKey())).append(' ').append(jdbcEnvironment.getQualifiedObjectNameFormatter().format(tableName, jdbcEnvironment.getDialect())).append(" (");
        boolean isPrimaryKeyIdentity = table.hasPrimaryKey() && table.getIdentifierValue() != null && table.getIdentifierValue().isIdentityColumn(metadata.getIdentifierGeneratorFactory(), this.dialect);
        String pkColName = null;
        if (table.hasPrimaryKey()) {
            Column pkColumn = (Column)table.getPrimaryKey().getColumns().iterator().next();
            pkColName = pkColumn.getQuotedName(this.dialect);
        }
        Iterator columnItr = table.getColumnIterator();
        boolean isFirst = true;
        while (columnItr.hasNext()) {
            String columnComment;
            Column col = (Column)columnItr.next();
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(", ");
            }
            String colName = col.getQuotedName(this.dialect);
            buf.append(colName).append(' ');
            if (isPrimaryKeyIdentity && colName.equals(pkColName)) {
                if (this.dialect.hasDataTypeInIdentityColumn()) {
                    buf.append(col.getSqlType(this.dialect, metadata));
                }
                buf.append(' ').append(this.dialect.getIdentityColumnString(col.getSqlTypeCode(metadata)));
            } else {
                buf.append(col.getSqlType(this.dialect, metadata));
                String defaultValue = col.getDefaultValue();
                if (defaultValue != null) {
                    buf.append(" default ").append(defaultValue);
                }
                if (col.isNullable()) {
                    buf.append(this.dialect.getNullColumnString());
                } else {
                    buf.append(" not null");
                }
            }
            if (col.isUnique()) {
                String keyName = Constraint.generateName("UK_", table, col);
                UniqueKey uk = table.getOrCreateUniqueKey(keyName);
                uk.addColumn(col);
                buf.append(this.dialect.getUniqueDelegate().getColumnDefinitionUniquenessFragment(col));
            }
            if (col.getCheckConstraint() != null && this.dialect.supportsColumnCheck()) {
                buf.append(" check (").append(col.getCheckConstraint()).append(")");
            }
            if ((columnComment = col.getComment()) == null) continue;
            buf.append(this.dialect.getColumnComment(columnComment));
        }
        if (table.hasPrimaryKey()) {
            buf.append(", ").append(table.getPrimaryKey().sqlConstraintString(this.dialect));
        }
        this.applyTableCheck(table, buf);
        buf.append(')');
        this.applyTableTypeString(buf);
        ArrayList<String> sqlStrings = new ArrayList<String>();
        sqlStrings.add(buf.toString());
        this.applyComments(table, sqlStrings);
        return sqlStrings.toArray(new String[sqlStrings.size()]);
    }

    protected void applyComments(Table table, List<String> sqlStrings) {
        if (table.getComment() != null) {
            sqlStrings.add(this.dialect.getTableComment(table.getComment()));
        }
    }

    protected void applyTableTypeString(StringBuilder buf) {
        buf.append(this.dialect.getTableTypeString());
    }

    protected void applyTableCheck(Table table, StringBuilder buf) {
        if (this.dialect.supportsTableCheck()) {
            Iterator<String> checkConstraints = table.getCheckConstraintsIterator();
            while (checkConstraints.hasNext()) {
                buf.append(", check (").append(checkConstraints.next()).append(')');
            }
        }
    }

    protected String tableCreateString(boolean hasPrimaryKey) {
        return hasPrimaryKey ? this.dialect.getCreateTableString() : this.dialect.getCreateMultisetTableString();
    }

    @Override
    public String[] getSqlDropStrings(Table table, Metadata metadata) {
        StringBuilder buf = new StringBuilder("drop table ");
        if (this.dialect.supportsIfExistsBeforeTableName()) {
            buf.append("if exists ");
        }
        QualifiedNameParser.NameParts tableName = new QualifiedNameParser.NameParts(Identifier.toIdentifier(table.getCatalog(), table.isCatalogQuoted()), Identifier.toIdentifier(table.getSchema(), table.isSchemaQuoted()), table.getNameIdentifier());
        JdbcEnvironment jdbcEnvironment = metadata.getDatabase().getJdbcEnvironment();
        buf.append(jdbcEnvironment.getQualifiedObjectNameFormatter().format(tableName, jdbcEnvironment.getDialect())).append(this.dialect.getCascadeConstraintsString());
        if (this.dialect.supportsIfExistsAfterTableName()) {
            buf.append(" if exists");
        }
        return new String[]{buf.toString()};
    }
}

