/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.comp;

import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.comp.RestJobMessage;
import fi.csc.chipster.filebroker.LegacyRestFileBrokerClient;
import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.websocket.WebSocketClient;
import fi.csc.chipster.scheduler.JobCommand;
import fi.csc.chipster.servicelocator.ServiceLocatorClient;
import fi.csc.chipster.sessiondb.RestException;
import fi.csc.chipster.sessiondb.SessionDbClient;
import fi.csc.chipster.sessiondb.model.Dataset;
import fi.csc.chipster.sessiondb.model.Input;
import fi.csc.chipster.sessiondb.model.Job;
import fi.csc.chipster.sessiondb.model.MetadataEntry;
import fi.csc.chipster.toolbox.ToolboxClientComp;
import fi.csc.chipster.toolbox.ToolboxTool;
import fi.csc.microarray.comp.CompException;
import fi.csc.microarray.comp.CompJob;
import fi.csc.microarray.comp.ResourceMonitor;
import fi.csc.microarray.comp.ResultCallback;
import fi.csc.microarray.comp.RuntimeRepository;
import fi.csc.microarray.comp.ToolRuntime;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.ApplicationConstants;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.message.GenericJobMessage;
import fi.csc.microarray.messaging.message.GenericResultMessage;
import fi.csc.microarray.messaging.message.JobLogMessage;
import fi.csc.microarray.service.KeepAliveShutdownHandler;
import fi.csc.microarray.service.ShutdownCallback;
import fi.csc.microarray.util.SystemMonitorUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.websocket.MessageHandler;
import javax.ws.rs.core.UriBuilder;
import org.apache.log4j.Logger;

public class RestCompServer
implements ShutdownCallback,
ResultCallback,
MessageHandler.Whole<String>,
ResourceMonitor.ProcessProvider {
    public static final String DESCRIPTION_OUTPUT_NAME = "description";
    public static final String SOURCECODE_OUTPUT_NAME = "sourcecode";
    private static Logger logger;
    private static Logger loggerJobs;
    private static Logger loggerStatus;
    private int scheduleTimeout;
    private int offerDelay;
    private int timeoutCheckInterval;
    private int heartbeatInterval;
    private int compAvailableInterval;
    private boolean sweepWorkDir;
    private int maxJobs;
    private UUID compId = UUID.randomUUID();
    private File workDir;
    private RuntimeRepository runtimeRepository;
    private ToolboxClientComp toolboxClient;
    private FileBrokerClient fileBroker;
    private ExecutorService executorService;
    private Object jobsLock = new Object();
    private LinkedHashMap<String, CompJob> scheduledJobs = new LinkedHashMap();
    private LinkedHashMap<String, CompJob> runningJobs = new LinkedHashMap();
    private Timer timeoutTimer;
    private Timer heartbeatTimer;
    private Timer compAvailableTimer;
    private String localFilebrokerPath;
    private String overridingFilebrokerIp;
    private volatile boolean stopGracefully;
    private ServiceLocatorClient serviceLocator;
    private WebSocketClient schedulerClient;
    private String schedulerUri;
    private Config config;
    private AuthenticationClient authClient;
    private SessionDbClient sessionDbClient;
    private ResourceMonitor resourceMonitor;
    private int monitoringInterval;

    public RestCompServer(String configURL) throws Exception {
        if (!DirectoryLayout.isInitialised()) {
            new File("security").mkdir();
            DirectoryLayout.initialiseServerLayout(Arrays.asList("comp"), (String)configURL);
        }
        Config config = new Config();
        this.scheduleTimeout = config.getInt("comp-schedule-timeout");
        this.offerDelay = config.getInt("comp-offer-delay");
        this.timeoutCheckInterval = config.getInt("comp-timeout-check-interval");
        this.heartbeatInterval = config.getInt("comp-job-heartbeat-interval");
        this.compAvailableInterval = config.getInt("comp-available-interval");
        this.sweepWorkDir = config.getBoolean("comp-sweep-work-dir");
        this.maxJobs = config.getInt("comp-max-jobs");
        this.monitoringInterval = 5;
        logger = Logger.getLogger(RestCompServer.class);
        loggerJobs = Logger.getLogger((String)"jobs");
        loggerStatus = Logger.getLogger((String)"status");
        logger.info((Object)"starting compute service...");
        this.workDir = new File("jobs-data", this.compId.toString());
        if (!this.workDir.mkdirs()) {
            throw new IllegalStateException("creating working directory " + this.workDir.getAbsolutePath() + " failed");
        }
        this.executorService = Executors.newCachedThreadPool();
        this.runtimeRepository = new RuntimeRepository(this.workDir, this.getClass().getClassLoader().getResourceAsStream("runtimes.xml"));
        String toolboxUrl = config.getString("toolbox-url");
        this.toolboxClient = new ToolboxClientComp(toolboxUrl);
        logger.info((Object)("toolbox client connecting to: " + toolboxUrl));
        this.timeoutTimer = new Timer(true);
        this.timeoutTimer.schedule((TimerTask)new TimeoutTimerTask(), this.timeoutCheckInterval, (long)this.timeoutCheckInterval);
        this.heartbeatTimer = new Timer(true);
        this.compAvailableTimer = new Timer(true);
        this.compAvailableTimer.schedule((TimerTask)new CompAvailableTask(), this.compAvailableInterval, (long)this.compAvailableInterval);
        this.resourceMonitor = new ResourceMonitor((ResourceMonitor.ProcessProvider)this, this.monitoringInterval);
        String username = "comp";
        String password = config.getPassword(username);
        this.serviceLocator = new ServiceLocatorClient(config);
        this.authClient = new AuthenticationClient(this.serviceLocator, username, password);
        this.schedulerUri = UriBuilder.fromUri((String)this.serviceLocator.get("scheduler").get(0)).path("events").queryParam("token", new Object[]{this.authClient.getToken()}).toString();
        this.schedulerClient = new WebSocketClient(this.schedulerUri, this, true, "comps-scheduler-client");
        this.sessionDbClient = new SessionDbClient(this.serviceLocator, this.authClient.getCredentials());
        this.fileBroker = new LegacyRestFileBrokerClient(this.sessionDbClient, this.serviceLocator, this.authClient);
        KeepAliveShutdownHandler.init((ShutdownCallback)this);
        this.sendCompAvailable();
        logger.info((Object)("comp is up and running [" + ApplicationConstants.VERSION + "]"));
        logger.info((Object)("[mem: " + SystemMonitorUtil.getMemInfo() + "]"));
    }

    private String nullIfEmpty(String value) {
        if ("".equals(value.trim())) {
            return null;
        }
        return value;
    }

    public String getName() {
        return "comp";
    }

    public void onMessage(String message) {
        try {
            JobCommand schedulerMsg = RestUtils.parseJson(JobCommand.class, message);
            switch (schedulerMsg.getCommand()) {
                case SCHEDULE: {
                    logger.info((Object)("received a schedule message for a job " + schedulerMsg.getJobId()));
                    this.scheduleJob(schedulerMsg);
                    break;
                }
                case CHOOSE: {
                    if (this.compId.equals(schedulerMsg.getCompId())) {
                        this.runJob(schedulerMsg);
                        logger.info((Object)"offer chosen, running the job...");
                        break;
                    }
                    this.removeScheduled(schedulerMsg.getJobId().toString());
                    logger.info((Object)"offer rejected");
                    break;
                }
                case CANCEL: {
                    logger.info((Object)"cancelling the job...");
                    this.cancelJob(schedulerMsg.getJobId().toString());
                    break;
                }
                default: {
                    logger.warn((Object)("unknown command: " + (Object)((Object)schedulerMsg.getCommand())));
                }
            }
            this.updateStatus();
        }
        catch (Exception e) {
            logger.error((Object)"error in comp when handling a scheduler message", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runJob(JobCommand msg) {
        logger.debug((Object)("ACCEPT_OFFER for comp: " + msg.getCompId() + " job: " + msg.getJobId()));
        Object object = this.jobsLock;
        synchronized (object) {
            CompJob job = this.scheduledJobs.get(msg.getJobId().toString());
            if (job != null) {
                this.scheduledJobs.remove(msg.getJobId().toString());
                this.runningJobs.put(job.getId(), job);
                this.executorService.execute((Runnable)job);
                logger.info((Object)("Executing job " + job.getToolDescription().getDisplayName() + "(" + job.getToolDescription().getID() + ")" + ", " + job.getId() + ", " + job.getInputMessage().getUsername()));
            } else {
                logger.warn((Object)"Got ACCEPT_OFFER for job which is not scheduled.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeScheduled(String jobId) {
        logger.debug((Object)("Removing scheduled job " + jobId));
        Object object = this.jobsLock;
        synchronized (object) {
            if (this.scheduledJobs.containsKey(jobId)) {
                this.scheduledJobs.remove(jobId);
                this.activeJobRemoved();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelJob(String jobId) {
        CompJob job;
        Object object = this.jobsLock;
        synchronized (object) {
            job = this.scheduledJobs.containsKey(jobId) ? (CompJob)this.scheduledJobs.remove(jobId) : (CompJob)this.runningJobs.remove(jobId);
        }
        if (job != null) {
            job.cancel();
        }
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public boolean shouldSweepWorkDir() {
        return this.sweepWorkDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRunningJob(CompJob job) {
        String hostname = RestUtils.getHostname();
        char delimiter = ';';
        try {
            loggerJobs.info((Object)(job.getId() + delimiter + job.getInputMessage().getToolId().replaceAll("\"", "") + delimiter + job.getState() + delimiter + job.getInputMessage().getUsername() + delimiter + hostname));
        }
        catch (Exception e) {
            logger.warn((Object)"got exception when logging a job to be removed", (Throwable)e);
        }
        logger.debug((Object)("comp server removing job " + job.getId() + "(" + job.getState() + ")"));
        Object object = this.jobsLock;
        synchronized (object) {
            this.runningJobs.remove(job.getId());
        }
        this.activeJobRemoved();
        this.checkStopGracefully();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStopGracefully() {
        if (this.stopGracefully) {
            Object object = this.jobsLock;
            synchronized (object) {
                if (this.scheduledJobs.size() == 0 && this.runningJobs.size() == 0) {
                    this.shutdown();
                    System.exit(0);
                }
            }
        }
    }

    private JobLogMessage jobToMessage(CompJob job) {
        String hostname = RestUtils.getHostname();
        Date startTime = job.getExecutionStartTime();
        if (startTime == null) {
            startTime = job.getScheduleTime();
        }
        if (startTime == null) {
            startTime = job.getReceiveTime();
        }
        JobLogMessage jobLogMessage = new JobLogMessage(job.getInputMessage().getToolId().replaceAll("\"", ""), job.getState(), job.getStateDetail(), job.getId(), startTime, job.getExecutionEndTime(), job.getResultMessage().getErrorMessage(), job.getResultMessage().getOutputText(), job.getInputMessage().getUsername(), hostname);
        return jobLogMessage;
    }

    public void sendResultMessage(GenericJobMessage jobMessage, GenericResultMessage result) {
        try {
            JobCommand jobCommand = ((RestJobMessage)jobMessage).getJobCommand();
            Job dbJob = this.sessionDbClient.getJob(jobCommand.getSessionId(), jobCommand.getJobId());
            dbJob.setJobId(jobCommand.getJobId());
            dbJob.setScreenOutput(result.getOutputText());
            dbJob.setState(result.getState());
            dbJob.setStateDetail(result.getStateDetail() + result.getErrorMessage());
            dbJob.setSourceCode(result.getSourceCode());
            this.sessionDbClient.updateJob(jobCommand.getSessionId(), dbJob);
        }
        catch (RestException e) {
            logger.error((Object)"could not update the job", (Throwable)e);
        }
        logger.info((Object)("result message sent (" + result.getJobId() + " " + result.getState() + ")"));
    }

    public FileBrokerClient getFileBrokerClient() {
        return this.fileBroker;
    }

    public ToolboxClientComp getToolboxClient() {
        return this.toolboxClient;
    }

    private void activeJobRemoved() {
        this.updateStatus();
        this.sendCompAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob(JobCommand msg) {
        CompJob job;
        if (this.stopGracefully) {
            return;
        }
        Job dbJob = null;
        try {
            dbJob = this.sessionDbClient.getJob(msg.getSessionId(), msg.getJobId());
        }
        catch (RestException e) {
            logger.warn((Object)("unable to get the job " + msg.getJobId()), (Throwable)e);
            return;
        }
        String toolId = dbJob.getToolId();
        if (toolId == null || toolId.isEmpty()) {
            logger.warn((Object)("invalid tool id: " + toolId));
            return;
        }
        ToolboxTool toolboxTool = null;
        try {
            toolboxTool = this.toolboxClient.getTool(toolId);
        }
        catch (Exception e) {
            logger.warn((Object)("failed to get tool " + toolId + " from toolbox"), (Throwable)e);
            return;
        }
        if (toolboxTool == null) {
            logger.warn((Object)("tool " + toolId + " not found"));
            return;
        }
        ToolRuntime runtime = this.runtimeRepository.getRuntime(toolboxTool.getRuntime());
        if (runtime == null) {
            logger.warn((Object)String.format("runtime %s for tool %s not found, ignoring job message", toolboxTool.getRuntime(), dbJob.getToolId()));
            return;
        }
        if (runtime.isDisabled()) {
            logger.warn((Object)String.format("runtime %s for tool %s is disabled, ignoring job message", toolboxTool.getRuntime(), dbJob.getToolId()));
            return;
        }
        RestJobMessage jobMessage = new RestJobMessage(msg, dbJob);
        try {
            HashMap<String, List<MetadataEntry>> metadataMap = new HashMap<String, List<MetadataEntry>>();
            for (Input input : dbJob.getInputs()) {
                Dataset dataset = this.sessionDbClient.getDataset(msg.getSessionId(), UUID.fromString(input.getDatasetId()));
                metadataMap.put(input.getInputId(), dataset.getMetadata());
            }
            jobMessage.setMetadata(metadataMap);
            job = runtime.getJobFactory().createCompJob((GenericJobMessage)jobMessage, toolboxTool, (ResultCallback)this);
        }
        catch (RestException | CompException e) {
            logger.warn((Object)("could not create job for " + dbJob.getToolId()), e);
            GenericResultMessage resultMessage = new GenericResultMessage("", JobState.ERROR, "", "Creating job failed", "");
            this.sendResultMessage(jobMessage, resultMessage);
            return;
        }
        Object object = this.jobsLock;
        synchronized (object) {
            job.setReceiveTime(new Date());
            if (this.runningJobs.size() + this.scheduledJobs.size() >= this.maxJobs) {
                this.sendCompBusy(msg);
                return;
            }
            this.scheduleJob(job, msg);
        }
        this.updateStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob(CompJob job, final JobCommand cmd) {
        Object object = this.jobsLock;
        synchronized (object) {
            job.setScheduleTime(new Date());
            this.scheduledJobs.put(job.getId(), job);
        }
        int delay = this.offerDelay * (this.runningJobs.size() + this.scheduledJobs.size() - 1);
        if (delay > 0) {
            Timer timer = new Timer("offer-delay-timer", true);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    RestCompServer.this.sendOfferMessage(cmd);
                    RestCompServer.this.updateStatus();
                }
            }, delay);
        } else {
            this.sendOfferMessage(cmd);
        }
        this.updateStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendOfferMessage(JobCommand cmd) {
        try {
            logger.info((Object)("send " + (Object)((Object)cmd.getCommand()) + " message"));
            this.schedulerClient.sendText(RestUtils.asJson(new JobCommand(cmd.getSessionId(), cmd.getJobId(), this.compId, JobCommand.Command.OFFER)));
        }
        catch (IOException | InterruptedException e) {
            Object object = this.jobsLock;
            synchronized (object) {
                this.scheduledJobs.remove(cmd.getJobId());
            }
            logger.error((Object)("Could not send OFFER for job " + cmd.getJobId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatus() {
        Object object = this.jobsLock;
        synchronized (object) {
            loggerStatus.info((Object)("scheduled jobs: " + this.scheduledJobs.size() + ", running jobs: " + this.runningJobs.size()));
        }
    }

    private void sendCompAvailable() {
        this.sendJobCommand(new JobCommand(null, null, this.compId, JobCommand.Command.AVAILABLE));
    }

    private void sendCompBusy(JobCommand cmd) {
        this.sendJobCommand(new JobCommand(cmd.getSessionId(), cmd.getJobId(), this.compId, JobCommand.Command.BUSY));
    }

    private void sendJobCommand(JobCommand cmd) {
        try {
            if (cmd.getCommand() != JobCommand.Command.AVAILABLE) {
                logger.info((Object)("send " + (Object)((Object)cmd.getCommand()) + " message"));
            }
            this.schedulerClient.sendText(RestUtils.asJson(cmd));
        }
        catch (IOException | InterruptedException e) {
            logger.error((Object)("unable to send " + (Object)((Object)cmd.getCommand()) + " message"), (Throwable)e);
        }
    }

    public void shutdown() {
        logger.info((Object)"shutdown requested");
        try {
            this.schedulerClient.shutdown();
        }
        catch (IOException e) {
            logger.warn((Object)"failed to shutdown scheduler client", (Throwable)e);
        }
        try {
            this.sessionDbClient.close();
        }
        catch (IOException e) {
            logger.warn((Object)"failed to shutdown session-db client", (Throwable)e);
        }
        logger.info((Object)"shutting down");
    }

    private synchronized ArrayList<CompJob> getAllJobs() {
        ArrayList<CompJob> allJobs = new ArrayList<CompJob>();
        allJobs.addAll(this.scheduledJobs.values());
        allJobs.addAll(this.runningJobs.values());
        return allJobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<Process> getRunningJobProcesses() {
        Object object = this.jobsLock;
        synchronized (object) {
            HashSet<Process> jobProcesses = new HashSet<Process>();
            for (CompJob compJob : this.runningJobs.values()) {
                if (compJob.getProcess() == null) continue;
                jobProcesses.add(compJob.getProcess());
            }
            return jobProcesses;
        }
    }

    public static void main(String[] args) throws Exception {
        new RestCompServer(null);
    }

    public class CompAvailableTask
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = RestCompServer.this.jobsLock;
            synchronized (object) {
                if (RestCompServer.this.runningJobs.size() + RestCompServer.this.scheduledJobs.size() < RestCompServer.this.maxJobs) {
                    RestCompServer.this.sendCompAvailable();
                }
            }
        }
    }

    public class JobHeartbeatTask
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = RestCompServer.this.jobsLock;
            synchronized (object) {
                for (CompJob job : RestCompServer.this.getAllJobs()) {
                    job.updateStateToClient();
                }
            }
        }
    }

    private class TimeoutTimerTask
    extends TimerTask {
        private TimeoutTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = RestCompServer.this.jobsLock;
            synchronized (object) {
                ArrayList<CompJob> jobsToBeRemoved = new ArrayList<CompJob>();
                jobsToBeRemoved.clear();
                for (CompJob job : RestCompServer.this.scheduledJobs.values()) {
                    if (System.currentTimeMillis() - (long)(RestCompServer.this.scheduleTimeout * 1000) <= job.getScheduleTime().getTime()) break;
                    jobsToBeRemoved.add(job);
                }
                for (CompJob job : jobsToBeRemoved) {
                    RestCompServer.this.scheduledJobs.remove(job.getId());
                    logger.debug((Object)("Removing old scheduled job: " + job.getId()));
                    RestCompServer.this.activeJobRemoved();
                }
            }
        }
    }
}

