/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest.token;

import fi.csc.chipster.auth.resource.AuthPrincipal;
import fi.csc.chipster.rest.token.TokenRequestFilter;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TokenServletFilter
implements Filter {
    private static final Logger logger = LogManager.getLogger();
    private TokenRequestFilter tokenRequestFilter;

    public TokenServletFilter(TokenRequestFilter tokenRequestFilter) {
        this.tokenRequestFilter = tokenRequestFilter;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        String tokenParameter = request.getParameter("token");
        String tokenHeader = request.getHeader("authorization");
        if ("OPTIONS".equals(request.getMethod())) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String token = this.tokenRequestFilter.getToken(tokenHeader, tokenParameter);
        AuthPrincipal principal = this.tokenRequestFilter.tokenAuthentication(token);
        chain.doFilter((ServletRequest)new AuthenticatedRequest(request, principal), (ServletResponse)response);
    }

    public void destroy() {
    }

    public static class AuthenticatedRequest
    extends HttpServletRequestWrapper {
        private AuthPrincipal principal;

        public AuthenticatedRequest(HttpServletRequest request, AuthPrincipal principal) {
            super(request);
            this.principal = principal;
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }
    }
}

