/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest.websocket;

import fi.csc.chipster.rest.websocket.RetryHandler;
import fi.csc.chipster.rest.websocket.WebSocketClientEndpoint;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeoutException;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.MessageHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.tyrus.client.ClientManager;

public class WebSocketClient {
    public static final Logger logger = LogManager.getLogger();
    private static final long PING_INTERVAL = 60000L;
    private String name;
    private ClientManager client;
    private WebSocketClientEndpoint endpoint;
    private RetryHandler retryHandler;
    private Timer pingTimer = new Timer();

    public WebSocketClient(String uri, MessageHandler.Whole<String> messageHandler, boolean retry, String name) throws InterruptedException, WebSocketErrorException, WebSocketClosedException {
        this.name = name;
        ClientEndpointConfig cec = ClientEndpointConfig.Builder.create().build();
        this.client = ClientManager.createClient();
        if (retry) {
            this.retryHandler = new RetryHandler(name);
            this.client.getProperties().put("org.glassfish.tyrus.client.ClientManager.ReconnectHandler", this.retryHandler);
        }
        try {
            this.endpoint = new WebSocketClientEndpoint(uri, name, messageHandler, this.retryHandler);
            this.client.connectToServer((Endpoint)this.endpoint, cec, new URI(uri));
        }
        catch (IOException | URISyntaxException | DeploymentException e) {
            throw new WebSocketErrorException(e);
        }
        this.endpoint.waitForConnection();
        this.pingTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    WebSocketClient.this.ping();
                }
                catch (IOException | InterruptedException | TimeoutException e) {
                    logger.error("failed to send a ping", (Throwable)e);
                }
            }
        }, 60000L, 60000L);
    }

    public void sendText(String text) throws InterruptedException, IOException {
        this.endpoint.sendText(text);
    }

    public void shutdown() throws IOException {
        logger.debug("shutdown websocket client " + this.name);
        if (this.retryHandler != null) {
            this.retryHandler.close();
        }
        this.pingTimer.cancel();
        this.endpoint.close();
        this.client.shutdown();
    }

    public void ping() throws IOException, TimeoutException, InterruptedException {
        this.endpoint.ping();
    }

    public static class WebSocketErrorException
    extends Exception {
        public WebSocketErrorException(Throwable throwable) {
            super(throwable);
        }
    }

    public static class WebSocketClosedException
    extends Exception {
        public WebSocketClosedException(CloseReason closeReason) {
            super(closeReason.getCloseCode() + closeReason.getReasonPhrase());
        }
    }
}

