/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessiondb;

import java.net.URI;
import javax.ws.rs.core.Response;

public class RestException
extends Exception {
    private String latestMessage;
    private Response response;
    private URI uri;
    private String body;

    public RestException(String msg, Response response, URI uri) {
        super(msg);
        this.latestMessage = msg;
        this.response = response;
        this.uri = uri;
        this.body = (String)response.readEntity(String.class);
    }

    public RestException(String msg, Exception e) {
        super(msg, e);
        this.latestMessage = msg;
    }

    public RestException(String msg) {
        super(msg);
    }

    public Response getResponse() {
        return this.response;
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public String getMessage() {
        return this.latestMessage + " (" + this.response.getStatus() + ") " + this.body + ", " + this.uri;
    }

    public boolean isNotFound() {
        return this.response.getStatus() == 404;
    }
}

