/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessiondb;

import com.fasterxml.jackson.core.JsonParseException;
import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.rest.hibernate.HibernateUtil;
import fi.csc.chipster.servicelocator.ServiceLocatorClient;
import fi.csc.chipster.sessiondb.RestException;
import fi.csc.chipster.sessiondb.SessionDb;
import fi.csc.chipster.sessiondb.SessionDbClient;
import fi.csc.chipster.sessiondb.model.Authorization;
import fi.csc.chipster.sessiondb.model.Dataset;
import fi.csc.chipster.sessiondb.model.Job;
import fi.csc.chipster.sessiondb.model.Session;
import fi.csc.chipster.sessiondb.model.SessionEvent;
import fi.csc.chipster.sessiondb.model.TableStats;
import fi.csc.chipster.sessiondb.resource.AuthorizationResource;
import fi.csc.chipster.sessiondb.resource.SessionDbAdminResource;
import fi.csc.chipster.sessiondb.resource.SessionResource;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;

public class SessionDbCluster
implements SessionDbClient.SessionEventListener {
    public static final Logger logger = LogManager.getLogger();
    private volatile boolean queueEvents = true;
    private LinkedList<SessionEvent> eventQueue = new LinkedList();
    private SessionDbClient sourceSessionDbClient;
    private SessionResource targetSessionResource;
    private SessionDbAdminResource adminResource;
    private HibernateUtil hibernate;

    public void replicate(ServiceLocatorClient serviceLocator, AuthenticationClient authService, AuthorizationResource authorizationResource, SessionResource sessionResource, SessionDbAdminResource adminResource, HibernateUtil hibernate, SessionDb sessionDb) throws RestException {
        this.sourceSessionDbClient = new SessionDbClient(serviceLocator, authService.getCredentials());
        this.targetSessionResource = sessionResource;
        this.adminResource = adminResource;
        this.hibernate = hibernate;
        this.sourceSessionDbClient.subscribe("authorizations", this, "replication-authorization-listener");
        this.sourceSessionDbClient.subscribe("sessions", this, "replication-session-listener");
        this.sourceSessionDbClient.subscribe("datasets", this, "replication-dataset-listener");
        this.sourceSessionDbClient.subscribe("jobs", this, "replication-job-listener");
        logger.info("bulk replication started");
        this.print("  master rows ", this.sourceSessionDbClient.getTableStats());
        try {
            this.replicateSessions(authorizationResource, sessionResource, hibernate, this.sourceSessionDbClient);
            this.replicateDatasetsAndJobs(authorizationResource, sessionResource, hibernate, this.sourceSessionDbClient);
        }
        catch (IOException e) {
            throw new RestException("bulk replication failed", e);
        }
        logger.info("replicating latest changes");
        this.handleQueue();
        this.queueEvents = false;
        this.handleQueue();
        this.print("  master rows ", this.sourceSessionDbClient.getTableStats());
        this.printTargetTableStats();
        logger.info("bulk replication completed, following changes on the master");
    }

    private void printTargetTableStats() {
        this.hibernate.runInTransaction(new HibernateUtil.HibernateRunnable<Void>(){

            @Override
            public Void run(org.hibernate.Session hibernateSession) {
                SessionDbCluster.this.print("  slave rows  ", SessionDbCluster.this.adminResource.getTableStats(hibernateSession));
                return null;
            }
        });
    }

    private void print(String msg, List<TableStats> list) {
        ArrayList<TableStats> sortedList = new ArrayList<TableStats>(list);
        sortedList.sort(new Comparator<TableStats>(){

            @Override
            public int compare(TableStats o1, TableStats o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (TableStats table : sortedList) {
            msg = msg + table.getName() + ": " + table.getSize() + " ";
        }
        logger.info(msg);
    }

    private void replicateSessions(final AuthorizationResource authorizationResource, SessionResource sessionResource, HibernateUtil hibernate, SessionDbClient source) throws RestException, JsonParseException, IOException {
        int sessionCount = 0;
        Iterator<Authorization> authorizations = source.getAuthorizations();
        while (authorizations.hasNext()) {
            final Authorization authorization = authorizations.next();
            hibernate.runInTransaction(new HibernateUtil.HibernateRunnable<Void>(){

                @Override
                public Void run(org.hibernate.Session hibernateSession) {
                    authorizationResource.save(authorization, hibernateSession);
                    return null;
                }
            });
            if (++sessionCount % 1000 != 0) continue;
            this.printTargetTableStats();
        }
    }

    private void replicateDatasetsAndJobs(AuthorizationResource authorizationResource, SessionResource sessionResource, HibernateUtil hibernate, final SessionDbClient source) throws RestException, JsonParseException, IOException {
        hibernate.runInTransaction(new HibernateUtil.HibernateRunnable<Void>(){

            @Override
            public Void run(org.hibernate.Session hibernateSession) {
                try {
                    int sessionCount = 0;
                    Query query = hibernateSession.createQuery("from Authorization");
                    query.setReadOnly(true);
                    ScrollableResults results = query.scroll(ScrollMode.FORWARD_ONLY);
                    while (results.next()) {
                        Authorization authorization = (Authorization)results.get()[0];
                        SessionDbCluster.this.replicateSession(source, authorization);
                        if (++sessionCount % 100 != 0) continue;
                        SessionDbCluster.this.printTargetTableStats();
                    }
                }
                catch (RestException e) {
                    logger.error("replication failed", (Throwable)e);
                }
                return null;
            }
        });
    }

    private void replicateSession(SessionDbClient source, Authorization authorization) throws RestException {
        UUID sessionId = authorization.getSession().getSessionId();
        final HashMap<UUID, Dataset> datasets = source.getDatasets(sessionId);
        final HashMap<UUID, Job> jobs = source.getJobs(sessionId);
        this.hibernate.runInTransaction(new HibernateUtil.HibernateRunnable<Void>(){

            @Override
            public Void run(org.hibernate.Session hibernateSession) {
                for (Dataset dataset : datasets.values()) {
                    if (dataset.getFile() != null) {
                        hibernateSession.save((Object)dataset.getFile());
                    }
                    hibernateSession.save((Object)dataset);
                }
                for (Job job : jobs.values()) {
                    hibernateSession.save((Object)job);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueue() throws RestException {
        LinkedList<SessionEvent> linkedList = this.eventQueue;
        synchronized (linkedList) {
            while (!this.eventQueue.isEmpty()) {
                this.hibernate.runInTransaction(new HibernateUtil.HibernateRunnable<Void>(){

                    @Override
                    public Void run(org.hibernate.Session hibernateSession) {
                        try {
                            SessionDbCluster.this.handleEvent((SessionEvent)SessionDbCluster.this.eventQueue.removeFirst(), hibernateSession);
                        }
                        catch (RestException e) {
                            logger.error("failed to handle queue event", (Throwable)e);
                        }
                        return null;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(final SessionEvent e) {
        if (this.queueEvents) {
            LinkedList<SessionEvent> linkedList = this.eventQueue;
            synchronized (linkedList) {
                this.eventQueue.add(e);
            }
        } else {
            if (e.getType() != SessionEvent.EventType.CREATE || e.getResourceType() != SessionEvent.ResourceType.SESSION && e.getResourceType() != SessionEvent.ResourceType.AUTHORIZATION) {
                this.waitForSession(e.getSessionId());
            }
            this.hibernate.runInTransaction(new HibernateUtil.HibernateRunnable<Void>(){

                @Override
                public Void run(org.hibernate.Session hibernateSession) {
                    try {
                        logger.info("replication update: " + e.getType().toString().toLowerCase() + " " + e.getResourceType().toString().toLowerCase() + " " + e.getResourceId());
                        SessionDbCluster.this.handleEvent(e, hibernateSession);
                    }
                    catch (RestException ex) {
                        logger.error("replication error", (Throwable)ex);
                    }
                    return null;
                }
            });
        }
    }

    private void handleEvent(SessionEvent e, org.hibernate.Session hibernateSession) throws RestException {
        block0 : switch (e.getResourceType()) {
            case DATASET: {
                switch (e.getType()) {
                    case CREATE: {
                        this.createDataset(e.getSessionId(), e.getResourceId(), hibernateSession);
                        break block0;
                    }
                    case UPDATE: {
                        this.updateDataset(e.getSessionId(), e.getResourceId(), hibernateSession);
                        break block0;
                    }
                    case DELETE: {
                        this.deleteDataset(e.getSessionId(), e.getResourceId(), hibernateSession);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("unknown even type " + (Object)((Object)e.getType()));
            }
            case JOB: {
                switch (e.getType()) {
                    case CREATE: {
                        this.createJob(e.getSessionId(), e.getResourceId(), hibernateSession);
                        break block0;
                    }
                    case UPDATE: {
                        this.updateJob(e.getSessionId(), e.getResourceId(), hibernateSession);
                        break block0;
                    }
                    case DELETE: {
                        this.deleteJob(e.getSessionId(), e.getResourceId(), hibernateSession);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("unknown even type " + (Object)((Object)e.getType()));
            }
            case AUTHORIZATION: {
                switch (e.getType()) {
                    case CREATE: {
                        this.createSession(e.getResourceId(), hibernateSession);
                        break block0;
                    }
                    case UPDATE: {
                        break block0;
                    }
                    case DELETE: {
                        this.deleteSession(e.getResourceId(), hibernateSession);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("unknown even type " + (Object)((Object)e.getType()));
            }
            case SESSION: {
                switch (e.getType()) {
                    case CREATE: {
                        break block0;
                    }
                    case UPDATE: {
                        this.updateSession(e.getSessionId(), hibernateSession);
                        break block0;
                    }
                    case DELETE: {
                        break block0;
                    }
                }
                throw new IllegalArgumentException("unknown even type " + (Object)((Object)e.getType()));
            }
            case FILE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown event resource " + (Object)((Object)e.getResourceType()));
            }
        }
    }

    private void waitForSession(UUID sessionId) {
        try {
            for (int i = 0; i < 10 && this.getSession(sessionId) == null; ++i) {
                logger.info("waiting for session to become available " + sessionId);
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e1) {
            logger.warn("wait for session interrupted", (Throwable)e1);
        }
    }

    private Session getSession(final UUID sessionId) {
        Session session = this.hibernate.runInTransaction(new HibernateUtil.HibernateRunnable<Session>(){

            @Override
            public Session run(org.hibernate.Session hibernateSession) {
                Session session = (Session)hibernateSession.get(Session.class, (Serializable)sessionId);
                return session;
            }
        });
        return session;
    }

    private void createSession(UUID authorizationId, org.hibernate.Session hibernateSession) throws RestException {
        Authorization auth = this.sourceSessionDbClient.getAuthorization(authorizationId);
        this.targetSessionResource.create(auth, hibernateSession);
    }

    private void updateSession(UUID sessionId, org.hibernate.Session hibernateSession) throws RestException {
        Session session = this.sourceSessionDbClient.getSession(sessionId);
        this.targetSessionResource.update(session, hibernateSession);
    }

    private void deleteSession(UUID authorizationId, org.hibernate.Session hibernateSession) {
        Authorization auth = this.targetSessionResource.getAuthorizationResource().getAuthorization(authorizationId, hibernateSession);
        this.targetSessionResource.deleteSession(auth, hibernateSession);
    }

    private void createJob(UUID sessionId, UUID jobId, org.hibernate.Session hibernateSession) throws RestException {
        Job job = this.sourceSessionDbClient.getJob(sessionId, jobId);
        this.targetSessionResource.getJobResource(sessionId).create(job, hibernateSession);
    }

    private void updateJob(UUID sessionId, UUID jobId, org.hibernate.Session hibernateSession) throws RestException {
        Job job = this.sourceSessionDbClient.getJob(sessionId, jobId);
        this.targetSessionResource.getJobResource(sessionId).update(job, hibernateSession);
    }

    private void deleteJob(UUID sessionId, UUID jobId, org.hibernate.Session hibernateSession) {
        Job job = this.targetSessionResource.getJobResource(sessionId).getJob(jobId, hibernateSession);
        if (job != null) {
            this.targetSessionResource.getJobResource(sessionId).deleteJob(job, hibernateSession);
        } else {
            logger.warn("replicating job delete, but job not found");
        }
    }

    private void createDataset(UUID sessionId, UUID datasetId, org.hibernate.Session hibernateSession) throws RestException {
        Dataset dataset = this.sourceSessionDbClient.getDataset(sessionId, datasetId);
        this.targetSessionResource.getDatasetResource(sessionId).create(dataset, hibernateSession);
    }

    private void updateDataset(UUID sessionId, UUID datasetId, org.hibernate.Session hibernateSession) throws RestException {
        Dataset dataset = this.sourceSessionDbClient.getDataset(sessionId, datasetId);
        this.targetSessionResource.getDatasetResource(sessionId).update(dataset, hibernateSession);
    }

    private void deleteDataset(UUID sessionId, UUID datasetId, org.hibernate.Session hibernateSession) {
        Dataset dataset = this.targetSessionResource.getDatasetResource(sessionId).getDataset(datasetId, hibernateSession);
        if (dataset != null) {
            this.targetSessionResource.getDatasetResource(sessionId).deleteDataset(dataset, hibernateSession);
        } else {
            logger.warn("replicating dataset delete, but dataset not found");
        }
    }
}

