/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessiondb.resource;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.exception.NotAuthorizedException;
import fi.csc.chipster.rest.hibernate.HibernateUtil;
import fi.csc.chipster.rest.hibernate.Transaction;
import fi.csc.chipster.sessiondb.model.Authorization;
import fi.csc.chipster.sessiondb.model.Session;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;

@Path(value="authorizations")
public class AuthorizationResource {
    private static Logger logger = LogManager.getLogger();
    private HibernateUtil hibernate;

    public AuthorizationResource(HibernateUtil hibernate) {
        this.hibernate = hibernate;
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"session-db"})
    @Transaction
    public Response get(@PathParam(value="id") UUID authorizationId, @Context SecurityContext sc) throws IOException {
        Authorization result = this.getAuthorization(authorizationId, this.hibernate.session());
        if (result == null) {
            throw new NotFoundException();
        }
        return Response.ok((Object)result).build();
    }

    public Authorization getAuthorization(UUID authorizationId, org.hibernate.Session hibernateSession) {
        return (Authorization)hibernateSession.get(Authorization.class, (Serializable)authorizationId);
    }

    @GET
    @Produces(value={"application/json"})
    @Transaction
    public Response get(@QueryParam(value="session-id") UUID sessionId, @QueryParam(value="username") String username, @QueryParam(value="read-write") Boolean requireReadWrite, @Context SecurityContext sc) throws IOException {
        if (sessionId == null && username == null && requireReadWrite == null && sc.isUserInRole("session-db")) {
            return this.getAuthorizations();
        }
        if (!sc.isUserInRole("file-broker")) {
            throw new ForbiddenException();
        }
        if (sessionId == null || username == null || requireReadWrite == null) {
            throw new BadRequestException("session-id, username or read-write query parameter is null");
        }
        Session session = this.getSession(sessionId);
        if (session == null) {
            throw new NotFoundException("session not found");
        }
        Authorization authorization = this.getAuthorization(username, session, this.hibernate.session());
        if (authorization == null) {
            throw new NotFoundException("session not authorized for user " + username);
        }
        if (requireReadWrite.booleanValue() && !authorization.isReadWrite()) {
            throw new NotFoundException("no read-write authorization for user " + username);
        }
        return Response.ok().build();
    }

    public Authorization checkAuthorization(String username, UUID sessionId, boolean requireReadWrite) {
        return this.checkAuthorization(username, sessionId, requireReadWrite, this.hibernate.session());
    }

    public Authorization checkAuthorization(String username, UUID sessionId, boolean requireReadWrite, org.hibernate.Session hibernateSession) {
        if (username == null) {
            throw new NotAuthorizedException("username is null");
        }
        Session session = (Session)hibernateSession.get(Session.class, (Serializable)sessionId);
        if (session == null) {
            throw new NotFoundException("session not found");
        }
        Authorization auth = this.getAuthorization(username, session, hibernateSession);
        if (auth == null) {
            throw new ForbiddenException("access denied");
        }
        if (requireReadWrite && !auth.isReadWrite()) {
            throw new ForbiddenException("read-write access denied");
        }
        return auth;
    }

    public List<Authorization> getAuthorizations(String username) {
        return this.hibernate.session().createQuery("from Authorization where username=:username").setParameter("username", (Object)username).list();
    }

    public Response getAuthorizations() {
        StreamingOutput stream = new StreamingOutput(){

            public void write(final OutputStream output) {
                AuthorizationResource.this.hibernate.runInTransaction(new HibernateUtil.HibernateRunnable<Void>(){

                    @Override
                    public Void run(org.hibernate.Session hibernateSession) {
                        try {
                            Query query = hibernateSession.createQuery("from Authorization");
                            query.setReadOnly(true);
                            ScrollableResults results = query.scroll(ScrollMode.FORWARD_ONLY);
                            JsonGenerator jg = RestUtils.getObjectMapper().getFactory().createGenerator(output, JsonEncoding.UTF8);
                            jg.writeStartArray();
                            while (results.next()) {
                                Authorization row = (Authorization)results.get()[0];
                                jg.writeObject((Object)row);
                                jg.flush();
                            }
                            results.close();
                            jg.writeEndArray();
                            jg.flush();
                            jg.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            logger.error((Object)e);
                            throw new RuntimeException(e);
                        }
                        return null;
                    }
                });
            }
        };
        return Response.ok().entity((Object)stream).type("application/json").build();
    }

    public Session getSession(UUID sessionId) {
        return (Session)this.hibernate.session().get(Session.class, (Serializable)sessionId);
    }

    public Authorization getAuthorization(String username, Session session, org.hibernate.Session hibernateSession) {
        if (Config.services.contains(username)) {
            return new Authorization(username, session, true);
        }
        return (Authorization)hibernateSession.createQuery("from Authorization where username=:username and session=:session").setParameter("username", (Object)username).setParameter("session", (Object)session).uniqueResult();
    }

    public void save(Authorization auth, org.hibernate.Session hibernateSession) {
        hibernateSession.save((Object)auth);
    }
}

