/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.toolbox.resource;

import fi.csc.chipster.toolbox.Toolbox;
import fi.csc.chipster.toolbox.ToolboxTool;
import fi.csc.microarray.description.SADLDescription;
import java.io.IOException;
import java.util.LinkedList;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Singleton
@Path(value="tools")
public class ToolResource {
    private Toolbox toolbox;

    public ToolResource(Toolbox toolbox) throws IOException {
        this.toolbox = toolbox;
    }

    @GET
    @Produces(value={"application/json"})
    public final Response getAll() {
        LinkedList<SADLDescription> list = new LinkedList<SADLDescription>();
        for (ToolboxTool tool : this.toolbox.getAll()) {
            list.add(tool.getSadlDescription());
        }
        return Response.ok(list).build();
    }

    @GET
    @Path(value="{toolId}")
    @Produces(value={"application/json"})
    public final Response getTool(@PathParam(value="toolId") String toolId) {
        ToolboxTool tool = this.toolbox.getTool(toolId);
        if (tool != null) {
            return Response.ok((Object)tool).build();
        }
        return Response.status((int)404).build();
    }

    @GET
    @Path(value="{toolId}/{part}")
    @Produces(value={"text/plain"})
    public final String getToolPart(@PathParam(value="toolId") String toolId, @PathParam(value="part") String part) {
        ToolboxTool tool = this.toolbox.getTool(toolId);
        if (tool == null) {
            throw new NotFoundException();
        }
        if (part.equals("source")) {
            return tool.getSource();
        }
        if (part.equals("sadl")) {
            return tool.getSadlString();
        }
        if (part.equals("code")) {
            return tool.getCode();
        }
        throw new NotFoundException();
    }

    public void setToolbox(Toolbox newToolbox) {
        this.toolbox = newToolbox;
    }
}

