/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.toolbox;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;

public class ToolboxRestUtils {
    public static String asJson(Object obj) throws JsonGenerationException, JsonMappingException, IOException {
        StringWriter writer = new StringWriter();
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue((Writer)writer, obj);
        return writer.toString();
    }

    public static <T> T parseJson(Class<T> obj, String json) throws JsonParseException, JsonMappingException, IOException {
        return ToolboxRestUtils.parseJson(obj, json, true);
    }

    public static <T> T parseJson(Class<T> obj, String json, boolean failOnUnknownProperties) throws JsonParseException, JsonMappingException, IOException {
        StringReader reader = new StringReader(json);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, failOnUnknownProperties);
        return (T)mapper.readValue((Reader)reader, obj);
    }

    public static List parseJson(Class<? extends Collection> collectionType, Class<?> itemType, String json) throws JsonParseException, JsonMappingException, IOException {
        return ToolboxRestUtils.parseJson(collectionType, itemType, json, true);
    }

    public static List parseJson(Class<? extends Collection> collectionType, Class<?> itemType, String json, boolean failOnUnknownProperties) throws JsonParseException, JsonMappingException, IOException {
        StringReader reader = new StringReader(json);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, failOnUnknownProperties);
        return (List)mapper.readValue((Reader)reader, (JavaType)mapper.getTypeFactory().constructCollectionType(collectionType, itemType));
    }
}

