/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.auth;

import fi.csc.microarray.auth.AuthenticationProvider;
import fi.csc.microarray.auth.AuthorisationException;
import fi.csc.microarray.auth.JaasAuthenticationProvider;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.ApplicationConstants;
import fi.csc.microarray.messaging.JMSMessagingEndpoint;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.NodeBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.message.AuthenticationMessage;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.security.SecureSessionPool;
import fi.csc.microarray.service.KeepAliveShutdownHandler;
import fi.csc.microarray.service.ShutdownCallback;
import fi.csc.microarray.util.SystemMonitorUtil;
import java.util.Arrays;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class Authenticator
extends NodeBase
implements ShutdownCallback {
    private static Logger logger = null;
    private static Logger securityLogger = null;
    private static Logger messageLogger = null;
    private SecureSessionPool pendingSessions;
    private SecureSessionPool validSessions;
    private MessagingEndpoint endpoint;
    private MessagingTopic authorisedTopic;
    private MessagingTopic authorisedFilebrokerTopic;
    private MessagingTopic authorisedFeedbackTopic;
    private MessagingTopic testTopic;
    private TestListener testListener;
    private AuthenticationProvider authenticationProvider;

    public Authenticator(String configURL) throws Exception {
        DirectoryLayout.initialiseServerLayout(Arrays.asList("auth"), configURL);
        logger = Logger.getLogger(Authenticator.class);
        securityLogger = Logger.getLogger((String)"security.frontend");
        messageLogger = Logger.getLogger((String)"messages.frontend");
        this.pendingSessions = new SecureSessionPool();
        this.validSessions = new SecureSessionPool();
        this.endpoint = new JMSMessagingEndpoint(this);
        this.authorisedTopic = this.endpoint.createTopic(Topics.Name.AUTHORISED_REQUEST_TOPIC, MessagingTopic.AccessMode.WRITE);
        this.authorisedFilebrokerTopic = this.endpoint.createTopic(Topics.Name.AUTHORISED_FILEBROKER_TOPIC, MessagingTopic.AccessMode.WRITE);
        this.authorisedFeedbackTopic = this.endpoint.createTopic(Topics.Name.AUTHORISED_FEEDBACK_TOPIC, MessagingTopic.AccessMode.WRITE);
        RequestListener jobListener = new RequestListener(this.authorisedTopic);
        MessagingTopic requestTopic = this.endpoint.createTopic(Topics.Name.REQUEST_TOPIC, MessagingTopic.AccessMode.READ);
        requestTopic.setListener(jobListener);
        RequestListener filebrokerListener = new RequestListener(this.authorisedFilebrokerTopic);
        MessagingTopic filebrokerTopic = this.endpoint.createTopic(Topics.Name.FILEBROKER_TOPIC, MessagingTopic.AccessMode.READ);
        filebrokerTopic.setListener(filebrokerListener);
        RequestListener feedbackListener = new RequestListener(this.authorisedFeedbackTopic);
        MessagingTopic feedbackTopic = this.endpoint.createTopic(Topics.Name.FEEDBACK_TOPIC, MessagingTopic.AccessMode.READ);
        feedbackTopic.setListener(feedbackListener);
        this.testTopic = this.endpoint.createTopic(Topics.Name.TEST_TOPIC, MessagingTopic.AccessMode.READ_WRITE);
        this.testListener = new TestListener();
        this.testTopic.setListener(this.testListener);
        this.authenticationProvider = new JaasAuthenticationProvider();
        KeepAliveShutdownHandler.init(this);
        logger.info((Object)("authenticator is up and running [" + ApplicationConstants.VERSION + "]"));
        logger.info((Object)("[mem: " + SystemMonitorUtil.getMemInfo() + "]"));
    }

    @Override
    public String getName() {
        return "authenticator";
    }

    @Override
    public void shutdown() {
        logger.info((Object)"shutdown requested");
        try {
            this.endpoint.close();
        }
        catch (JMSException e) {
            logger.error((Object)"closing messaging endpoint failed", (Throwable)e);
        }
        logger.info((Object)"shutting down");
    }

    private class TestListener
    implements MessagingListener {
        private TestListener() {
        }

        @Override
        public void onChipsterMessage(ChipsterMessage msg) {
            logger.debug((Object)"got message on test-topic.");
            try {
                Destination dest = msg.getReplyTo();
                if (dest != null) {
                    CommandMessage replyMessage = new CommandMessage("OK");
                    Authenticator.this.endpoint.replyToMessage(msg, replyMessage);
                } else {
                    logger.debug((Object)"ReplyTo is null, so no reply was sent.");
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private class RequestListener
    implements MessagingListener {
        private static final String KEY_PENDING_MESSAGE = "pending-message";
        private static final String KEY_USERNAME = "username";
        private MessagingTopic routeTo;

        public RequestListener(MessagingTopic routeTo) {
            this.routeTo = routeTo;
        }

        @Override
        public void onChipsterMessage(ChipsterMessage msg) {
            try {
                logger.debug((Object)("starting to process " + msg));
                if (msg instanceof AuthenticationMessage && ((AuthenticationMessage)msg).isLogin()) {
                    this.login((AuthenticationMessage)msg);
                    return;
                }
                SecureSessionPool.Session session = null;
                if (msg.getSessionID() != null) {
                    String id = msg.getSessionID();
                    if (Authenticator.this.validSessions.getSession(id) != null) {
                        session = Authenticator.this.validSessions.getSession(id);
                        logger.debug((Object)("message " + msg.getMessageID() + " had a proper session " + session.getID()));
                    }
                }
                if (session == null) {
                    logger.debug((Object)("message " + msg + " has no session, requires authentication"));
                    session = Authenticator.this.pendingSessions.createSession();
                    logger.debug((Object)("created new session, pending sessions pool size is now " + Authenticator.this.pendingSessions.size()));
                    session.putParameter(KEY_PENDING_MESSAGE, msg);
                    this.requestAuthentication(msg, session.getID().toString());
                    return;
                }
                if (msg instanceof AuthenticationMessage) {
                    AuthenticationMessage authMsg = (AuthenticationMessage)msg;
                    if (authMsg.isLogout()) {
                        logger.debug((Object)("message " + msg.getMessageID() + " is a logout"));
                        Authenticator.this.validSessions.removeSession(session);
                        return;
                    }
                    throw new IllegalArgumentException("unknown authentication message: " + authMsg);
                }
                this.routeMessage(msg, session);
                session.touch();
            }
            catch (JMSException e) {
                logger.error((Object)e);
            }
            catch (AuthorisationException e) {
                securityLogger.info((Object)("authorisation failed: " + e.getMessage()));
                logger.info((Object)e);
            }
        }

        private void login(AuthenticationMessage authMsg) throws JMSException, AuthorisationException {
            messageLogger.debug((Object)("message " + authMsg.getMessageID() + " is a login"));
            String sessionId = authMsg.getSessionID();
            if (sessionId == null || sessionId.isEmpty()) {
                logger.warn((Object)("got login message with invalid session id: " + sessionId));
                return;
            }
            SecureSessionPool.Session session = Authenticator.this.pendingSessions.getSession(sessionId);
            if (session == null) {
                logger.warn((Object)("pending session " + sessionId + " not found"));
                return;
            }
            boolean validUsername = authMsg.getUsername().trim().equals(authMsg.getUsername());
            if (validUsername && Authenticator.this.authenticationProvider.authenticate(authMsg.getUsername(), authMsg.getPassword().toCharArray())) {
                Authenticator.this.pendingSessions.removeSession(session);
                session.putParameter(KEY_USERNAME, authMsg.getUsername());
                Authenticator.this.validSessions.addSession(session);
                securityLogger.info((Object)("authenticated user " + authMsg.getUsername() + " (auth. message JMS id was " + authMsg.getJmsMessageID() + ")"));
                try {
                    this.ackLogin(authMsg, session.getID().toString(), true);
                }
                catch (Exception e) {
                    logger.warn((Object)("could not send acknowledge message for " + authMsg.getUsername()));
                }
                ChipsterMessage pendingMessage = (ChipsterMessage)session.getParameter(KEY_PENDING_MESSAGE);
                if (pendingMessage != null) {
                    if (pendingMessage instanceof CommandMessage && "login".equals(((CommandMessage)pendingMessage).getCommand())) {
                        this.sendReplyToFirstLogin((CommandMessage)pendingMessage);
                    } else {
                        this.routeMessage(pendingMessage, session);
                    }
                }
            } else {
                securityLogger.info((Object)("illegal username/password (user " + authMsg.getUsername() + ", auth. message JMS id was " + authMsg.getJmsMessageID() + ")"));
                if (!validUsername) {
                    securityLogger.info((Object)("white space isn't allowed in username (user " + authMsg.getUsername() + ")"));
                }
                this.ackLogin(authMsg, session.getID().toString(), false);
                return;
            }
            session.touch();
        }

        private void sendReplyToFirstLogin(CommandMessage loginMessage) {
            AuthenticationMessage reply = new AuthenticationMessage(AuthenticationMessage.AuthenticationOperation.LOGIN_SUCCEEDED);
            logger.debug((Object)"sending reply to first login message");
            try {
                Authenticator.this.endpoint.replyToMessage(loginMessage, reply, Topics.MultiplexName.REPLY_TO.toString());
            }
            catch (JMSException e) {
                logger.warn((Object)"failed to send reply to first login");
            }
        }

        private void routeMessage(ChipsterMessage message, SecureSessionPool.Session session) throws JMSException {
            String username = (String)session.getParameter(KEY_USERNAME);
            if (username == null || username.equals("")) {
                logger.warn((Object)"not routing a message with null or empty username");
                SecureSessionPool.Session sessionToBeRemoved = Authenticator.this.validSessions.getSession(session.getID());
                if (sessionToBeRemoved != null) {
                    Authenticator.this.validSessions.removeSession(sessionToBeRemoved);
                }
                return;
            }
            message.setUsername(username);
            message.setSessionID(null);
            messageLogger.info((Object)message);
            this.routeTo.sendMessage(message);
        }

        private void ackLogin(ChipsterMessage loginMessage, String sessionID, boolean succeeded) throws JMSException, AuthorisationException {
            AuthenticationMessage.AuthenticationOperation operation = succeeded ? AuthenticationMessage.AuthenticationOperation.LOGIN_SUCCEEDED : AuthenticationMessage.AuthenticationOperation.LOGIN_FAILED;
            AuthenticationMessage ackMessage = new AuthenticationMessage(operation);
            ackMessage.setSessionID(sessionID);
            ackMessage.setReplyTo(loginMessage.getReplyTo());
            if (succeeded) {
                ackMessage.setUsername(loginMessage.getUsername());
            }
            Authenticator.this.endpoint.replyToMessage(loginMessage, ackMessage, Topics.MultiplexName.AUTHORISE_TO.toString());
        }

        private void requestAuthentication(ChipsterMessage msg, String sessionID) throws JMSException, AuthorisationException {
            AuthenticationMessage request = new AuthenticationMessage(AuthenticationMessage.AuthenticationOperation.REQUEST);
            request.setSessionID(sessionID);
            request.setReplyTo(msg.getReplyTo());
            logger.debug((Object)("requesting authentication for " + msg.getMessageID() + " under the session " + sessionID));
            Authenticator.this.endpoint.replyToMessage(msg, request, Topics.MultiplexName.AUTHORISE_TO.toString());
        }
    }
}

