/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataview;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.selection.DatasetChoiceEvent;
import fi.csc.microarray.client.visualisation.VisualisationFrameManager;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataChangeEvent;
import fi.csc.microarray.databeans.DataChangeListener;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.DataItemCreatedEvent;
import fi.csc.microarray.databeans.DataItemRemovedEvent;
import fi.csc.microarray.util.SwingTools;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class TreePanel
extends JPanel
implements DataChangeListener,
TreeSelectionListener,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(TreePanel.class);
    private JTree tree = null;
    private DefaultTreeModel treeModel = null;
    private DefaultMutableTreeNode rootNode = null;
    private DataFolder rootFolder = null;
    private Map<DataItem, DefaultMutableTreeNode> nodeMap = new HashMap<DataItem, DefaultMutableTreeNode>();
    private SwingClientApplication application = (SwingClientApplication)Session.getSession().getApplication();
    private boolean disableSelectionReporting = false;
    private CardLayout cardLayout;
    private JPanel cardParent;

    public TreePanel(DataFolder rootFolder, JPanel parent, CardLayout cardLayout) {
        super(new GridBagLayout());
        this.cardLayout = cardLayout;
        this.cardParent = parent;
        this.rootFolder = rootFolder;
        this.tree = this.getTree();
        this.tree.setName("datasetTree");
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(new Dimension(400, 270));
        JPanel dataTreePanel = new JPanel(new GridBagLayout());
        dataTreePanel.setBackground(this.tree.getBackground());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.fill = 2;
        c.gridy = 1;
        c.anchor = 18;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        dataTreePanel.add((Component)this.tree, c);
        JScrollPane scroller = new JScrollPane(dataTreePanel);
        scroller.getVerticalScrollBar().setUnitIncrement(scroller.getVerticalScrollBar().getUnitIncrement() * 4);
        scroller.setBorder(BorderFactory.createEmptyBorder());
        scroller.setMinimumSize(new Dimension(0, 0));
        this.add((Component)scroller, c);
        this.application.getDataManager().addDataChangeListener(this);
        this.application.addClientEventListener(this);
    }

    public Vector<Component> getFocusComponents() {
        Vector<Component> order = new Vector<Component>();
        order.add(this.tree);
        return order;
    }

    private JTree getTree() {
        if (this.tree == null) {
            this.rootNode = new DefaultMutableTreeNode(this.rootFolder);
            this.nodeMap.put(this.rootFolder, this.rootNode);
            this.treeModel = new DefaultTreeModel(this.rootNode);
            this.tree = new JTree(this.treeModel);
            this.tree.setCellRenderer(new CustomTreeCellRenderer());
            this.tree.getSelectionModel().setSelectionMode(4);
            this.tree.addTreeSelectionListener(this);
            this.tree.addMouseListener(new TreeMouseListener());
        }
        return this.tree;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void insertData(DataItem data) {
        if (this.nodeMap.containsKey(data)) {
            throw new RuntimeException(data.getName() + " already exists in tree");
        }
        if (data.getParent() != null && !this.nodeMap.containsKey(data.getParent())) throw new RuntimeException("parent of " + data.getName() + " was not inserted (it is " + data.getParent().getName() + ")");
        if (data instanceof DataBean) {
            DefaultMutableTreeNode node = this.createNode(data);
            this.nodeMap.put(data, node);
            return;
        } else {
            if (!(data instanceof DataFolder)) throw new RuntimeException("illegal data type: " + data.getClass().getSimpleName());
            DataFolder folder = (DataFolder)data;
            if (folder.getParent() == null) {
                this.application.getDataManager().connectChild(folder, this.rootFolder);
            }
            DefaultMutableTreeNode node = this.createNode(folder);
            this.nodeMap.put(folder, node);
            for (DataItem data1 : folder.getChildren()) {
                this.insertData(data1);
            }
        }
    }

    public void removeData(DataItem data) {
        DefaultMutableTreeNode node = this.nodeMap.get(data);
        if (node == null) {
            throw new RuntimeException(data.getName() + " does not exists in tree");
        }
        this.treeModel.removeNodeFromParent(node);
        TreeNode parent = node.getParent();
        this.treeModel.nodeStructureChanged(parent);
        this.nodeMap.remove(data);
        this.tree.repaint();
    }

    private DefaultMutableTreeNode createNode(DataItem data) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(data);
        DataFolder parentFolder = data.getParent();
        DefaultMutableTreeNode parentNode = parentFolder != null ? this.nodeMap.get(parentFolder) : this.rootNode;
        assert (parentNode != null);
        this.treeModel.insertNodeInto(node, parentNode, parentNode.getChildCount());
        this.disableSelectionReporting = true;
        TreePath[] paths = this.tree.getSelectionPaths();
        this.treeModel.nodeStructureChanged(parentNode);
        this.tree.setSelectionPaths(paths);
        this.disableSelectionReporting = false;
        return node;
    }

    public void updateNameFor(DataItem data) {
        DefaultMutableTreeNode node = this.nodeMap.get(data);
        if (node != null) {
            this.treeModel.nodeStructureChanged(node);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent dataEvent) {
        logger.debug((Object)("got " + dataEvent.getClass().getSimpleName()));
        if (dataEvent instanceof DatasetChoiceEvent && dataEvent.getSource() != this) {
            LinkedList<TreePath> paths = new LinkedList<TreePath>();
            for (DataBean bean : this.application.getSelectionManager().getSelectedDataBeans()) {
                paths.add(new TreePath(this.nodeMap.get(bean).getPath()));
            }
            TreePath[] path = paths.toArray(new TreePath[paths.size()]);
            this.disableSelectionReporting = true;
            this.tree.setSelectionPaths(path);
            this.disableSelectionReporting = false;
            if (path.length > 0) {
                this.tree.scrollPathToVisible(path[path.length - 1]);
            }
        }
    }

    @Override
    public void dataChanged(final DataChangeEvent dataEvent) {
        SwingTools.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (dataEvent instanceof DataChangeEvent) {
                    DataItem data = dataEvent.getDataItem();
                    if (dataEvent instanceof DataItemCreatedEvent) {
                        TreePanel.this.insertData(data);
                    } else if (dataEvent instanceof DataItemRemovedEvent) {
                        TreePanel.this.removeData(data);
                    }
                    if (TreePanel.this.treeModel.getChildCount(TreePanel.this.treeModel.getRoot()) >= 1) {
                        TreePanel.this.cardLayout.last(TreePanel.this.cardParent);
                        TreePanel.this.tree.repaint();
                    } else {
                        TreePanel.this.cardLayout.first(TreePanel.this.cardParent);
                    }
                }
            }
        });
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (!this.disableSelectionReporting) {
            this.application.getSelectionManager().clearAll(false, this);
            TreePath[] paths = this.tree.getSelectionPaths();
            ArrayList<DataItem> selected = new ArrayList<DataItem>();
            for (int i = 0; i < paths.length; ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                selected.add((DataItem)node.getUserObject());
            }
            this.application.getSelectionManager().selectMultiple(selected, (Object)this);
        }
    }

    private class CustomTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private CustomTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            DataItem element = (DataItem)node.getUserObject();
            DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            renderer.setIcon(TreePanel.this.application.getIconFor(element));
            renderer.setText(element.toString() + " ");
            return this;
        }
    }

    private class TreeMouseListener
    extends MouseAdapter {
        private TreeMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
                DataItem selectedItem = this.getSelectedElementFrom(e);
                if (selectedItem instanceof DataBean) {
                    TreePanel.this.application.visualiseWithBestMethod(VisualisationFrameManager.FrameType.MAIN);
                } else if (selectedItem instanceof DataFolder) {
                    DataFolder folder = (DataFolder)selectedItem;
                    TreePanel.this.application.getSelectionManager().clearAll(false, this);
                    TreePanel.this.application.getSelectionManager().selectMultiple(folder.getChildren(), (Object)this);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private DataItem getSelectedElementFrom(MouseEvent e) {
            Object selectedUserObject;
            Object selectedNode;
            TreePath selectedPath = TreePanel.this.tree.getPathForLocation(e.getX(), e.getY());
            if (selectedPath != null && (selectedNode = selectedPath.getLastPathComponent()) instanceof DefaultMutableTreeNode && (selectedUserObject = ((DefaultMutableTreeNode)selectedNode).getUserObject()) != null && selectedUserObject instanceof DataItem) {
                return (DataItem)selectedUserObject;
            }
            return null;
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (this.getSelectedElementFrom(e) instanceof DataFolder) {
                    TreePanel.this.tree.setSelectionPath(TreePanel.this.tree.getPathForLocation(e.getX(), e.getY()));
                    TreePanel.this.application.showPopupMenuFor(e, this.getSelectedElementFrom(e));
                } else {
                    ArrayList<DataItem> items = new ArrayList<DataItem>();
                    for (DataBean bean : TreePanel.this.application.getSelectionManager().getSelectedDataBeans()) {
                        items.add(bean);
                    }
                    TreePanel.this.application.showPopupMenuFor(e, items);
                }
            }
        }
    }
}

