/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.parameter.InputParameters;
import fi.csc.microarray.client.operation.parameter.ParameterInputComponent;
import fi.csc.microarray.client.operation.parameter.SingleSelectionInputComponent;
import fi.csc.microarray.client.operation.parameter.SteppedComboBox;
import fi.csc.microarray.databeans.DataBean;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public abstract class InputFileComponent
extends JPanel {
    private static final Logger logger = Logger.getLogger(SingleSelectionInputComponent.class);
    private OperationDefinition.InputDefinition input;

    public InputFileComponent(OperationDefinition.InputDefinition input) {
        super(new BorderLayout());
        this.input = input;
    }

    public OperationDefinition.InputDefinition getInput() {
        return this.input;
    }

    public abstract JComponent getComponent();

    public abstract List<DataBean> getSelectedItems();

    public abstract void removeSelected(Object var1);

    public JLabel getLabel() {
        return new JLabel(this.input.getDisplayName());
    }

    public static class MultiInput
    extends InputFileComponent {
        private JList<DataBean> list;
        private List<DataBean> options;

        public MultiInput(OperationDefinition.InputDefinition input, Operation operation, InputParameters inputParameters, List<DataBean> options, List<DataBean> selected) {
            super(input);
            this.options = options;
            this.list = new JList<DataBean>(options.toArray(new DataBean[0]));
            this.list.setMinimumSize(new Dimension((int)ParameterInputComponent.PREFERRED_SIZE.getWidth(), this.list.getMinimumSize().height));
            this.list.setBorder(new LineBorder(Color.gray));
            this.list.setSelectionMode(2);
            for (int i = 0; i < selected.size(); ++i) {
                if (!selected.contains(options.get(i))) continue;
                this.list.addSelectionInterval(i, i);
            }
            this.add(this.list, "Center");
            this.initListener(inputParameters);
        }

        private void initListener(final InputParameters inputParameters) {
            this.list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    for (DataBean data : list.getSelectedValuesList()) {
                        inputParameters.bind(data, e.getSource());
                    }
                }
            });
        }

        @Override
        public JComponent getComponent() {
            return this.list;
        }

        @Override
        public List<DataBean> getSelectedItems() {
            return this.list.getSelectedValuesList();
        }

        @Override
        public void removeSelected(Object selected) {
            int index = this.options.indexOf(selected);
            this.list.removeSelectionInterval(index, index);
        }
    }

    public static class SingleInput
    extends InputFileComponent {
        private SteppedComboBox choiceBox;

        public SingleInput(OperationDefinition.InputDefinition input, Operation operation, InputParameters inputParameters, List<DataBean> options, DataBean selected) {
            super(input);
            this.choiceBox = new SteppedComboBox(options.toArray());
            Dimension preferredSize = this.choiceBox.getPreferredSize();
            this.choiceBox.setMinimumSize(ParameterInputComponent.PREFERRED_SIZE);
            this.choiceBox.setPreferredSize(ParameterInputComponent.PREFERRED_SIZE);
            this.choiceBox.setPopupWidth(preferredSize.width);
            this.choiceBox.setBackground(Color.white);
            this.choiceBox.setSelectedItem(selected);
            this.add((Component)this.choiceBox, "Center");
            this.initListener(inputParameters);
        }

        private void initListener(final InputParameters inputParameters) {
            this.choiceBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() != 2) {
                        inputParameters.bind((DataBean)e.getItem(), e.getSource());
                    }
                }
            });
        }

        @Override
        public JComponent getComponent() {
            return this.choiceBox;
        }

        @Override
        public List<DataBean> getSelectedItems() {
            ArrayList<DataBean> items = new ArrayList<DataBean>();
            for (Object dataBean : this.choiceBox.getSelectedObjects()) {
                items.add((DataBean)dataBean);
            }
            return items;
        }

        @Override
        public void removeSelected(Object selected) {
            if (selected.equals(this.choiceBox.getSelectedItem())) {
                this.choiceBox.setSelectedItem(null);
            }
        }
    }
}

