/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.module.basic.BasicModule;
import java.util.List;
import javax.swing.ImageIcon;

public class VisualisationMethod {
    private final ClientApplication application = Session.getSession().getApplication();
    private String name;
    private Class<? extends Visualisation> visualiser;
    private String iconPath;
    private ImageIcon icon;
    private int orderNumber;
    private double durationEstimationFactor;
    private String helpAddress = null;

    public String getName() {
        return this.name;
    }

    public VisualisationMethod(String name, Class<? extends Visualisation> visualiser, String iconPath, int orderNumber, double durationEstimationFactor) {
        this.name = name;
        this.visualiser = visualiser;
        this.iconPath = iconPath;
        this.orderNumber = orderNumber;
        this.durationEstimationFactor = durationEstimationFactor;
    }

    public VisualisationMethod(String name, Class<? extends Visualisation> visualiser, String iconPath, int orderNumber, double durationEstimationFactor, String helpAddress) {
        this(name, visualiser, iconPath, orderNumber, durationEstimationFactor);
        this.helpAddress = helpAddress;
    }

    public String toString() {
        return this.name;
    }

    public Class<? extends Visualisation> getVisualiserClass() {
        return this.visualiser;
    }

    public Visualisation getVisualiser(VisualisationFrame frame) throws Exception {
        Visualisation visualisation = this.visualiser.getConstructor(new Class[0]).newInstance(new Object[0]);
        visualisation.initialise(frame);
        return visualisation;
    }

    public Visualisation getHeadlessVisualiser() {
        try {
            return this.visualiser.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            this.application.reportException(e);
            return null;
        }
    }

    public int getOrderNumber() {
        return this.orderNumber;
    }

    public ImageIcon getIcon() {
        if (this.icon == null) {
            this.icon = VisualConstants.getIcon(this.iconPath);
        }
        return this.icon;
    }

    public static boolean isDefault(VisualisationMethod method) {
        return method == null || method == BasicModule.VisualisationMethods.DATA_DETAILS || method == BasicModule.VisualisationMethods.SESSION_DETAILS || method == BasicModule.VisualisationMethods.EMPTY;
    }

    public long estimateDuration(List<DataBean> datas) {
        Long length;
        if (datas.size() > 0 && (length = Session.getSession().getDataManager().getContentLength(datas.get(0))) != null) {
            return (long)((double)length.longValue() * this.durationEstimationFactor * (double)datas.size());
        }
        return -1L;
    }

    public boolean isApplicableTo(DataBean bean) throws MicroarrayException {
        if (bean != null) {
            return this.getHeadlessVisualiser().canVisualise(bean);
        }
        return false;
    }

    public boolean isApplicableTo(List<DataBean> beans) throws MicroarrayException {
        if (!this.getHeadlessVisualiser().isForMultipleDatas()) {
            return false;
        }
        return this.getHeadlessVisualiser().canVisualise(beans);
    }

    public String getHelpAddress() {
        return this.helpAddress;
    }
}

