/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.exception.MicroarrayException;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;

public class SessionDetails
extends Visualisation
implements FocusListener,
DocumentListener,
MouseListener {
    private final String PLEASE_ADD_NOTES = "(Click here to add your notes)";
    private JTextArea notesField;
    private JPanel panel;
    private static final Color BG = Color.white;
    public static final int LEFT_WIDTH = 450;
    public static final int INDENTION = 20;
    private JTextArea titleField;
    private JScrollPane scroller;

    @Override
    public void initialise(VisualisationFrame frame) throws Exception {
        super.initialise(frame);
    }

    private JPanel getPanelBase(String ... layoutArgs) {
        MigLayout layout = null;
        switch (layoutArgs.length) {
            case 0: {
                layout = new MigLayout();
                break;
            }
            case 1: {
                layout = new MigLayout(layoutArgs[0]);
                break;
            }
            case 2: {
                layout = new MigLayout(layoutArgs[0], layoutArgs[1]);
                break;
            }
            default: {
                layout = new MigLayout(layoutArgs[0], layoutArgs[1], layoutArgs[2]);
            }
        }
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.setBackground(BG);
        return panel;
    }

    private Component createNotes() {
        if (Session.getSession().getPrimaryModule().notesVisibleAtStartup()) {
            this.notesField = new JTextArea();
            this.notesField.setEditable(true);
            this.notesField.setLineWrap(true);
            this.notesField.setWrapStyleWord(true);
            this.notesField.addFocusListener(this);
            this.notesField.getDocument().addDocumentListener(this);
            this.notesField.setRows(1);
            this.setNotesActive(false);
            this.notesField.setEnabled(true);
            this.notesField.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() == '\u001b') {
                        SessionDetails.this.endEditing();
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }
            });
            return this.notesField;
        }
        return this.getPanelBase(new String[0]);
    }

    private JTextArea createTitleTextArea() {
        this.titleField = new JTextArea("Session name");
        this.titleField.setFont(this.titleField.getFont().deriveFont(this.titleField.getFont().getSize2D() * 1.5f));
        this.titleField.setEditable(false);
        return this.titleField;
    }

    private void updateContent() {
        String name = this.application.getSessionManager().getSessionName();
        if (name == null) {
            name = "Unsaved session";
        }
        this.titleField.setText(name);
        this.setNotes(this.application.getSessionManager().getSessionNotes());
    }

    private void endEditing() {
        this.scroller.requestFocusInWindow();
    }

    private Component createDatasetPanel() {
        JPanel panel = this.getPanelBase("wrap 1, fillx");
        panel.add((Component)this.createTitleTextArea(), "growx");
        panel.add(this.createNotes(), "gapx 20, growx");
        this.updateContent();
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JComponent getVisualisation(List<DataBean> datas) throws Exception {
        SessionDetails sessionDetails = this;
        synchronized (sessionDetails) {
            this.panel = this.getPanelBase("gapy 20");
            this.scroller = new JScrollPane(this.panel);
            return this.scroller;
        }
    }

    @Override
    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        return bean == null;
    }

    @Override
    public boolean canVisualise(List<DataBean> datas) throws MicroarrayException {
        return datas.isEmpty();
    }

    private void setNotes(String text) {
        if (text == null || "".equals(text.trim())) {
            this.notesField.setText("(Click here to add your notes)");
        } else {
            this.notesField.setText(text);
        }
        this.setNotesActive(false);
    }

    private String getNotesContent() {
        if ("(Click here to add your notes)".equals(this.notesField.getText())) {
            return "";
        }
        return this.notesField.getText();
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getComponent() == this.notesField) {
            this.setNotesActive(true);
            if ("(Click here to add your notes)".equals(this.notesField.getText())) {
                this.notesField.setSelectionStart(0);
                this.notesField.setSelectionEnd(this.notesField.getText().length());
                this.notesField.setBorder(new LineBorder(Color.gray));
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getComponent() == this.notesField) {
            this.setNotes(this.application.getSessionManager().getSessionNotes());
        }
    }

    private void setNotesActive(boolean active) {
        if (active) {
            this.notesField.setBorder(new LineBorder(Color.gray));
        } else {
            this.notesField.setBorder(new LineBorder(BG));
            this.notesField.setEnabled(false);
            this.notesField.setEnabled(true);
            this.notesField.setSelectionStart(0);
            this.notesField.setSelectionEnd(0);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fieldUpdated(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fieldUpdated(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fieldUpdated(e);
    }

    private void fieldUpdated(DocumentEvent e) {
        if (e.getDocument() == this.notesField.getDocument()) {
            this.setNotesActive(true);
            this.application.getSessionManager().setSessionNotes(this.getNotesContent());
        }
    }

    @Override
    public JComponent getVisualisation(DataBean data) throws Exception {
        return this.getVisualisation(new ArrayList<DataBean>());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.endEditing();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visualisationShown() {
        SessionDetails sessionDetails = this;
        synchronized (sessionDetails) {
            this.panel.removeAll();
            this.panel.add(this.createDatasetPanel(), "gapx 20, aligny top, width 470");
            this.panel.addMouseListener(this);
            this.scroller.setBorder(null);
        }
    }
}

