/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.client.selection.IntegratedSelectionManager;
import fi.csc.microarray.client.selection.SelectionEvent;
import fi.csc.microarray.client.visualisation.SelectionList;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.client.visualisation.VisualisationUtilities;
import fi.csc.microarray.client.visualisation.methods.VenndiPlot;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.module.chipster.MicroarrayModule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;

public class VennDiagram
extends Visualisation
implements PropertyChangeListener,
ActionListener {
    private VenndiPlot plot;
    private ChartPanel chartPanel;
    private JPanel paramPanel;
    private SelectionList list;
    private JButton useButton;
    private JComboBox colBox;
    private Visualisation.Variable colVar;
    private static final Visualisation.Variable SPACE_ID = new Visualisation.Variable("identifier", "/column/ ");
    private static final Visualisation.Variable IDENTIFIER_ID = new Visualisation.Variable("identifier", "/column/identifier");

    @Override
    public void initialise(VisualisationFrame frame) throws Exception {
        super.initialise(frame);
    }

    @Override
    public JPanel getParameterPanel() {
        if (this.paramPanel == null) {
            this.paramPanel = new JPanel();
            this.paramPanel.setPreferredSize(Visualisation.PARAMETER_SIZE);
            this.paramPanel.setLayout(new BorderLayout());
            JPanel settings = this.createSettingsPane1l();
            this.list = new SelectionList("Unique", true, false);
            JTabbedPane tabPane = new JTabbedPane();
            tabPane.addTab("Settings", settings);
            tabPane.addTab("Selected", this.list);
            this.paramPanel.add((Component)tabPane, "Center");
        }
        return this.paramPanel;
    }

    private JPanel createSettingsPane1l() {
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout(new GridBagLayout());
        settingsPanel.setPreferredSize(Visualisation.PARAMETER_SIZE);
        this.colBox = new JComboBox();
        this.useButton = new JButton("Draw");
        this.useButton.addActionListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.insets.set(10, 10, 10, 10);
        c.anchor = 18;
        c.fill = 2;
        c.weighty = 0.0;
        c.weightx = 1.0;
        settingsPanel.add((Component)new JLabel("Column to compare: "), c);
        ++c.gridy;
        settingsPanel.add((Component)this.colBox, c);
        ++c.gridy;
        settingsPanel.add((Component)this.useButton, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        settingsPanel.add((Component)new JPanel(), c);
        this.colBox.addActionListener(this);
        return settingsPanel;
    }

    @Override
    public JComponent getVisualisation(List<DataBean> datas) throws Exception {
        if (datas.size() < 2 || datas.size() > 3) {
            throw new IllegalArgumentException("Venn Diagram can be used only with two or three datasets");
        }
        this.refreshColumnBox(datas);
        List<Visualisation.Variable> vars = this.getFrame().getVariables();
        if (vars != null && vars.size() == 1) {
            this.colBox.setSelectedItem(vars.get(0));
        }
        this.colVar = (Visualisation.Variable)this.colBox.getSelectedItem();
        HashMap<String, Integer> A = new HashMap<String, Integer>();
        HashMap<String, Integer> B = new HashMap<String, Integer>();
        HashMap<String, Integer> C = new HashMap<String, Integer>();
        int i = 0;
        for (String string : this.getIdentifiers(datas.get(0), this.colVar)) {
            A.put(string, i++);
        }
        i = 0;
        for (String string : this.getIdentifiers(datas.get(1), this.colVar)) {
            B.put(string, i++);
        }
        i = 0;
        if (datas.size() == 3) {
            for (String string : this.getIdentifiers(datas.get(2), this.colVar)) {
                C.put(string, i++);
            }
        }
        HashMap sortedIds = new HashMap(VenndiPlot.AREAS.values().length);
        for (VenndiPlot.AREAS area : VenndiPlot.AREAS.values()) {
            sortedIds.put(area, new HashSet());
        }
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.ABC)).addAll(A.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.ABC)).retainAll(B.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.ABC)).retainAll(C.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.AB)).addAll(A.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.AB)).retainAll(B.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.AB)).removeAll(C.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.BC)).addAll(B.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.BC)).retainAll(C.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.BC)).removeAll(A.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.AC)).addAll(A.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.AC)).retainAll(C.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.AC)).removeAll(B.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.A)).addAll(A.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.A)).removeAll(B.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.A)).removeAll(C.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.B)).addAll(B.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.B)).removeAll(A.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.B)).removeAll(C.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.C)).addAll(C.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.C)).removeAll(A.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.C)).removeAll(B.keySet());
        String[][] stringArray = new String[VenndiPlot.AREAS.values().length][];
        for (VenndiPlot.AREAS area : VenndiPlot.AREAS.values()) {
            stringArray[area.ordinal()] = ((Set)sortedIds.get((Object)area)).toArray(new String[0]);
        }
        HashMap<DataBean, Map<String, Integer>> indexMaps = new HashMap<DataBean, Map<String, Integer>>();
        indexMaps.put(datas.get(0), A);
        indexMaps.put(datas.get(1), B);
        if (datas.size() > 2) {
            indexMaps.put(datas.get(2), C);
        }
        this.plot = new VenndiPlot(stringArray, datas, indexMaps, this);
        this.chartPanel = VennDiagram.makePanel(new JFreeChart("Venn-diagram", (Plot)this.plot));
        this.chartPanel.addChartMouseListener((ChartMouseListener)this.plot);
        this.updateSelectionsFromApplication(false);
        this.application.addClientEventListener(this);
        return this.chartPanel;
    }

    private Iterable<String> getIdentifiers(DataBean dataBean, Visualisation.Variable var) throws MicroarrayException {
        if (IDENTIFIER_ID.equals(var) && !dataBean.queryFeatures(var.getExpression()).exists()) {
            var = SPACE_ID;
        }
        return dataBean.queryFeatures(var.getExpression()).asStrings();
    }

    @Override
    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        return false;
    }

    @Override
    public boolean canVisualise(List<DataBean> beans) throws MicroarrayException {
        if (beans.size() < 2 || beans.size() > 3) {
            return false;
        }
        for (DataBean data : beans) {
            if (this.isTabular(data) && data.hasTypeTag(MicroarrayModule.TypeTags.GENENAMES)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isForSingleData() {
        return false;
    }

    @Override
    public boolean isForMultipleDatas() {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt instanceof SelectionEvent && evt.getSource() != this) {
            this.updateSelectionsFromApplication(false);
        }
    }

    private void updateSelectionsFromApplication(boolean dispatchEvent) {
        ArrayList<String> selected = new ArrayList<String>();
        try {
            for (DataBean data : this.plot.getDataset().getDataBeans()) {
                IntegratedSelectionManager manager = this.application.getSelectionManager().getSelectionManager(data);
                selected.addAll(manager.getSelectionAsIdentifiers());
            }
        }
        catch (MicroarrayException e) {
            this.application.reportException(new MicroarrayException("Unable to get selected identifiers", e));
        }
        this.plot.setSelected(selected);
        this.plot.setSelectedForList(false);
        this.chartPanel.repaint();
    }

    @Override
    public JComponent getVisualisation(DataBean data) throws Exception {
        throw new MicroarrayException("Venn Diagram can be used only with two or three datasets");
    }

    public void setSelectedListContent(List<String> ids, Map<DataBean, Set<Integer>> indexes, VenndiPlot venndiPlot, boolean dispatchEvent) {
        this.list.setSelectedListContentMultipleDatas(ids, indexes, this, this.colVar.getName().equals("identifier"), dispatchEvent);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.useButton) {
            this.useButtonPressed();
        }
    }

    protected void useButtonPressed() {
        ArrayList<Visualisation.Variable> vars = new ArrayList<Visualisation.Variable>();
        vars.add((Visualisation.Variable)this.colBox.getSelectedItem());
        this.application.setVisualisationMethod(new VisualisationMethodChangedEvent(this, MicroarrayModule.VisualisationMethods.VENN_DIAGRAM, vars, this.getFrame().getDatas(), this.getFrame().getType(), this.getFrame()));
    }

    protected void refreshColumnBox(List<DataBean> datas) {
        if (this.paramPanel == null) {
            throw new IllegalStateException("must call getParameterPanel first");
        }
        List<Visualisation.Variable> colsA = Arrays.asList(this.getVariablesFor(datas.get(0)));
        List<Visualisation.Variable> colsB = Arrays.asList(this.getVariablesFor(datas.get(1)));
        List<Visualisation.Variable> colsC = null;
        this.normalize(colsA);
        this.normalize(colsB);
        LinkedList<Visualisation.Variable> commonCols = new LinkedList<Visualisation.Variable>();
        commonCols.addAll(colsA);
        commonCols.retainAll(colsB);
        if (datas.size() > 2) {
            colsC = Arrays.asList(this.getVariablesFor(datas.get(2)));
            this.normalize(colsC);
            commonCols.retainAll(colsC);
        }
        Visualisation.fillComboBox(this.colBox, commonCols.toArray());
    }

    private void normalize(List<Visualisation.Variable> vars) {
        for (int i = 0; i < vars.size(); ++i) {
            if (!SPACE_ID.equals(vars.get(i))) continue;
            vars.set(i, IDENTIFIER_ID);
        }
    }

    @Override
    public Visualisation.Variable[] getVariablesFor(DataBean data) {
        String[] banList = new String[]{"chip.", "flag."};
        return VisualisationUtilities.getVariablesFilteredExclusive(data, Arrays.asList(banList), false);
    }
}

