/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.ChromosomeNameUnnormaliser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.SamBamUtils;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CloseableIterator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.LinkedList;

public class BamDataSource
extends DataSource {
    private ChromosomeNameUnnormaliser chromosomeNameUnnormaliser = ChromosomeNameUnnormaliser.newIdentityPreversingUnnormaliser();
    private SAMFileReader reader;

    public BamDataSource(DataUrl data, DataUrl index) throws URISyntaxException, IOException {
        super(data);
        PrintStream originalErr = System.err;
        System.setErr(new PrintStream(new ByteArrayOutputStream()));
        SAMFileReader.setDefaultValidationStringency((ValidationStringency)ValidationStringency.SILENT);
        this.reader = SamBamUtils.getSAMReader(data.getUrl(), index.getUrl());
        LinkedList<String> chrList = new LinkedList<String>();
        for (SAMSequenceRecord sequenceRecord : this.reader.getFileHeader().getSequenceDictionary().getSequences()) {
            String name = sequenceRecord.getSequenceName();
            chrList.add(name);
        }
        this.chromosomeNameUnnormaliser = new ChromosomeNameUnnormaliser(chrList);
        System.setErr(originalErr);
    }

    public void close() {
        SamBamUtils.closeIfPossible(this.reader);
    }

    public CloseableIterator<SAMRecord> query(Chromosome chr, int start, int end) {
        String unnormalisedChr = this.chromosomeNameUnnormaliser.unnormalise(chr);
        SAMRecordIterator iterator = this.reader.query(unnormalisedChr, start, end, false);
        return iterator;
    }
}

