/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.ByteDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.LineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.ChromosomeNameUnnormaliser;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.reference.ChipsterIndexedFastaSequenceFile;
import htsjdk.samtools.reference.ReferenceSequence;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;

public class IndexedFastaDataSource
extends DataSource {
    private ChromosomeNameUnnormaliser chromosomeNameUnnormaliser = ChromosomeNameUnnormaliser.newIdentityPreversingUnnormaliser();
    private URL dataUrl;
    private URL indexUrl;
    private ChipsterIndexedFastaSequenceFile picard;

    public IndexedFastaDataSource(DataUrl data, DataUrl index) throws URISyntaxException, IOException {
        super(data);
        this.dataUrl = data.getUrl();
        this.indexUrl = index.getUrl();
        ByteDataSource dataSource = new ByteDataSource(data);
        LineDataSource indexSource = new LineDataSource(index);
        this.picard = new ChipsterIndexedFastaSequenceFile(dataSource, indexSource);
        this.chromosomeNameUnnormaliser = new ChromosomeNameUnnormaliser(this.picard.getContigs());
    }

    public URL getIndex() {
        return this.indexUrl;
    }

    public URL getUrl() {
        return this.dataUrl;
    }

    public String query(Chromosome chr, Long start, Long end) {
        String chrString = this.chromosomeNameUnnormaliser.unnormalise(chr);
        try {
            ReferenceSequence picardSequence = this.picard.getSubsequenceAt(chrString, start, end);
            return new String(picardSequence.getBases());
        }
        catch (SAMException e) {
            e.printStackTrace();
            return null;
        }
    }
}

