/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.operation.parameter.SteppedComboBox;
import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.AnnotationManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.BrowserSelectionListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserLegend;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserPlot;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GeneIndexActions;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Interpretation;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.RegionListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.SelectionPanel;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.AnnotationTrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SampleTrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Selectable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.UnsortedDataException;
import fi.csc.microarray.util.LinkUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXHyperlink;

public class GBrowserSettings
implements ActionListener,
RegionListener {
    private static final long DEFAULT_VIEWSIZE = 100000L;
    private static final long DEFAULT_LOCATION = 45000L;
    private static final String FULL_WIDTH = "growx";
    private static final String GAPY = "gapy rel";
    private Long lastViewsize;
    private boolean initialised;
    private JPanel paramPanel;
    private JPanel settingsPanel = new JPanel();
    private JButton goButton = new JButton("Go");
    private JLabel locationLabel = new JLabel("Location (gene or position)");
    private JTextField locationField = new JTextField();
    private static final String VIEW_SIZE_TEXT = "View size: ";
    private JLabel viewsizeLabel = new JLabel("View size: ");
    private JLabel chrLabel = new JLabel("Chromosome");
    private JComboBox<Chromosome> chrBox;
    private SteppedComboBox genomeBox;
    private JLabel coverageScaleLabel = new JLabel("Coverage scale");
    private JComboBox<GBrowserPlot.ReadScale> coverageScaleBox;
    private JLabel coverageTypeLabel = new JLabel("Coverage type");
    private JComboBox<CoverageType> coverageTypeBox;
    private Map<String, JCheckBox> trackSwitches = new LinkedHashMap<String, JCheckBox>();
    private JXHyperlink ensemblLink;
    private JXHyperlink ucscLink;
    private GBrowser browser;
    private Long lastLocation;
    private JTabbedPane tabPane;
    private JScrollPane selectedScrollPane;
    private JScrollPane settingsScrollPane;
    private JScrollPane legendScrollPane;
    volatile boolean failed = false;

    public void initialise(GBrowser browser) throws Exception {
        this.browser = browser;
        this.trackSwitches.put("Reads", new JCheckBox("Reads", true));
        this.trackSwitches.put("highlightSNP", new JCheckBox("Highlight SNPs", true));
        this.trackSwitches.put("DensityGraphTrack", new JCheckBox("Density graph", false));
        this.trackSwitches.put("RepeatMaskerTrack", new JCheckBox("Low complexity regions", false));
        this.trackSwitches.put("multimapping", new JCheckBox("Mark multimapping reads", false));
    }

    public JPanel getParameterPanel() {
        if (this.paramPanel == null) {
            this.paramPanel = new JPanel();
            this.paramPanel.setLayout((LayoutManager)new MigLayout("insets 0, fill"));
            this.settingsPanel.setLayout((LayoutManager)new MigLayout("wrap 1, fillx, gapy 0"));
            JPanel settings = this.createSettingsPanel();
            SelectionPanel selectionPanel = new SelectionPanel(this.browser.getSelectionManager());
            GBrowserLegend legend = new GBrowserLegend(this.browser);
            this.settingsScrollPane = new JScrollPane(settings);
            this.selectedScrollPane = new JScrollPane(selectionPanel);
            this.legendScrollPane = new JScrollPane(legend);
            this.settingsScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.selectedScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.legendScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.settingsScrollPane.setHorizontalScrollBarPolicy(31);
            this.tabPane = new JTabbedPane();
            this.tabPane.addTab("Settings", this.settingsScrollPane);
            this.tabPane.addTab("Selected", this.selectedScrollPane);
            this.tabPane.addTab("Legend", this.legendScrollPane);
            this.browser.getSelectionManager().addSelectionListener(new BrowserSelectionListener(){

                @Override
                public void selectionChanged(DataUrl data, Selectable selectable, Object source) {
                    if (selectable != null) {
                        GBrowserSettings.this.tabPane.setSelectedComponent(GBrowserSettings.this.selectedScrollPane);
                    }
                }
            });
            this.paramPanel.add((Component)this.tabPane, "top, grow");
        }
        return this.paramPanel;
    }

    public void createOptions() {
        this.setTrackSwitchesEnabled(false);
        for (JCheckBox trackSwitch : this.trackSwitches.values()) {
            trackSwitch.addActionListener(this);
            this.settingsPanel.add((Component)trackSwitch, GAPY);
        }
        this.coverageTypeLabel.setEnabled(false);
        this.settingsPanel.add((Component)this.coverageTypeLabel, GAPY);
        this.coverageTypeBox = new JComboBox<CoverageType>(new CoverageType[]{CoverageType.NONE, CoverageType.TOTAL, CoverageType.STRAND, CoverageType.STRAND_XS});
        this.coverageTypeBox.setSelectedItem((Object)CoverageType.TOTAL);
        this.coverageTypeBox.setEnabled(false);
        this.coverageTypeBox.addActionListener(this);
        this.settingsPanel.add(this.coverageTypeBox, FULL_WIDTH);
        this.coverageScaleLabel.setEnabled(false);
        this.settingsPanel.add((Component)this.coverageScaleLabel, GAPY);
        this.coverageScaleBox = new JComboBox<GBrowserPlot.ReadScale>(GBrowserPlot.ReadScale.values());
        this.coverageScaleBox.setSelectedItem((Object)GBrowserPlot.ReadScale.SMALL);
        this.coverageScaleBox.setEnabled(false);
        this.coverageScaleBox.addActionListener(this);
        this.settingsPanel.add(this.coverageScaleBox, FULL_WIDTH);
    }

    private void createExternalLinks() {
        this.ensemblLink = LinkUtil.createLink("Ensembl", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GBrowserSettings.this.browser.openExternalBrowser(GBrowserSettings.this.browser.getExternalLinkUrl(AnnotationManager.AnnotationType.ENSEMBL_BROWSER_URL));
            }
        });
        this.ucscLink = LinkUtil.createLink("UCSC", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GBrowserSettings.this.browser.openExternalBrowser(GBrowserSettings.this.browser.getExternalLinkUrl(AnnotationManager.AnnotationType.UCSC_BROWSER_URL));
            }
        });
        this.ensemblLink.setEnabled(false);
        this.ucscLink.setEnabled(false);
        JPanel row1 = new JPanel((LayoutManager)new MigLayout("insets 0, gap 0"));
        JPanel row2 = new JPanel((LayoutManager)new MigLayout("insets 0, gap 0"));
        row1.add(new JLabel("View this region in "));
        row1.add((Component)this.ensemblLink);
        row1.add((Component)new JLabel(" or "), "wrap");
        row2.add((Component)this.ucscLink);
        row2.add(new JLabel(" genome browser."));
        this.settingsPanel.add((Component)row1, GAPY);
        this.settingsPanel.add((Component)row2, GAPY);
    }

    private void setExternalLinksEnabled() {
        this.ensemblLink.setEnabled(this.browser.getExternalLinkUrl(AnnotationManager.AnnotationType.ENSEMBL_BROWSER_URL).length() > 0);
        this.ucscLink.setEnabled(this.browser.getExternalLinkUrl(AnnotationManager.AnnotationType.UCSC_BROWSER_URL).length() > 0);
    }

    public JPanel createSettingsPanel() {
        this.settingsPanel.add((Component)GBrowserSettings.createTitle("Genome"), "gaptop unrelated");
        this.createGenomeSettings();
        this.settingsPanel.add((Component)GBrowserSettings.createTitle("Location"), "gaptop unrelated");
        this.createLocationSettings();
        this.settingsPanel.add((Component)GBrowserSettings.createTitle("Options"), "gaptop unrelated");
        this.createOptions();
        this.settingsPanel.add((Component)GBrowserSettings.createTitle("External links"), "gaptop unrelated");
        this.createExternalLinks();
        return this.settingsPanel;
    }

    private void createGenomeSettings() {
        Object[] genomes = this.browser.getAnnotationManager().getGenomes().toArray();
        this.genomeBox = new SteppedComboBox(genomes);
        this.genomeBox.setPopupWidth(500);
        this.genomeBox.setBackground(Color.white);
        this.genomeBox.setSelectedItem(null);
        this.genomeBox.addActionListener(this);
        this.settingsPanel.add((Component)this.genomeBox, "w 100:200:300, growx, gapy rel");
    }

    private void createLocationSettings() {
        this.chrLabel.setEnabled(false);
        this.settingsPanel.add((Component)this.chrLabel, GAPY);
        this.chrBox = new JComboBox();
        this.chrBox.setEnabled(false);
        this.settingsPanel.add(this.chrBox, FULL_WIDTH);
        this.locationLabel.setEnabled(false);
        this.settingsPanel.add((Component)this.locationLabel, GAPY);
        this.locationField.setEnabled(false);
        this.locationField.addActionListener(this);
        this.settingsPanel.add((Component)this.locationField, FULL_WIDTH);
        this.viewsizeLabel.setEnabled(false);
        this.setCoordinateFields(null, 100000L);
        this.lastViewsize = 100000L;
        this.settingsPanel.add((Component)this.viewsizeLabel, GAPY);
        this.goButton.setEnabled(false);
        this.goButton.addActionListener(this);
        this.settingsPanel.add((Component)this.goButton, "growx, gapy rel");
    }

    protected void fillChromosomeBox() throws IOException, UnsortedDataException, URISyntaxException, GBrowserException {
        LinkedList<Chromosome> chromosomes = this.browser.getChromosomeNames();
        for (Chromosome chromosome : chromosomes) {
            this.chrBox.addItem(chromosome);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.goButton || source == this.locationField) {
            this.genomeBox.setEnabled(false);
            if (!this.initialised) {
                this.browser.runBlockingTask("initialising genome browser", new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        GBrowserSettings.this.browser.showVisualisation();
                                    }
                                    catch (Exception e) {
                                        GBrowserSettings.this.browser.reportException(e);
                                        GBrowserSettings.this.failed = true;
                                    }
                                }
                            });
                            if (!GBrowserSettings.this.failed) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            GBrowserSettings.this.processLocationPanelInput();
                                            GBrowserSettings.this.setExternalLinksEnabled();
                                            GBrowserSettings.this.initialised = true;
                                        }
                                        catch (Exception e) {
                                            GBrowserSettings.this.browser.reportException(e);
                                        }
                                    }
                                });
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            } else {
                this.processLocationPanelInput();
                this.setExternalLinksEnabled();
            }
        } else if (source == this.coverageScaleBox && this.initialised) {
            this.browser.updateCoverageScale();
        } else if ((this.trackSwitches.values().contains(source) || source == this.coverageTypeBox) && this.initialised) {
            this.updateVisibilityForTracks();
        } else if (source == this.genomeBox) {
            AnnotationManager.Genome genome = (AnnotationManager.Genome)this.genomeBox.getSelectedItem();
            if (!this.browser.getAnnotationManager().hasLocalAnnotations(genome)) {
                this.browser.openDownloadAnnotationsDialog(genome);
            }
            this.goButton.setEnabled(true);
            this.chrLabel.setEnabled(true);
            this.chrBox.setEnabled(true);
            this.locationLabel.setEnabled(true);
            this.locationField.setEnabled(true);
            this.viewsizeLabel.setEnabled(true);
            this.coverageTypeLabel.setEnabled(true);
            this.coverageTypeBox.setEnabled(true);
            this.coverageScaleLabel.setEnabled(true);
            this.coverageScaleBox.setEnabled(true);
            this.setTrackSwitchesEnabled(true);
        }
    }

    private void setTrackSwitchesEnabled(boolean enabled) {
        for (JCheckBox trackSwitch : this.trackSwitches.values()) {
            trackSwitch.setEnabled(enabled);
            if (!enabled || !"RepeatMaskerTrack".equals(this.trackSwitches.get(trackSwitch))) continue;
            trackSwitch.setEnabled(this.browser.getAnnotationUrl(this.getGenome(), AnnotationManager.AnnotationType.REPEAT) != null);
        }
    }

    public void setCoordinateFields(Long location, Long viewsize) {
        if (location != null) {
            this.locationField.setText(location.toString());
        }
        if (viewsize != null) {
            if (viewsize > 1000000L) {
                this.viewsizeLabel.setText(VIEW_SIZE_TEXT + Math.round((float)viewsize.longValue() / 1000000.0f) + " Mb");
            } else if (viewsize > 1000L) {
                this.viewsizeLabel.setText(VIEW_SIZE_TEXT + Math.round((float)viewsize.longValue() / 1000.0f) + " kb");
            } else {
                this.viewsizeLabel.setText(VIEW_SIZE_TEXT + viewsize + "");
            }
        }
    }

    public void updateVisibilityForTracks() {
        for (TrackGroup trackGroup : this.browser.getPlot().getDataView().getTrackGroups()) {
            if (trackGroup instanceof AnnotationTrackGroup) {
                AnnotationTrackGroup annotations = (AnnotationTrackGroup)trackGroup;
                annotations.setRepeatVisible(this.trackSwitches.get("RepeatMaskerTrack").isSelected());
            }
            if (!(trackGroup instanceof SampleTrackGroup)) continue;
            SampleTrackGroup samples = (SampleTrackGroup)trackGroup;
            samples.setCoverageType((CoverageType)((Object)this.coverageTypeBox.getSelectedItem()));
            samples.setReadsVisible(this.trackSwitches.get("Reads").isSelected());
            samples.setHighlightSnp(this.trackSwitches.get("highlightSNP").isSelected());
            samples.setMarkMultimappingReads(this.trackSwitches.get("multimapping").isSelected());
            samples.setDensityGraphVisible(this.trackSwitches.get("DensityGraphTrack").isSelected());
        }
        this.browser.getPlot().getDataView().reloadData();
    }

    public String getGoButtonText() {
        return this.goButton.getText();
    }

    public GBrowserPlot.ReadScale getCoverageScale() {
        return (GBrowserPlot.ReadScale)((Object)this.coverageScaleBox.getSelectedItem());
    }

    public AnnotationManager.Genome getGenome() {
        return (AnnotationManager.Genome)this.genomeBox.getSelectedItem();
    }

    public Chromosome getChromosome() {
        return (Chromosome)this.chrBox.getSelectedItem();
    }

    public void processLocationPanelInput() {
        if (this.locationField.getText().trim().isEmpty()) {
            this.setCoordinateFields(45000L, null);
        }
        if (!this.locationField.getText().isEmpty()) {
            if (!GeneIndexActions.checkIfNumber(this.locationField.getText())) {
                this.browser.requestGeneSearch(this.locationField.getText());
                this.setCoordinateFields(this.getLocation(), this.getViewSize());
            } else {
                this.browser.setLocation(this.getChromosome(), this.getLocationStart(), this.getLocationEnd());
            }
        }
    }

    public Long getLocation() {
        try {
            return Long.parseLong(this.locationField.getText());
        }
        catch (NumberFormatException e) {
            if (this.lastLocation != null) {
                return this.lastLocation;
            }
            return 45000L;
        }
    }

    private Long getLocationStart() {
        return this.getLocation() - this.getViewSize() / 2L;
    }

    private Long getLocationEnd() {
        return this.getLocation() + this.getViewSize() / 2L;
    }

    public Long getViewSize() {
        if (this.lastViewsize != null) {
            return this.lastViewsize;
        }
        return 100000L;
    }

    public boolean setChromosome(Chromosome chr) {
        this.chrBox.setSelectedItem(chr);
        return this.chrBox.getSelectedItem().equals(chr);
    }

    @Override
    public void regionChanged(Region bpRegion) {
        this.setCoordinateFields(bpRegion.getMid(), bpRegion.getLength());
        this.lastLocation = bpRegion.getMid();
        this.lastViewsize = bpRegion.getLength();
    }

    public static JLabel createTitle(String title) {
        JLabel label = new JLabel(title);
        label.setFont(UIManager.getFont("TitledBorder.font"));
        label.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        return label;
    }

    public void updateInterpretations() throws IOException, UnsortedDataException, URISyntaxException, GBrowserException {
        for (Interpretation interpretation : this.browser.getInterpretations()) {
            if (interpretation.getType() != Interpretation.TrackType.REFERENCE) continue;
            AnnotationManager.Genome ownGenome = new AnnotationManager.Genome(interpretation.getName(), "");
            this.genomeBox.addItem(ownGenome);
        }
        this.fillChromosomeBox();
    }

    public void updateTracks() {
        this.updateVisibilityForTracks();
    }

    public static enum CoverageType {
        NONE("none"),
        TOTAL("total"),
        STRAND("strand-specific"),
        STRAND_XS("strand-specific for RNA-seq");

        String name;

        private CoverageType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getId() {
            return "coverage type " + this.toString();
        }
    }
}

