/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.AbstractTsvLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.VcfLine;

public class VcfLineParser
extends AbstractTsvLineParser {
    @Override
    public Region getRegion() {
        if (this.isContentLine()) {
            long start = this.getLong(Column.POS.ordinal());
            Chromosome chr = new Chromosome(this.getString(Column.CHROM.ordinal()));
            return new Region(start, start, chr);
        }
        return null;
    }

    @Override
    public VcfLine getFileLine() {
        VcfLine line = new VcfLine();
        Region region = this.getRegion();
        line.setChrom(region.start.chr);
        line.setPos(region.start.bp);
        line.setId(this.getString(Column.ID.ordinal()));
        line.setRef(this.getString(Column.REF.ordinal()));
        line.setAlt(this.getString(Column.ALT.ordinal()));
        line.setQual(this.getFloat(Column.QUAL.ordinal()));
        line.setFilter(this.getString(Column.FILTER.ordinal()));
        line.setInfo(this.getString(Column.INFO.ordinal()));
        return line;
    }

    @Override
    public String getHeaderStart() {
        return "#";
    }

    public static enum Column {
        CHROM("CHROM"),
        POS("POS"),
        ID("ID"),
        REF("REF"),
        ALT("ALT"),
        QUAL("QUAL"),
        FILTER("FILTER"),
        INFO("INFO");

        private final String name;

        private Column(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

