/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.config;

import com.sun.org.apache.xerces.internal.util.URI;
import fi.csc.microarray.util.XmlUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigTool {
    private final String brokerDir = "activemq";
    private final String webstartDir = "webstart";
    private static final String[] componentDirsWithConfig = new String[]{"comp", "auth", "fileserver", "manager", "webstart", "jobmanager", "toolbox"};
    private String[][] configs = new String[][]{{"broker public host/ip", "myhost.mydomain"}, {"broker private host/ip", "myhost.mydomain"}, {"message broker protocol", "ssl"}, {"message broker port", "61616"}, {"file broker protocol", "https"}, {"file broker port", "8080"}, {"Web Start www-server port", "8081"}, {"manager www-console port", "8082"}, {"admin e-mail address", "chipster-admin@mydomain"}, {"max. simultanous jobs (more recommended when compute service on separate node)", "3"}};
    private final int KEY_INDEX = 0;
    private final int VAL_INDEX = 1;
    private final int BROKER_PUBLIC_HOST_INDEX = 0;
    private final int BROKER_PRIVATE_HOST_INDEX = 1;
    private final int BROKER_PROTOCOL_INDEX = 2;
    private final int BROKER_PORT_INDEX = 3;
    private final int FILEBROKER_PORT_PROTOCOL = 4;
    private final int FILEBROKER_PORT_INDEX = 5;
    private final int WS_PORT = 6;
    private final int MANAGER_PORT = 7;
    private final int MANAGER_EMAIL = 8;
    private final int MAX_JOBS_INDEX = 9;
    private String[][] passwords = new String[][]{{"comp", ""}, {"auth", ""}, {"filebroker", ""}, {"manager", ""}, {"jobmanager", ""}, {"toolbox", ""}};
    private HashMap<String, Document> documentsToWrite = new HashMap();
    private HashMap<String, List<String>> filesToWrite = new HashMap();

    public static void main(String[] args) throws Exception {
        ConfigTool configTool = new ConfigTool();
        if (args.length == 0 || "configure".equals(args[0])) {
            System.out.println("Configuring Chipster...");
            configTool.configure();
        } else if ("auto-configure".equals(args[0]) || "auto".equals(args[0])) {
            System.out.println("Configuring Chipster...");
            configTool.simpleConfigure(null, null);
        } else if ("simple-configure".equals(args[0]) && args.length == 3) {
            System.out.println("Configuring Chipster...");
            configTool.simpleConfigure(args[1], args[2]);
        } else if ("simple-configure".equals(args[0]) && args.length == 2) {
            System.out.println("Configuring Chipster...");
            configTool.simpleConfigure(args[1], null);
        } else if ("genpasswd".equals(args[0])) {
            System.out.println("Generating Chipster server password...");
            configTool.genpasswd();
        } else if ("edit".equals(args[0]) && args.length >= 4) {
            String[] components = "servers".equals(args[1]) ? componentDirsWithConfig : new String[]{args[1]};
            if (!"print".equals(args[2])) {
                System.out.println("Configuring Chipster...");
            }
            configTool.editConfig(components, args[2], args[3], args.length > 4 ? args[4] : null);
        } else if ("help".equals(args[0]) || "--help".equals(args[0]) || "-h".equals(args[0])) {
            ConfigTool.printHelp();
        } else {
            ConfigTool.commandNotUnderstood();
        }
    }

    private static void commandNotUnderstood() {
        System.out.println("Incorrect parameter syntax. Use \"help\" for more information");
    }

    private static void printHelp() {
        System.out.println("Use:\n\n  configure.sh [configure]\n    Start interactive configuration utility\n\n  configure.sh [auto-configure | auto]\n    Detect IP automatically and configure everything else with default values\n\n  configure.sh simple-configure public-ip [private-ip]\n    Use given IP address (and separate private IP, when given) and configure \n    everything else with default values\n\n  configure.sh genpasswd\n    Generate strong random passwords for connections between server components \n    and message broker (AMQ).\n\n  configure.sh edit [<component name> | all] set entry-name entry-value\n    The \"edit\" command makes small changes to chipster-config.xml files and it\n    is mostly provided as an interface to use from automatic configuration\n    management and installation tools.\n    Set the value of entry with given name to given value. If the entry does not \n    exist, it is created. Entry name follows pattern CATEGORY_NAME/ENTRY_NAME,\n    such as comp/max-jobs. Component name is one of the available components, \n    \"servers\" to change all server components or \"client\"\n\n  configure.sh edit [<component name> | all] remove entry-name\n    Remove entry with given name completely. If the entry has default value, the\n    system will proceed to use it. If the entry does not exist nothing is done.\n\n  configure.sh edit [<component name> | all] print entry-name\n    Print the value of entry with given name to STDOUT. If the entry does not\n    exist nothing is printed.\n\n  configure.sh [help | --help | -h]\n    Print this help text.\n");
    }

    private void genpasswd() throws Exception {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            for (int i = 0; i < this.passwords.length; ++i) {
                this.passwords[i][1] = UUID.randomUUID().toString();
            }
            for (String componentDir : ConfigTool.getComponentDirsWithConfig()) {
                if (!new File(componentDir).exists()) continue;
                File configFile = new File(componentDir + File.separator + "conf" + File.separator + "chipster-config.xml");
                this.updateChipsterConfigFilePasswords(configFile);
            }
            File activemqConfigFile = new File("activemq" + File.separator + "conf" + File.separator + "activemq.xml");
            if (activemqConfigFile.exists()) {
                this.updateActivemqConfigFilePasswords(activemqConfigFile);
            }
            ConfigTool.verifyChanges(in);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println("\nQuitting, no changes written to disk!");
            return;
        }
        this.writeChangesToDisk();
    }

    private void writeChangesToDisk() throws TransformerException, IOException {
        for (String file : this.documentsToWrite.keySet()) {
            System.out.println("Writing changes to: " + file);
            XmlUtil.printXml(this.documentsToWrite.get(file), new OutputStreamWriter(new FileOutputStream(file)));
        }
        for (String file : this.filesToWrite.keySet()) {
            System.out.println("Writing changes to: " + file);
            Files.write(Paths.get(new File(file).toURI()), (Iterable<? extends CharSequence>)this.filesToWrite.get(file), Charset.defaultCharset(), new OpenOption[0]);
        }
        System.out.println("\nAll changes successfully written!");
    }

    public static void verifyChanges(BufferedReader in) throws Exception {
        ConfigTool.verifyChanges(in, "Please verify changes. Should changes be written to disk");
    }

    public static void verifyChanges(BufferedReader in, String question) throws Exception {
        System.out.println(question + " [yes/no]?");
        String answer = in.readLine();
        while (!"yes".equals(answer)) {
            if ("no".equals(answer)) {
                throw new Exception("User decided to abort");
            }
            System.out.println(question + " [yes/no]?");
            answer = in.readLine();
        }
    }

    public void configure() throws Exception {
        try {
            System.out.println("No changes are written before you verify them.");
            System.out.println("");
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            try {
                String host;
                this.configs[0][1] = host = ConfigTool.getInetAddress().getHostName();
                this.configs[1][1] = host;
            }
            catch (UnknownHostException host) {
                // empty catch block
            }
            for (int i = 0; i < this.configs.length; ++i) {
                System.out.println("Please specify " + this.configs[i][0] + " [" + this.configs[i][1] + "]: ");
                String line = in.readLine();
                if (line.trim().equals("")) continue;
                this.configs[i][1] = line;
            }
            this.updateConfigs();
            ConfigTool.verifyChanges(in);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println("\nQuitting, no changes written to disk!");
            return;
        }
        this.writeChangesToDisk();
    }

    public void simpleConfigure(String publicHost, String privateHost) throws Exception {
        if (publicHost == null) {
            publicHost = ConfigTool.getInetAddress().getHostName();
        }
        if (privateHost == null) {
            privateHost = publicHost;
        }
        try {
            this.configs[0][1] = publicHost;
            this.configs[1][1] = privateHost;
            this.updateConfigs();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println("\nQuitting, no changes written to disk!");
            return;
        }
        this.writeChangesToDisk();
    }

    private void editConfig(String[] components, String command, String entryName, String entryValue) throws Exception {
        try {
            for (String component : components) {
                File configFile = null;
                configFile = "client".equals(component) ? this.getClientConfigFile() : new File(component + File.separator + "conf" + File.separator + "chipster-config.xml");
                Document doc = this.openXmlForUpdating("Chipster", configFile, true);
                String[] nameParts = entryName.split("/");
                if (nameParts.length != 2) {
                    throw new IllegalArgumentException("illegal entry name: " + entryName);
                }
                String category = nameParts[0];
                String name = nameParts[1];
                Element module = XmlUtil.getChildWithAttributeValue(doc.getDocumentElement(), "moduleId", category);
                if (module == null) {
                    throw new IllegalArgumentException("illegal category name: " + category);
                }
                if ("set".equals(command)) {
                    this.setConfigEntryValue(doc, module, name, entryValue);
                    this.writeLater(configFile, doc);
                    continue;
                }
                if ("remove".equals(command)) {
                    this.removeConfigEntry(module, name);
                    this.writeLater(configFile, doc);
                    continue;
                }
                if ("print".equals(command)) {
                    this.printConfigEntryValue(module, name, entryValue);
                    continue;
                }
                throw new IllegalArgumentException("unknown command: " + command);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println("\nQuitting, no changes written to disk!");
            return;
        }
        if (!"print".equals(command)) {
            this.writeChangesToDisk();
        }
    }

    private void updateConfigs() throws Exception {
        File cliConfigFile;
        File wsConfigFile;
        File activemqConfigFile;
        for (String componentDir : ConfigTool.getComponentDirsWithConfig()) {
            if (!new File(componentDir).exists()) continue;
            File configFile = new File(componentDir + File.separator + "conf" + File.separator + "chipster-config.xml");
            this.updateChipsterConfigFile(configFile, true);
        }
        File wsClientConfigFile = this.getClientConfigFile();
        if (wsClientConfigFile.exists()) {
            this.updateChipsterConfigFile(wsClientConfigFile, false);
        }
        if ((activemqConfigFile = new File("activemq" + File.separator + "conf" + File.separator + "activemq.xml")).exists()) {
            this.updateActivemqConfigFile(activemqConfigFile);
        }
        if ((wsConfigFile = new File("webstart" + File.separator + "web-root" + File.separator + "chipster.jnlp")).exists()) {
            this.updateWsConfigFile(wsConfigFile);
        }
        if ((cliConfigFile = new File("webstart" + File.separator + "web-root" + File.separator + "chipster-cli.bash")).exists()) {
            this.updateCliClientConfigFile(cliConfigFile);
        }
    }

    private File getClientConfigFile() {
        return new File("webstart" + File.separator + "web-root" + File.separator + "chipster-config.xml");
    }

    private void updateActivemqConfigFile(File configFile) throws Exception {
        Document doc = this.openXmlForUpdating("ActiveMQ", configFile, false);
        Element broker = (Element)doc.getDocumentElement().getElementsByTagName("broker").item(0);
        Element transportConnectors = (Element)broker.getElementsByTagName("transportConnectors").item(0);
        Element transportConnector = (Element)transportConnectors.getElementsByTagName("transportConnector").item(0);
        URI uri = new URI(transportConnector.getAttribute("uri"));
        uri.setScheme(this.configs[2][1]);
        uri.setHost(this.configs[1][1]);
        uri.setPort(Integer.parseInt(this.configs[3][1]));
        this.updateElementAttribute(transportConnector, "uri", uri.toString());
        this.writeLater(configFile, doc);
    }

    private void updateWsConfigFile(File configFile) throws Exception {
        Document doc = this.openXmlForUpdating("Web Start", configFile, false);
        Element jnlp = doc.getDocumentElement();
        this.updateElementAttribute(jnlp, "codebase", this.getWebstartUrl());
        Element applicationDesc = (Element)jnlp.getElementsByTagName("application-desc").item(0);
        NodeList arguments = applicationDesc.getElementsByTagName("argument");
        Element lastArgument = (Element)arguments.item(arguments.getLength() - 1);
        String url = "http://" + this.configs[0][1] + ":" + this.configs[6][1] + "/" + "chipster-config.xml";
        this.updateElementValue(lastArgument, "configuration URL (for Web Start)", url);
        this.writeLater(configFile, doc);
    }

    private void updateCliClientConfigFile(File configFile) throws Exception {
        List<String> conf = this.openFileForUpdating("Chipster CLI client", configFile, false);
        String hostUrl = "http://" + this.configs[0][1] + ":" + this.configs[6][1];
        this.updateStringLine(conf, "host=", "host", "host=\"" + hostUrl + "\"");
        this.updateStringLine(conf, "conf=", "config", "conf=\"chipster-config.xml\"");
        this.writeLater(configFile, conf);
    }

    private void updateActivemqConfigFilePasswords(File configFile) throws Exception {
        Document doc = this.openXmlForUpdating("ActiveMQ", configFile, false);
        Element broker = (Element)doc.getDocumentElement().getElementsByTagName("broker").item(0);
        NodeList users = ((Element)((Element)((Element)broker.getElementsByTagName("plugins").item(0)).getElementsByTagName("simpleAuthenticationPlugin").item(0)).getElementsByTagName("users").item(0)).getElementsByTagName("authenticationUser");
        block0: for (int i = 0; i < users.getLength(); ++i) {
            for (int p = 0; p < this.passwords.length; ++p) {
                Element user = (Element)users.item(i);
                if (!user.getAttribute("username").equals(this.passwords[p][0])) continue;
                this.updateElementAttribute(user, "password for " + this.passwords[p][0], "password", this.passwords[p][1]);
                continue block0;
            }
        }
        this.writeLater(configFile, doc);
    }

    private void updateChipsterConfigFilePasswords(File configFile) throws Exception {
        Document doc = this.openXmlForUpdating("Chipster", configFile, false);
        Element securityModule = XmlUtil.getChildWithAttributeValue(doc.getDocumentElement(), "moduleId", "security");
        Element usernameElement = XmlUtil.getChildWithAttributeValue(securityModule, "entryKey", "username");
        String username = ((Element)usernameElement.getElementsByTagName("value").item(0)).getTextContent();
        for (int i = 0; i < this.passwords.length; ++i) {
            if (!username.equals(this.passwords[i][0])) continue;
            this.updateConfigEntryValue(securityModule, "password", this.passwords[i][1]);
            break;
        }
        this.writeLater(configFile, doc);
    }

    private void updateChipsterConfigFile(File configFile, boolean isPrivateNetwork) throws Exception {
        Element managerModule;
        Element clientModule;
        Element webstartModule;
        Element compModule;
        Document doc = this.openXmlForUpdating("Chipster", configFile, false);
        Element messagingModule = XmlUtil.getChildWithAttributeValue(doc.getDocumentElement(), "moduleId", "messaging");
        if (isPrivateNetwork) {
            this.updateConfigEntryValue(messagingModule, "broker-host", this.configs[1][1]);
        } else {
            this.updateConfigEntryValue(messagingModule, "broker-host", this.configs[0][1]);
        }
        this.updateConfigEntryValue(messagingModule, "broker-protocol", this.configs[2][1]);
        this.updateConfigEntryValue(messagingModule, "broker-port", this.configs[3][1]);
        Element filebrokerModule = XmlUtil.getChildWithAttributeValue(doc.getDocumentElement(), "moduleId", "filebroker");
        if (filebrokerModule != null) {
            this.updateConfigEntryValue(filebrokerModule, "port", this.configs[5][1]);
            this.updateConfigEntryValue(filebrokerModule, "url", this.createFilebrokerUrl());
        }
        if ((compModule = XmlUtil.getChildWithAttributeValue(doc.getDocumentElement(), "moduleId", "comp")) != null) {
            this.updateConfigEntryValue(compModule, "max-jobs", this.configs[9][1]);
        }
        if ((webstartModule = XmlUtil.getChildWithAttributeValue(doc.getDocumentElement(), "moduleId", "webstart")) != null) {
            this.updateConfigEntryValue(webstartModule, "port", this.configs[6][1]);
        }
        if ((clientModule = XmlUtil.getChildWithAttributeValue(doc.getDocumentElement(), "moduleId", "client")) != null) {
            this.updateConfigEntryValue(clientModule, "manual-root", this.getWebstartUrl() + "/manual/");
        }
        if ((managerModule = XmlUtil.getChildWithAttributeValue(doc.getDocumentElement(), "moduleId", "manager")) != null) {
            this.updateConfigEntryValue(managerModule, "web-console-port", this.configs[7][1]);
            this.updateConfigEntryValue(managerModule, "admin-email", this.configs[8][1]);
        }
        this.writeLater(configFile, doc);
    }

    private String createFilebrokerUrl() {
        return this.configs[4][1] + "://" + this.configs[0][1];
    }

    private void updateConfigEntryValue(Element module, String name, String newValue) {
        Element entry = XmlUtil.getChildWithAttributeValue(module, "entryKey", name);
        Element value = (Element)entry.getElementsByTagName("value").item(0);
        this.updateElementValue(value, name, newValue);
    }

    private void setConfigEntryValue(Document doc, Element module, String name, String newValue) {
        Element entry = XmlUtil.getChildWithAttributeValue(module, "entryKey", name);
        if (entry == null) {
            entry = doc.createElement("entry");
            module.appendChild(entry);
            entry.setAttribute("entryKey", name);
            Element newValueElement = doc.createElement("value");
            entry.appendChild(newValueElement);
        }
        Element value = (Element)entry.getElementsByTagName("value").item(0);
        this.updateElementValue(value, name, newValue);
    }

    private void removeConfigEntry(Element module, String name) {
        Element entry = XmlUtil.getChildWithAttributeValue(module, "entryKey", name);
        System.out.println("  removing " + name);
        module.removeChild(entry);
    }

    private void printConfigEntryValue(Element module, String name, String newValue) {
        Element entry = XmlUtil.getChildWithAttributeValue(module, "entryKey", name);
        Element value = (Element)entry.getElementsByTagName("value").item(0);
        System.out.println(value.getTextContent());
    }

    private void updateElementValue(Element element, String logicalName, String newValue) {
        System.out.println("  changing " + logicalName + ": " + element.getTextContent() + " -> " + newValue);
        element.setTextContent(newValue);
    }

    private void updateElementAttribute(Element element, String attrName, String attrValue) {
        this.updateElementAttribute(element, attrName, attrName, attrValue);
    }

    private void updateElementAttribute(Element element, String logicalName, String attrName, String attrValue) {
        System.out.println("  changing " + logicalName + ": " + element.getAttribute(attrName) + " -> " + attrValue);
        element.setAttribute(attrName, attrValue);
    }

    private void updateStringLine(List<String> lines, String startsWith, String logicalName, String newValue) {
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (!line.startsWith(startsWith)) continue;
            System.out.println("  changing " + logicalName + ": " + line + " -> " + newValue);
            lines.set(i, newValue);
            break;
        }
    }

    private void writeLater(File configFile, Document doc) throws TransformerException, UnsupportedEncodingException, FileNotFoundException {
        this.documentsToWrite.put(configFile.getAbsolutePath(), doc);
        System.out.println("");
    }

    private void writeLater(File configFile, List<String> conf) {
        this.filesToWrite.put(configFile.getAbsolutePath(), conf);
        System.out.println("");
    }

    private Document openXmlForUpdating(String name, File configFile, boolean silent) throws SAXException, IOException, ParserConfigurationException {
        if (!silent) {
            System.out.println("Updating " + name + " config in " + configFile.getAbsolutePath());
        }
        Document doc = XmlUtil.parseFile(configFile);
        return doc;
    }

    private List<String> openFileForUpdating(String name, File configFile, boolean silent) throws IOException {
        if (!silent) {
            System.out.println("Updating " + name + " config in " + configFile.getAbsolutePath());
        }
        List<String> lines = Files.readAllLines(Paths.get(configFile.toURI()), Charset.defaultCharset());
        return lines;
    }

    private String getWebstartUrl() {
        return "http://" + this.configs[0][1] + ":" + this.configs[6][1];
    }

    public static String[] getComponentDirsWithConfig() {
        return componentDirsWithConfig;
    }

    public static InetAddress getInetAddress() throws SocketException, UnknownHostException {
        NetworkInterface eth0 = NetworkInterface.getByName("eth0");
        if (eth0 != null) {
            Enumeration<InetAddress> addresses = eth0.getInetAddresses();
            for (InetAddress address : Collections.list(addresses)) {
                if (!(address instanceof Inet4Address)) continue;
                return address;
            }
        }
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        for (NetworkInterface iface : Collections.list(interfaces)) {
            Enumeration<InetAddress> addresses = iface.getInetAddresses();
            for (InetAddress address : Collections.list(addresses)) {
                if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                return address;
            }
        }
        return InetAddress.getLocalHost();
    }
}

