/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.biobeans;

import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.LinkUtils;
import fi.csc.microarray.databeans.features.table.EditableTable;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.module.ModuleManager;
import java.io.IOException;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PhenodataTest {
    private DataManager manager;

    @Before
    public void init() throws Exception {
        this.manager = new DataManager();
        new ModuleManager("fi.csc.microarray.module.chipster.MicroarrayModule").plugAll(this.manager, null);
    }

    @Test
    public void testPhenodataRetrieval() throws MicroarrayException, IOException {
        DataBean normalised = this.manager.createLocalTempDataBean("normalised.tsv");
        DataBean filtered = this.manager.createLocalTempDataBean("filtered.tsv");
        DataBean filtered2 = this.manager.createLocalTempDataBean("filtered2.tsv");
        DataBean phenodata = this.manager.createLocalTempDataBean("phenodata.tsv");
        filtered.addLink(DataBean.Link.DERIVATION, normalised);
        filtered2.addLink(DataBean.Link.DERIVATION, normalised);
        phenodata.addLink(DataBean.Link.ANNOTATION, normalised);
        Assert.assertEquals((Object)phenodata, (Object)LinkUtils.retrieveInherited(normalised, DataBean.Link.ANNOTATION));
        Assert.assertEquals((Object)phenodata, (Object)LinkUtils.retrieveInherited(filtered, DataBean.Link.ANNOTATION));
        Assert.assertEquals((long)2L, (long)LinkUtils.retrieveOutputSet(filtered).length);
    }

    @Test
    public void testPhenodataGeneration() throws MicroarrayException, IOException {
        DataBean normalised1 = this.manager.createLocalTempDataBean("normalised.tsv");
        DataBean phenodata1 = this.manager.createLocalTempDataBean("phenodata.tsv");
        DataBean filtered = this.manager.createLocalTempDataBean("filtered.tsv");
        filtered.addLink(DataBean.Link.DERIVATION, normalised1);
        phenodata1.addLink(DataBean.Link.ANNOTATION, normalised1);
        DataBean normalised2 = this.manager.createLocalTempDataBean("normalised.tsv");
        DataBean phenodata2 = this.manager.createLocalTempDataBean("phenodata.tsv");
        phenodata2.addLink(DataBean.Link.ANNOTATION, normalised2);
        ArrayList<String> samples = new ArrayList<String>();
        ArrayList<String> originals = new ArrayList<String>();
        ArrayList<String> group = new ArrayList<String>();
        ArrayList<String> training = new ArrayList<String>();
        ArrayList<String> chiptypes = new ArrayList<String>();
        samples.add("microarray1.cel");
        originals.add("affy_example1.cel");
        group.add("1");
        training.add("0");
        chiptypes.add("test3");
        samples.add("microarray2.cel");
        originals.add("affy_example2.cel");
        group.add("2");
        training.add("0");
        chiptypes.add("test3");
        EditableTable matrix = new EditableTable();
        matrix.addColumn("sample", samples);
        matrix.addColumn("original_name", originals);
        matrix.addColumn("group", group);
        matrix.addColumn("training", training);
        matrix.addColumn("chiptype", chiptypes);
    }
}

