/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.ApplicationConstants;
import fi.csc.microarray.filebroker.AuthorisedUrlRepository;
import fi.csc.microarray.filebroker.ChecksumException;
import fi.csc.microarray.filebroker.ChecksumParseException;
import fi.csc.microarray.filebroker.ContentLengthException;
import fi.csc.microarray.filebroker.DbFile;
import fi.csc.microarray.filebroker.DbSession;
import fi.csc.microarray.filebroker.DerbyMetadataServer;
import fi.csc.microarray.filebroker.DiskCleanUp;
import fi.csc.microarray.filebroker.ExampleSessionUpdater;
import fi.csc.microarray.filebroker.FileBrokerAreas;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.filebroker.FileServerAdminTools;
import fi.csc.microarray.filebroker.JettyFileServer;
import fi.csc.microarray.filebroker.Md5FileUtils;
import fi.csc.microarray.manager.ManagerClient;
import fi.csc.microarray.messaging.DirectMessagingListener;
import fi.csc.microarray.messaging.JMSMessagingEndpoint;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.NodeBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.message.BooleanMessage;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.ParameterMessage;
import fi.csc.microarray.messaging.message.SuccessMessage;
import fi.csc.microarray.messaging.message.UrlListMessage;
import fi.csc.microarray.messaging.message.UrlMessage;
import fi.csc.microarray.service.KeepAliveShutdownHandler;
import fi.csc.microarray.service.ShutdownCallback;
import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.Strings;
import fi.csc.microarray.util.SystemMonitorUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.ZipException;
import javax.jms.JMSException;
import org.apache.activemq.DestinationDoesNotExistException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.h2.tools.Server;

public class FileServer
extends NodeBase
implements MessagingListener,
DirectMessagingListener,
ShutdownCallback {
    private static Logger logger;
    public static final String ERROR_QUOTA_EXCEEDED = "quota-exceeded";
    public static final String CACHE_PATH = "cache";
    public static final String STORAGE_PATH = "storage";
    private MessagingEndpoint jmsEndpoint;
    private ManagerClient managerClient;
    private AuthorisedUrlRepository urlRepository;
    private FileBrokerAreas filebrokerAreas;
    private DerbyMetadataServer metadataServer;
    private File cacheRoot;
    private File storageRoot;
    private File publicRoot;
    private String publicPath;
    private String host;
    private int port;
    private DiskCleanUp cacheCleanUp;
    private ExecutorService longRunningTaskExecutor = Executors.newCachedThreadPool();
    private int metadataPort;
    private ExampleSessionUpdater exampleSessionUpdater;
    private long defaultUserQuota;
    private long quotaWarning;

    public static void main(String[] args) {
        new FileServer(null, null);
    }

    public FileServer(String configURL, MessagingEndpoint overriddenEndpoint) {
        this(configURL, overriddenEndpoint, null);
    }

    public FileServer(String configURL, MessagingEndpoint overriddenEndpoint, JettyFileServer externalFileServer) {
        try {
            DirectoryLayout.initialiseServerLayout(Arrays.asList("frontend", "filebroker"), configURL);
            Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
            logger = Logger.getLogger(FileServer.class);
            File fileRepository = DirectoryLayout.getInstance().getFileRoot();
            String exampleSessionPath = configuration.getString("filebroker", "example-session-path");
            this.publicPath = configuration.getString("filebroker", "public-path");
            this.host = configuration.getString("filebroker", "url");
            this.port = configuration.getInt("filebroker", "port");
            this.defaultUserQuota = configuration.getInt("filebroker", "default-user-quota");
            this.quotaWarning = configuration.getInt("filebroker", "quota-warning");
            this.filebrokerAreas = new FileBrokerAreas(fileRepository, CACHE_PATH, STORAGE_PATH);
            this.urlRepository = new AuthorisedUrlRepository(this.host, this.port, CACHE_PATH, STORAGE_PATH);
            logger.info((Object)"starting derby metadata server");
            this.metadataPort = configuration.getInt("filebroker", "metadata-port");
            this.metadataServer = new DerbyMetadataServer();
            if (this.metadataPort > 0) {
                Server h2WebConsoleServer = Server.createWebServer((String[])new String[]{"-webAllowOthers", "-webPort", String.valueOf(this.metadataPort)});
                h2WebConsoleServer.start();
                logger.info((Object)("started metadata server web interface: " + h2WebConsoleServer.getStatus()));
            } else {
                logger.info((Object)"not starting metadata server web interface");
            }
            this.cacheRoot = new File(fileRepository, CACHE_PATH);
            this.storageRoot = new File(fileRepository, STORAGE_PATH);
            this.publicRoot = new File(fileRepository, this.publicPath);
            int cleanUpTriggerLimitPercentage = configuration.getInt("filebroker", "clean-up-trigger-limit-percentage");
            int cleanUpTargetPercentage = configuration.getInt("filebroker", "clean-up-target-percentage");
            int cleanUpMinimumFileAge = configuration.getInt("filebroker", "clean-up-minimum-file-age");
            long minimumSpaceForAcceptUpload = 0x100000L * (long)configuration.getInt("filebroker", "minimum-space-for-accept-upload");
            this.cacheCleanUp = new DiskCleanUp(this.cacheRoot, cleanUpTriggerLimitPercentage, cleanUpTargetPercentage, cleanUpMinimumFileAge, minimumSpaceForAcceptUpload);
            URL hostURL = new URL(this.host);
            JettyFileServer jettyFileServer = externalFileServer != null ? externalFileServer : new JettyFileServer(this.urlRepository, this.metadataServer, this.cacheCleanUp);
            jettyFileServer.start(fileRepository.getPath(), this.port, hostURL.getProtocol());
            this.jmsEndpoint = overriddenEndpoint != null ? overriddenEndpoint : new JMSMessagingEndpoint(this);
            this.managerClient = new ManagerClient(this.jmsEndpoint);
            this.addEndpoint(this.jmsEndpoint);
            MessagingTopic filebrokerAdminTopic = this.jmsEndpoint.createTopic(Topics.Name.FILEBROKER_ADMIN_TOPIC, MessagingTopic.AccessMode.READ);
            filebrokerAdminTopic.setListener(new FilebrokerAdminMessageListener());
            if (exampleSessionPath != null && !exampleSessionPath.isEmpty()) {
                File exampleSessionDir = new File(fileRepository, exampleSessionPath);
                logger.info((Object)("importing example sessions from " + exampleSessionDir.getAbsolutePath()));
                this.exampleSessionUpdater = new ExampleSessionUpdater(this, this.metadataServer, exampleSessionDir);
                try {
                    this.exampleSessionUpdater.importExampleSessions();
                }
                catch (ZipException e) {
                    logger.error((Object)"example session import failed", (Throwable)e);
                    throw e;
                }
            } else {
                logger.info((Object)"the example sessions path is not configured, nothing to import");
            }
            KeepAliveShutdownHandler.init(this);
            logger.info((Object)("minimum required space after upload: " + FileUtils.byteCountToDisplaySize((long)minimumSpaceForAcceptUpload)));
            logger.info((Object)("fileserver is up and running [" + ApplicationConstants.VERSION + "]"));
            logger.info((Object)("[mem: " + SystemMonitorUtil.getMemInfo() + "]"));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e, (Throwable)e);
        }
    }

    protected void addEndpoint(MessagingEndpoint endpoint) throws JMSException {
        MessagingTopic filebrokerTopic = endpoint.createTopic(Topics.Name.AUTHORISED_FILEBROKER_TOPIC, MessagingTopic.AccessMode.READ);
        filebrokerTopic.setListener(this);
    }

    @Override
    public String getName() {
        return "filebroker";
    }

    @Override
    public void onChipsterMessage(ChipsterMessage msg) {
        this.onChipsterMessage(msg, this.jmsEndpoint);
    }

    @Override
    public void onChipsterMessage(ChipsterMessage msg, MessagingEndpoint endpoint) {
        try {
            if (msg instanceof CommandMessage) {
                CommandMessage cmdMsg = (CommandMessage)msg;
                logger.debug((Object)("received messaged " + cmdMsg.getCommand() + " from " + cmdMsg.getUsername() + ", checking that it's not " + DirectoryLayout.getInstance().getConfiguration().getString("security", "guest-username")));
                if (!this.handleReadOnlyMessages(cmdMsg, endpoint)) {
                    if (cmdMsg.getUsername() != null && cmdMsg.getUsername().equals(DirectoryLayout.getInstance().getConfiguration().getString("security", "guest-username"))) {
                        logger.error((Object)("only read-only messages are allowed for guest users: " + cmdMsg.getCommand()));
                    } else if (!this.handleReadWriteMessages(cmdMsg, endpoint)) {
                        logger.error((Object)("message " + msg.getMessageID() + " not understood"));
                    }
                }
            } else {
                logger.error((Object)("message " + msg.getMessageID() + " is not a command message, but " + msg.getClass().getSimpleName()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private boolean handleReadWriteMessages(CommandMessage msg, MessagingEndpoint endpoint) throws Exception {
        switch (msg.getCommand()) {
            case "store-session": {
                this.handleStoreSessionRequest(endpoint, msg);
                return true;
            }
            case "remove-session": {
                this.handleRemoveSessionRequest(endpoint, msg);
                return true;
            }
            case "move-from-cache-to-storage": {
                this.handleMoveFromCacheToStorageRequest(endpoint, msg);
                return true;
            }
            case "disk-space-request": {
                this.handleSpaceRequest(endpoint, msg);
                return true;
            }
        }
        return false;
    }

    private boolean handleReadOnlyMessages(CommandMessage msg, MessagingEndpoint endpoint) throws Exception {
        switch (msg.getCommand()) {
            case "new-url-request": {
                this.handleNewURLRequest(endpoint, msg);
                return true;
            }
            case "get-url": {
                this.handleGetURL(endpoint, msg);
                return true;
            }
            case "is-available": {
                this.handleIsAvailable(endpoint, msg);
                return true;
            }
            case "public-url-request": {
                this.handlePublicUrlRequest(endpoint, msg);
                return true;
            }
            case "public-url-list-request": {
                this.handlePublicFilesRequest(endpoint, msg);
                return true;
            }
            case "list-sessions": {
                this.handleListSessionsRequest(endpoint, msg);
                return true;
            }
            case "get-sessions-for-user": {
                this.handleListStorageUsageOfSessionsRequest(endpoint, msg, msg.getUsername());
                return true;
            }
        }
        return false;
    }

    private void handleListStorageUsageOfSessionsRequest(MessagingEndpoint endpoint, CommandMessage msg, String username) throws SQLException, JMSException {
        CommandMessage requestMessage = msg;
        List<String>[] sessions = this.metadataServer.getStorageUsageOfSessions(username);
        Long storageUsage = this.metadataServer.getStorageusageOfUser(username);
        CommandMessage reply = new CommandMessage();
        reply.addNamedParameter("username-list", Strings.delimit(sessions[0], "\t"));
        reply.addNamedParameter("session-name-list", Strings.delimit(sessions[1], "\t"));
        reply.addNamedParameter("size-list", Strings.delimit(sessions[2], "\t"));
        reply.addNamedParameter("date-list", Strings.delimit(sessions[3], "\t"));
        reply.addNamedParameter("session-uuid-list", Strings.delimit(sessions[4], "\t"));
        long quota = this.defaultUserQuota > 0L ? this.defaultUserQuota * 1024L * 1024L : storageUsage + this.storageRoot.getUsableSpace();
        long quotaWarningBytes = (long)((double)(quota * this.quotaWarning) / 100.0);
        reply.addNamedParameter("quota", "" + quota);
        reply.addNamedParameter("quota-warning", "" + quotaWarningBytes);
        reply.addNamedParameter("file-size", "" + storageUsage);
        this.jmsEndpoint.replyToMessage(requestMessage, reply);
    }

    @Deprecated
    private void handlePublicUrlRequest(MessagingEndpoint endpoint, ChipsterMessage msg) throws MalformedURLException, JMSException {
        URL url = this.getPublicUrl();
        UrlMessage reply = new UrlMessage(url);
        endpoint.replyToMessage(msg, reply);
        this.managerClient.publicUrlRequest(msg.getUsername(), url);
    }

    private void handlePublicFilesRequest(MessagingEndpoint endpoint, ChipsterMessage msg) throws MalformedURLException, JMSException {
        UrlListMessage reply;
        List<URL> files = null;
        try {
            files = this.getPublicFiles();
            reply = new UrlListMessage(files);
        }
        catch (IOException e) {
            reply = null;
        }
        endpoint.replyToMessage(msg, reply);
        this.managerClient.publicFilesRequest(msg.getUsername(), files);
    }

    private void handleNewURLRequest(MessagingEndpoint endpoint, ChipsterMessage msg) throws Exception {
        CommandMessage requestMessage = (CommandMessage)msg;
        String fileId = requestMessage.getNamedParameter("file-id");
        boolean useCompression = requestMessage.getParameters().contains("use-compression");
        FileBrokerClient.FileBrokerArea area = FileBrokerClient.FileBrokerArea.valueOf(requestMessage.getNamedParameter("area"));
        String username = msg.getUsername();
        long space = Long.parseLong(requestMessage.getNamedParameter("disk-space"));
        logger.debug((Object)("New url request, dataId: " + fileId));
        ChipsterMessage reply = this.createNewURLReply(fileId, username, space, useCompression, area);
        endpoint.replyToMessage(msg, reply);
    }

    private ChipsterMessage createNewURLReply(String fileId, String username, long space, boolean useCompression, FileBrokerClient.FileBrokerArea area) throws Exception {
        ChipsterMessage reply;
        if (!AuthorisedUrlRepository.checkFilenameSyntax(fileId)) {
            reply = new CommandMessage("file-operation-denied");
        } else if (area == FileBrokerClient.FileBrokerArea.STORAGE && !this.checkQuota(username, space)) {
            reply = new SuccessMessage(false, ERROR_QUOTA_EXCEEDED);
        } else {
            URL url = this.urlRepository.createAuthorisedUrl(fileId, useCompression, area, space);
            reply = new UrlMessage(url);
            this.managerClient.urlRequest(username, url);
        }
        return reply;
    }

    private void handleGetURL(MessagingEndpoint endpoint, ChipsterMessage msg) throws MalformedURLException, JMSException {
        ChipsterMessage reply;
        CommandMessage requestMessage = (CommandMessage)msg;
        String fileId = requestMessage.getNamedParameter("file-id");
        URL url = null;
        if (!AuthorisedUrlRepository.checkFilenameSyntax(fileId)) {
            reply = new CommandMessage("file-operation-denied");
        } else if (this.filebrokerAreas.fileExists(fileId, FileBrokerClient.FileBrokerArea.CACHE)) {
            url = this.urlRepository.constructCacheURL(fileId, "");
        } else if (this.filebrokerAreas.fileExists(fileId, FileBrokerClient.FileBrokerArea.STORAGE)) {
            url = this.urlRepository.constructStorageURL(fileId, "");
        }
        reply = new UrlMessage(url);
        endpoint.replyToMessage(msg, reply);
    }

    private void handleIsAvailable(MessagingEndpoint endpoint, ChipsterMessage msg) throws JMSException, SQLException, IOException {
        ChipsterMessage reply;
        CommandMessage requestMessage = (CommandMessage)msg;
        String fileId = requestMessage.getNamedParameter("file-id");
        Long size = Long.parseLong(requestMessage.getNamedParameter("file-size"));
        String checksum = requestMessage.getNamedParameter("file-checksum");
        FileBrokerClient.FileBrokerArea area = FileBrokerClient.FileBrokerArea.valueOf(requestMessage.getNamedParameter("area"));
        if (!AuthorisedUrlRepository.checkFilenameSyntax(fileId)) {
            reply = new CommandMessage("file-operation-denied");
        } else {
            try {
                reply = this.isAvailable(fileId, size, checksum, area) ? new BooleanMessage(true) : new BooleanMessage(false);
            }
            catch (ChecksumException | ContentLengthException e) {
                logger.info((Object)("corrupted data or data id collision (" + fileId + ", " + size + ", " + checksum + ")"), (Throwable)e);
                reply = new CommandMessage("file-operation-failed");
            }
            catch (ChecksumParseException e) {
                throw new IOException(e);
            }
            catch (IOException e) {
                throw e;
            }
        }
        endpoint.replyToMessage(msg, reply);
    }

    private boolean isAvailable(String fileId, Long size, String checksum, FileBrokerClient.FileBrokerArea area) throws SQLException, ChecksumParseException, IOException, ContentLengthException, ChecksumException {
        if (!this.filebrokerAreas.fileExists(fileId, area)) {
            return false;
        }
        Long sizeOnDisk = this.filebrokerAreas.getSize(fileId, area);
        Long sizeInDb = null;
        if (area == FileBrokerClient.FileBrokerArea.STORAGE) {
            DbFile dbFile = this.metadataServer.fetchFile(fileId);
            if (dbFile == null) {
                return false;
            }
            sizeInDb = dbFile.getSize();
        }
        Md5FileUtils.verify(size, sizeOnDisk, sizeInDb);
        String checksumOnDisk = this.filebrokerAreas.getChecksum(fileId, area);
        Md5FileUtils.verify(checksum, checksumOnDisk);
        return true;
    }

    private void handleSpaceRequest(final MessagingEndpoint endpoint, final CommandMessage requestMessage) throws JMSException {
        final long size = Long.parseLong(requestMessage.getNamedParameter("disk-space"));
        logger.debug((Object)("disk space request for " + size + " bytes"));
        logger.debug((Object)("usable space is: " + this.cacheRoot.getUsableSpace()));
        this.longRunningTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean spaceAvailable = FileServer.this.cacheCleanUp.spaceRequest(size, true, null);
                    BooleanMessage reply = new BooleanMessage(spaceAvailable);
                    endpoint.replyToMessage(requestMessage, reply);
                }
                catch (DestinationDoesNotExistException e) {
                    logger.error((Object)"could not reply to space request, because client gave up during the clean-up");
                }
                catch (JMSException e) {
                    logger.error((Object)"could not reply to space request", (Throwable)e);
                }
            }
        });
    }

    private void handleListSessionsRequest(MessagingEndpoint endpoint, CommandMessage requestMessage) throws JMSException, MalformedURLException {
        CommandMessage reply;
        String username = requestMessage.getUsername();
        try {
            List<DbSession> sessions = this.metadataServer.listSessions(username);
            reply = new CommandMessage();
            LinkedList<String> sessionIds = new LinkedList<String>();
            LinkedList<String> names = new LinkedList<String>();
            for (DbSession session : sessions) {
                names.add(session.getName());
                sessionIds.add(session.getDataId());
            }
            reply.addNamedParameter("session-name-list", Strings.delimit(names, "\t"));
            reply.addNamedParameter("session-uuid-list", Strings.delimit(sessionIds, "\t"));
        }
        catch (Exception e) {
            reply = new CommandMessage("file-operation-failed");
        }
        endpoint.replyToMessage(requestMessage, reply);
    }

    private void handleStoreSessionRequest(MessagingEndpoint endpoint, CommandMessage requestMessage) throws JMSException, MalformedURLException {
        CommandMessage reply;
        String username = requestMessage.getUsername();
        String name = requestMessage.getNamedParameter("session-name");
        String sessionId = AuthorisedUrlRepository.stripCompressionSuffix(requestMessage.getNamedParameter("session-uuid"));
        List<String> fileIds = Arrays.asList(requestMessage.getNamedParameterAsArray("file-id-list"));
        try {
            this.storeSession(username, name, sessionId, fileIds);
            reply = new CommandMessage("file-operation-successful");
        }
        catch (Exception e) {
            reply = new CommandMessage("file-operation-failed");
        }
        endpoint.replyToMessage(requestMessage, reply);
    }

    private void storeSession(String username, String name, String sessionId, List<String> fileIds) throws SQLException {
        String previousSessionUuid = this.metadataServer.fetchSession(username, name);
        if (previousSessionUuid != null) {
            this.metadataServer.renameSession("_" + name, previousSessionUuid);
        }
        this.metadataServer.addSession(username, name, sessionId);
        for (String fileId : fileIds) {
            if (!this.filebrokerAreas.fileExists(fileId, FileBrokerClient.FileBrokerArea.STORAGE)) continue;
            this.metadataServer.linkFileToSession(fileId, sessionId);
        }
        if (previousSessionUuid != null) {
            this.removeSession(previousSessionUuid);
        }
    }

    private void handleRemoveSessionRequest(MessagingEndpoint endpoint, CommandMessage requestMessage) throws JMSException {
        SuccessMessage reply;
        String sessionId = requestMessage.getNamedParameter("session-uuid");
        try {
            if (sessionId == null) {
                URL url = new URL(requestMessage.getNamedParameter("session-url"));
                sessionId = IOUtils.getFilenameWithoutPath(url);
            }
            if (this.metadataServer.isUsernameAllowedToRemoveSession(requestMessage.getUsername(), sessionId)) {
                this.removeSession(sessionId);
                reply = new SuccessMessage(true);
            } else {
                reply = new SuccessMessage(false, "user it not allowed to remove the session");
            }
        }
        catch (Exception e) {
            reply = new SuccessMessage(false, e);
        }
        endpoint.replyToMessage(requestMessage, reply);
    }

    protected void removeSession(String sessionId) throws SQLException {
        List<String> removedFiles = this.metadataServer.removeSession(sessionId);
        for (String removedFile : removedFiles) {
            File dataFile = new File(this.storageRoot, removedFile);
            dataFile.delete();
            Md5FileUtils.removeMd5(dataFile);
        }
    }

    private void handleMoveFromCacheToStorageRequest(final MessagingEndpoint endpoint, final CommandMessage requestMessage) throws JMSException, MalformedURLException {
        final String fileId = requestMessage.getNamedParameter("file-id");
        logger.debug((Object)("move request for: " + fileId));
        if (!AuthorisedUrlRepository.checkFilenameSyntax(fileId) || !this.filebrokerAreas.fileExists(fileId, FileBrokerClient.FileBrokerArea.CACHE)) {
            endpoint.replyToMessage(requestMessage, new SuccessMessage(false));
        } else {
            this.longRunningTaskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    SuccessMessage reply = null;
                    try {
                        if (!FileServer.this.checkQuota(requestMessage.getUsername(), FileServer.this.filebrokerAreas.getSize(fileId, FileBrokerClient.FileBrokerArea.CACHE))) {
                            reply = new SuccessMessage(false, FileServer.ERROR_QUOTA_EXCEEDED);
                        } else {
                            boolean moveSuccess = FileServer.this.filebrokerAreas.moveFromCacheToStorage(fileId);
                            long size = FileServer.this.filebrokerAreas.getSize(fileId, FileBrokerClient.FileBrokerArea.STORAGE);
                            FileServer.this.metadataServer.addFile(fileId, size);
                            if (moveSuccess) {
                                reply = new SuccessMessage(true);
                            } else {
                                reply = new SuccessMessage(false);
                                logger.warn((Object)("could not move from cache to storage: " + fileId));
                            }
                        }
                    }
                    catch (Exception e) {
                        reply = new SuccessMessage(false);
                    }
                    try {
                        endpoint.replyToMessage(requestMessage, reply);
                    }
                    catch (JMSException e) {
                        logger.error((Object)"could not send reply message", (Throwable)e);
                    }
                }
            });
        }
    }

    private boolean checkQuota(String username, long additionalBytes) throws SQLException {
        if (this.defaultUserQuota == -1L) {
            logger.debug((Object)"quota limit disabled");
            return true;
        }
        Long usage = this.metadataServer.getStorageusageOfUser(username);
        boolean isAllowed = usage + additionalBytes <= this.defaultUserQuota * 1024L * 1024L;
        logger.debug((Object)("quota check passed: " + isAllowed));
        return isAllowed;
    }

    @Override
    public void shutdown() {
        logger.info((Object)"shutdown requested");
        try {
            this.jmsEndpoint.close();
        }
        catch (JMSException e) {
            logger.error((Object)"closing messaging endpoint failed", (Throwable)e);
        }
        logger.info((Object)"shutting down");
    }

    @Deprecated
    public URL getPublicUrl() throws MalformedURLException {
        return new URL(this.host + ":" + this.port + "/" + this.publicPath);
    }

    public List<URL> getPublicFiles() throws IOException {
        LinkedList<URL> urlList = new LinkedList<URL>();
        this.addFilesRecursively(urlList, this.publicRoot);
        return urlList;
    }

    private void addFilesRecursively(List<URL> files, File path) throws IOException {
        for (File file : path.listFiles()) {
            if (file.isDirectory()) {
                this.addFilesRecursively(files, file);
                continue;
            }
            String localPath = file.toURI().toString();
            String publicRootString = this.publicRoot.toURI().toString();
            String urlString = localPath.replace(publicRootString, this.host + ":" + this.port + "/" + this.publicPath + "/");
            files.add(new URL(urlString));
        }
    }

    private class FilebrokerAdminMessageListener
    implements MessagingListener {
        private FilebrokerAdminMessageListener() {
        }

        @Override
        public void onChipsterMessage(ChipsterMessage msg) {
            try {
                if (msg instanceof CommandMessage && "get-storage-usage-by-user".equals(((CommandMessage)msg).getCommand())) {
                    CommandMessage requestMessage = (CommandMessage)msg;
                    List<String>[] users = FileServer.this.metadataServer.getStorageusageOfUsers();
                    CommandMessage reply = new CommandMessage();
                    reply.addNamedParameter("username-list", Strings.delimit(users[0], "\t"));
                    reply.addNamedParameter("size-list", Strings.delimit(users[1], "\t"));
                    FileServer.this.jmsEndpoint.replyToMessage(requestMessage, reply);
                } else if (msg instanceof CommandMessage && "get-sessions-for-user".equals(((CommandMessage)msg).getCommand())) {
                    String username = ((ParameterMessage)msg).getNamedParameter("username");
                    FileServer.this.handleListStorageUsageOfSessionsRequest(FileServer.this.jmsEndpoint, (CommandMessage)msg, username);
                } else if (msg instanceof CommandMessage && "get-sessions-for-session-name".equals(((CommandMessage)msg).getCommand())) {
                    CommandMessage requestMessage = (CommandMessage)msg;
                    LinkedList<String> totals = new LinkedList<String>();
                    totals.add(FileServer.this.metadataServer.getStorageUsageTotal());
                    totals.add("" + FileServer.this.storageRoot.getUsableSpace());
                    CommandMessage reply = new CommandMessage();
                    reply.addNamedParameter("size-list", Strings.delimit(totals, "\t"));
                    FileServer.this.jmsEndpoint.replyToMessage(requestMessage, reply);
                } else if (msg instanceof CommandMessage && "remove-session".equals(((CommandMessage)msg).getCommand())) {
                    FileServer.this.handleRemoveSessionRequest(FileServer.this.jmsEndpoint, (CommandMessage)msg);
                } else if (msg instanceof CommandMessage && "get-status-report".equals(((CommandMessage)msg).getCommand())) {
                    CommandMessage requestMessage = (CommandMessage)msg;
                    CommandMessage reply = new CommandMessage();
                    FileServerAdminTools admin = this.getAdminTools();
                    String sysStats = SystemMonitorUtil.getSystemStats(FileServer.this.cacheRoot).systemStatsToString();
                    String report = "";
                    report = report + "SYSTEM\n\n";
                    report = report + sysStats + "\n";
                    report = report + admin.getDataBaseStatusReport() + "\n";
                    reply.addNamedParameter("status-report", report);
                    FileServer.this.jmsEndpoint.replyToMessage(requestMessage, reply);
                } else if (msg instanceof CommandMessage && "log-status".equals(((CommandMessage)msg).getCommand())) {
                    FileServer.this.longRunningTaskExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                logger.info((Object)"status report requested from the admin-web");
                                FileServerAdminTools admin = FilebrokerAdminMessageListener.this.getAdminTools();
                                String sysStats = SystemMonitorUtil.getSystemStats(FileServer.this.cacheRoot).systemStatsToString();
                                String report = "";
                                report = report + "SYSTEM\n\n";
                                report = report + sysStats + "\n";
                                logger.info((Object)"calculating database status report");
                                report = report + admin.getDataBaseStatusReport() + "\n";
                                logger.info((Object)"calculating storage status report");
                                String storageReport = admin.getStorageStatusReport(false);
                                File reportFile = new File(DirectoryLayout.getInstance().getLogsDir(), "storage-status.txt");
                                logger.info((Object)("writing storage status report to " + reportFile.getAbsolutePath()));
                                try (PrintWriter out = new PrintWriter(reportFile);){
                                    out.println(storageReport);
                                }
                                logger.info((Object)("status report ready\n\n" + report));
                            }
                            catch (Exception e) {
                                logger.error((Object)"failed to log status report", (Throwable)e);
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                logger.error((Object)"error in file-broker message handling", (Throwable)e);
            }
        }

        private FileServerAdminTools getAdminTools() {
            return new FileServerAdminTools(FileServer.this.metadataServer, FileServer.this.cacheRoot, FileServer.this.storageRoot, false);
        }
    }
}

