/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging;

import fi.csc.microarray.messaging.AuthCancelledException;
import fi.csc.microarray.messaging.TempTopicMessagingListenerBase;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.SourceMessage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class SourceMessageListener
extends TempTopicMessagingListenerBase {
    private CountDownLatch latch = new CountDownLatch(1);
    private String source = null;
    private boolean cancelled = false;

    public String waitForResponse(long timeout, TimeUnit unit) throws AuthCancelledException {
        try {
            this.latch.await(timeout, unit);
            if (this.cancelled) {
                throw new AuthCancelledException();
            }
            return this.source;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onChipsterMessage(ChipsterMessage message) {
        if (this.latch.getCount() == 0L) {
            return;
        }
        SourceMessage sourceMessage = (SourceMessage)message;
        this.source = sourceMessage.getSource();
        this.latch.countDown();
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.latch.countDown();
    }
}

