/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging;

import fi.csc.microarray.messaging.AuthCancelledException;
import fi.csc.microarray.messaging.TempTopicMessagingListenerBase;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.UrlListMessage;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class UrlListMessageListener
extends TempTopicMessagingListenerBase {
    private static final Logger logger = Logger.getLogger(UrlListMessageListener.class);
    private List<URL> urlList = null;
    private CountDownLatch latch = new CountDownLatch(1);
    private boolean cancelled = false;

    @Override
    public void onChipsterMessage(ChipsterMessage msg) {
        if (msg instanceof UrlListMessage) {
            UrlListMessage urlListMessage = (UrlListMessage)msg;
            this.urlList = urlListMessage.getUrlList();
            this.latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URL> waitForReply(long timeout, TimeUnit unit) throws AuthCancelledException {
        try {
            this.latch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            logger.warn((Object)"interrupted while waiting for latch", (Throwable)e);
        }
        finally {
            this.cleanUp();
        }
        if (this.cancelled) {
            throw new AuthCancelledException();
        }
        return this.urlList;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.latch.countDown();
    }
}

