/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.module.chipster;

import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.description.SADLSyntax;
import fi.csc.microarray.exception.MicroarrayException;

public class ChipsterInputTypes {
    public static final SADLSyntax.InputType CDNA = new SADLSyntax.InputType("CDNA");
    public static final SADLSyntax.InputType AFFY = new SADLSyntax.InputType("AFFY");
    public static final SADLSyntax.InputType GENE_EXPRS = new SADLSyntax.InputType("GENE_EXPRS");
    public static final SADLSyntax.InputType GENELIST = new SADLSyntax.InputType("GENELIST");
    public static final SADLSyntax.InputType PHENODATA = new SADLSyntax.InputType("PHENODATA");
    public static final SADLSyntax.InputType BAM = new SADLSyntax.InputType("BAM");
    public static final SADLSyntax.InputType FASTA = new SADLSyntax.InputType("FASTA");
    public static final SADLSyntax.InputType GTF = new SADLSyntax.InputType("GTF");
    public static final SADLSyntax.InputType MOTHUR_OLIGOS = new SADLSyntax.InputType("MOTHUR_OLIGOS");
    public static final SADLSyntax.InputType MOTHUR_NAMES = new SADLSyntax.InputType("MOTHUR_NAMES");
    public static final SADLSyntax.InputType MOTHUR_GROUPS = new SADLSyntax.InputType("MOTHUR_GROUPS");
    public static final SADLSyntax.InputType MOTHUR_STABILITY = new SADLSyntax.InputType("MOTHUR_STABILITY");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isTypeOf(DataBean dataBean, SADLSyntax.InputType type) {
        if (CDNA.equals(type)) {
            return dataBean.queryFeatures("/column/sample").exists();
        }
        if (AFFY.equals(type)) {
            return dataBean.isContentTypeCompatitible("application/cel");
        }
        if (GENE_EXPRS.equals(type)) {
            try (Table chips = dataBean.queryFeatures("/column/chip.*").asTable();){
                boolean bl = chips != null && chips.getColumnCount() > 0;
                return bl;
            }
            catch (MicroarrayException e) {
                throw new RuntimeException(e);
            }
        }
        if (GENELIST.equals(type)) {
            return dataBean.queryFeatures("/identifier").exists();
        }
        if (PHENODATA.equals(type)) {
            return dataBean.queryFeatures("/phenodata").exists();
        }
        if (BAM.equals(type)) {
            return dataBean.isContentTypeCompatitible("application/bam");
        }
        if (FASTA.equals(type)) {
            return dataBean.isContentTypeCompatitible("chemical/x-fasta");
        }
        if (GTF.equals(type)) {
            return dataBean.isContentTypeCompatitible("text/gtf");
        }
        if (MOTHUR_OLIGOS.equals(type)) {
            return dataBean.isContentTypeCompatitible("text/mothur-oligos");
        }
        if (MOTHUR_NAMES.equals(type)) {
            return dataBean.isContentTypeCompatitible("text/mothur-names");
        }
        if (MOTHUR_GROUPS.equals(type)) {
            return dataBean.isContentTypeCompatitible("text/mothur-groups");
        }
        if (!MOTHUR_STABILITY.equals(type)) return false;
        return dataBean.isContentTypeCompatitible("text/mothur-stability");
    }

    public static boolean hasRawType(DataBean data) {
        return ChipsterInputTypes.isTypeOf(data, AFFY) || ChipsterInputTypes.isTypeOf(data, CDNA);
    }
}

