/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import fi.csc.microarray.filebroker.ChecksumException;
import fi.csc.microarray.filebroker.ChecksumInputStream;
import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.KeyAndTrustManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.jms.JMSException;

public class UrlTransferUtil {
    public static int HTTP_TIMEOUT_MILLISECONDS = 2000;
    private static final long POST_UPLOAD_TIMEOUT_MILLISECONDS = 500L;
    private static final int CHUNK_SIZE = 2048;

    public static InputStream downloadStream(URL url) throws JMSException, IOException {
        URLConnection connection = url.openConnection();
        KeyAndTrustManager.configureForChipsterCertificate(connection);
        return connection.getInputStream();
    }

    public static String parseFilename(URL url) {
        int start = url.getPath().contains("/") ? url.getPath().lastIndexOf("/") + 1 : url.getPath().length();
        return url.getPath().substring(start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadStream(URL url, InputStream fis, boolean useChunked, boolean compress, boolean useChecksums, IOUtils.CopyProgressListener progressListener) throws IOException, ChecksumException {
        HttpURLConnection connection = null;
        String checksum = null;
        try {
            connection = UrlTransferUtil.prepareForUpload(url);
            if (useChunked) {
                connection.setChunkedStreamingMode(2048);
            }
            ChecksumInputStream is = null;
            OutputStream os = null;
            try {
                is = new ChecksumInputStream(fis, useChecksums, connection);
                if (compress) {
                    Deflater deflater = new Deflater(1);
                    os = new DeflaterOutputStream(connection.getOutputStream(), deflater);
                } else {
                    os = connection.getOutputStream();
                }
                IOUtils.copy(is, os, progressListener);
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    throw e;
                }
                catch (Throwable throwable) {
                    IOUtils.closeIfPossible(is);
                    IOUtils.closeIfPossible(os);
                    throw throwable;
                }
            }
            IOUtils.closeIfPossible(is);
            IOUtils.closeIfPossible(os);
            if (!UrlTransferUtil.isSuccessfulCode(connection.getResponseCode())) {
                throw new IOException("PUT was not successful: " + connection.getResponseCode() + " " + connection.getResponseMessage());
            }
            checksum = is.verifyChecksums();
        }
        finally {
            IOUtils.disconnectIfPossible(connection);
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return checksum;
    }

    public static boolean isSuccessfulCode(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }

    public static void disableProxies() {
        ProxySelector.setDefault(new ProxySelector(){

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }

            @Override
            public List<Proxy> select(URI uri) {
                LinkedList<Proxy> proxies = new LinkedList<Proxy>();
                proxies.add(Proxy.NO_PROXY);
                return proxies;
            }
        });
    }

    public static HttpURLConnection prepareForUpload(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        KeyAndTrustManager.configureForChipsterCertificate(connection);
        connection.setRequestMethod("PUT");
        connection.setDoOutput(true);
        return connection;
    }

    public static boolean isAccessible(URL url, boolean isChipsterServer) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (isChipsterServer) {
            KeyAndTrustManager.configureForChipsterCertificate(connection);
        } else {
            KeyAndTrustManager.configureForCACertificates(connection);
        }
        connection.setConnectTimeout(HTTP_TIMEOUT_MILLISECONDS);
        connection.connect();
        return connection.getResponseCode() == 200;
    }

    public static Long getContentLength(URL url, boolean isChipsterServer) throws IOException {
        URLConnection connection = null;
        try {
            connection = url.openConnection();
            if (isChipsterServer) {
                KeyAndTrustManager.configureForChipsterCertificate(connection);
            } else {
                KeyAndTrustManager.configureForCACertificates(connection);
            }
            long contentLength = connection.getContentLengthLong();
            if (contentLength >= 0L) {
                Long l = contentLength;
                return l;
            }
            throw new IOException("content length not available: " + connection.getContent());
        }
        finally {
            IOUtils.disconnectIfPossible(connection);
        }
    }

    public static boolean isLocalhost(String host) throws SocketException, UnknownHostException {
        InetAddress address = InetAddress.getByName(host);
        return address.isAnyLocalAddress() || address.isLoopbackAddress();
    }
}

