/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.env.internal;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.SchemaNameResolver;
import org.jboss.logging.Logger;

public class DefaultSchemaNameResolver
implements SchemaNameResolver {
    private static final Logger log = Logger.getLogger(DefaultSchemaNameResolver.class);
    public static final DefaultSchemaNameResolver INSTANCE = new DefaultSchemaNameResolver();
    private final SchemaNameResolver delegate = DefaultSchemaNameResolver.determineAppropriateResolverDelegate();

    private static SchemaNameResolver determineAppropriateResolverDelegate() {
        Class<Connection> jdbcConnectionClass = Connection.class;
        try {
            Method getSchemaMethod = jdbcConnectionClass.getMethod("getSchema", new Class[0]);
            if (getSchemaMethod != null && getSchemaMethod.getReturnType().equals(String.class)) {
                return new SchemaNameResolverJava17Delegate(getSchemaMethod);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.debugf("Unable to use Java 1.7 Connection#getSchema", new Object[0]);
        return SchemaNameResolverFallbackDelegate.INSTANCE;
    }

    @Override
    public String resolveSchemaName(Connection connection, Dialect dialect) throws SQLException {
        return this.delegate.resolveSchemaName(connection, dialect);
    }

    public static class SchemaNameResolverFallbackDelegate
    implements SchemaNameResolver {
        public static final SchemaNameResolverFallbackDelegate INSTANCE = new SchemaNameResolverFallbackDelegate();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public String resolveSchemaName(Connection connection, Dialect dialect) throws SQLException {
            ResultSet resultSet;
            Statement statement;
            block21: {
                String command = dialect.getCurrentSchemaCommand();
                if (command == null) {
                    throw new HibernateException("Use of DefaultSchemaNameResolver requires Dialect to provide the proper SQL statement/command but provided Dialect [" + dialect.getClass().getName() + "] did not return anything from Dialect#getCurrentSchemaCommand");
                }
                statement = connection.createStatement();
                resultSet = statement.executeQuery(dialect.getCurrentSchemaCommand());
                if (resultSet.next()) break block21;
                String string = null;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return string;
            }
            String string = resultSet.getString(1);
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return string;
            {
                catch (Throwable throwable) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            finally {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static class SchemaNameResolverJava17Delegate
    implements SchemaNameResolver {
        private final Method getSchemaMethod;

        public SchemaNameResolverJava17Delegate(Method getSchemaMethod) {
            this.getSchemaMethod = getSchemaMethod;
        }

        @Override
        public String resolveSchemaName(Connection connection, Dialect dialect) throws SQLException {
            try {
                return (String)this.getSchemaMethod.invoke((Object)connection, new Object[0]);
            }
            catch (Exception e) {
                throw new HibernateException("Unable to invoke Connection#getSchema method via reflection", e);
            }
        }
    }
}

