/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.io.InputStream;
import java.net.URL;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.eclipse.jetty.xml.XmlConfiguration;

class XmlBasedHttpClientProvider {
    XmlBasedHttpClientProvider() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HttpClient get(WebSocketContainerScope scope) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource("jetty-websocket-httpclient.xml");
        if (resource == null) {
            return null;
        }
        try (InputStream in = resource.openStream();){
            XmlConfiguration configuration = new XmlConfiguration(in);
            HttpClient httpClient = (HttpClient)configuration.configure();
            return httpClient;
        }
        catch (Throwable t) {
            Log.getLogger(XmlBasedHttpClientProvider.class).warn("Unable to load: " + resource, t);
            return null;
        }
    }
}

