/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.module.Module;
import fi.csc.microarray.module.basic.BasicModule;
import fi.csc.microarray.module.chipster.KielipankkiModule;
import fi.csc.microarray.util.LinkUtil;
import fi.csc.microarray.util.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXHyperlink;

public class QuickLinkPanel
extends JPanel {
    private static Logger logger = Logger.getLogger(QuickLinkPanel.class);
    private SwingClientApplication application = (SwingClientApplication)Session.getSession().getApplication();
    private JXHyperlink sessionLink;
    private JXHyperlink localSessionLink;
    private JXHyperlink importLink;
    private JXHyperlink exampleLink;
    private JXHyperlink importFolderLink;
    private JXHyperlink importURLLink;
    private JXHyperlink importURLToServerLink;
    private static final int MAX_ROW_CHARS = 53;

    public QuickLinkPanel() {
        super(new GridBagLayout());
        LinkedList<JXHyperlink> openLinks;
        this.setBackground(Color.white);
        this.exampleLink = LinkUtil.createLink("Open example session", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickLinkPanel.this.application.loadSession(true, true, true);
            }
        });
        this.importLink = LinkUtil.createLink("Import files", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    QuickLinkPanel.this.application.openFileImport();
                }
                catch (Exception exception) {
                    QuickLinkPanel.this.application.reportException(exception);
                }
            }
        });
        this.importFolderLink = LinkUtil.createLink("Import folder", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickLinkPanel.this.application.openDirectoryImportDialog();
            }
        });
        this.importURLLink = LinkUtil.createLink("Import from URL to client", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    QuickLinkPanel.this.application.openURLImport();
                }
                catch (Exception exception) {
                    QuickLinkPanel.this.application.reportException(exception);
                }
            }
        });
        this.importURLToServerLink = LinkUtil.createLink("Import from URL directly to server", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicModule.importFromUrlToServer();
            }
        });
        this.sessionLink = LinkUtil.createLink("open cloud session", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickLinkPanel.this.application.loadSession(true);
            }
        });
        this.localSessionLink = LinkUtil.createLink("Open local session", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickLinkPanel.this.application.loadSession(false);
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.insets.set(5, 10, 5, 10);
        c.gridwidth = 2;
        this.add((Component)new JLabel("To start working with " + Session.getSession().getPrimaryModule().getDisplayName() + ", you need to load in data first."), c);
        c.gridwidth = 1;
        ++c.gridy;
        c.insets.set(0, 10, 0, 0);
        if (!(Session.getSession().getPrimaryModule() instanceof KielipankkiModule)) {
            QuickLinkPanel.addLink("*** to get familiar with " + Session.getSession().getPrimaryModule().getDisplayName(), this.exampleLink, "/try.png", c, this);
        }
        String cloudSessionsString = "*** to continue working on previous sessions. You can also *** from the server.";
        String localSessionsString = "*** to continue working on previous sessions.";
        if (this.application.getSessionManager().areCloudSessionsEnabled()) {
            openLinks = new LinkedList<JXHyperlink>();
            openLinks.add(this.localSessionLink);
            openLinks.add(this.sessionLink);
            QuickLinkPanel.addLinks(cloudSessionsString, openLinks, "/tree.png", c, this);
        } else {
            openLinks = new LinkedList();
            openLinks.add(this.localSessionLink);
            QuickLinkPanel.addLinks(localSessionsString, openLinks, "/tree.png", c, this);
        }
        LinkedList<JXHyperlink> importLinks = new LinkedList<JXHyperlink>();
        importLinks.add(this.importLink);
        importLinks.add(this.importFolderLink);
        importLinks.add(this.importURLLink);
        importLinks.add(this.importURLToServerLink);
        if (!this.application.isStandalone()) {
            Module primaryModule = Session.getSession().getPrimaryModule();
            primaryModule.addImportLinks(this, importLinks);
        }
        String linkTemplate = Strings.repeat("\n      *** ", importLinks.size());
        QuickLinkPanel.addLinks("Import new data to " + Session.getSession().getPrimaryModule().getDisplayName() + ": " + linkTemplate, importLinks, "/table.png", c, this);
        JPanel bottomPanel = new JPanel();
        JPanel rightPanel = new JPanel();
        bottomPanel.setBackground(Color.white);
        rightPanel.setBackground(Color.white);
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.fill = 3;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)bottomPanel, c);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.gridx = 3;
        c.gridy = 0;
        this.add((Component)rightPanel, c);
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(new Dimension(400, 270));
    }

    public static void addLink(String description, JXHyperlink link, String iconPath, GridBagConstraints c, JComponent component) {
        LinkUtil.addLink(description, link, VisualConstants.getIcon(iconPath), c, component, 53, Color.white);
    }

    public static void addLinks(String description, List<JXHyperlink> links, String iconPath, GridBagConstraints c, JComponent component) {
        LinkUtil.addLinks(description, links, VisualConstants.getIcon(iconPath), c, component, 53, Color.white);
    }
}

