/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.util.SystemMonitorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class StatusBar {
    private SwingClientApplication application;
    private JPanel statusPanel = null;
    private JLabel statusLabel = null;
    private JProgressBar jobStatusIndicator = null;
    private Color normalStatusIndicatorColor;
    private JProgressBar memoryIndicator;
    private JButton jobListButton;
    private int oldTaskCount = 0;
    private Timer blinker;

    public StatusBar(SwingClientApplication application) {
        this.application = application;
    }

    public JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.jobStatusIndicator = new JProgressBar();
            this.jobStatusIndicator.setName("jobStatusIndicator");
            this.jobStatusIndicator.setStringPainted(true);
            this.normalStatusIndicatorColor = this.jobStatusIndicator.getForeground();
            this.memoryIndicator = new JProgressBar(0, 100);
            this.memoryIndicator.setStringPainted(true);
            this.memoryIndicator.setToolTipText("Shows how much of the available memory is allocated. Click the indicator to release unused memory (garbage collection).");
            this.memoryIndicator.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    StatusBar.this.application.garbageCollect();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            });
            this.statusLabel = new JLabel();
            String labelText = "Connected to " + DirectoryLayout.getInstance().getConfiguration().getString("messaging", "broker-host");
            labelText = labelText + " as " + Session.getSession().getUsername();
            this.statusLabel.setText(labelText);
            this.statusLabel.setBorder(this.jobStatusIndicator.getBorder());
            this.jobListButton = new JButton("View jobs");
            this.jobListButton.setName("jobListButton");
            this.jobListButton.setToolTipText("View jobs");
            this.jobListButton.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    StatusBar.this.viewTasks();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            });
            this.taskCountChanged(0, 0, false);
            this.statusPanel = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            c.insets.set(0, 0, 0, 5);
            this.statusPanel.add((Component)this.statusLabel, c);
            c.gridx = 1;
            c.weightx = 0.0;
            this.statusPanel.add((Component)this.jobListButton, c);
            c.gridx = 2;
            this.statusPanel.add((Component)this.jobStatusIndicator, c);
            c.insets.set(0, 0, 0, 0);
            c.gridx = 3;
            this.memoryIndicator.setPreferredSize(new Dimension(200, 20));
            this.statusPanel.add((Component)this.memoryIndicator, c);
        }
        return this.statusPanel;
    }

    public void viewTasks() {
        this.application.refreshTaskList();
        this.application.getTaskListScreen().getFrame().setVisible(true);
        this.application.getTaskListScreen().getFrame().setExtendedState(0);
        this.application.getTaskListScreen().getFrame().toFront();
        this.application.getTaskListScreen().getFrame().setFocusable(true);
        this.application.getTaskListScreen().getFrame().requestFocus();
        this.application.getTaskListScreen().getFrame().toFront();
        this.jobListButton.setToolTipText("Hide Task manager");
    }

    private void setProgressBar(String indicatorText, boolean indeterminate, int value) {
        this.jobStatusIndicator.setString(indicatorText);
        this.jobStatusIndicator.setIndeterminate(indeterminate);
        this.jobStatusIndicator.setValue(value);
        if (value > 0) {
            this.jobStatusIndicator.setForeground(this.normalStatusIndicatorColor.darker());
        } else {
            this.jobStatusIndicator.setForeground(this.normalStatusIndicatorColor);
        }
    }

    protected void taskCountChanged(int taskCount, int completion, boolean useBlinking) {
        boolean jobStarted = this.oldTaskCount < taskCount;
        this.oldTaskCount = taskCount;
        if (taskCount == 0) {
            this.setProgressBar("0 jobs running", false, 0);
        } else if (taskCount == 1) {
            if (completion != -1) {
                this.setProgressBar("Transferring data", false, completion);
            } else {
                this.setProgressBar(taskCount + " job running", true, 0);
            }
        } else {
            this.setProgressBar(taskCount + " jobs running", true, 0);
        }
        if (useBlinking && jobStarted) {
            this.blinkProgressBar();
        }
        this.application.updateWindowTitleJobCount(taskCount);
        this.application.refreshTaskList();
    }

    private void blinkProgressBar() {
        if (this.blinker != null) {
            this.blinker.stop();
            this.jobStatusIndicator.setFont(this.jobStatusIndicator.getFont().deriveFont(0));
        }
        class Blinker
        implements ActionListener {
            private boolean isBold = false;
            private int repeats;
            private int repeated;

            public Blinker(int repeats) {
                this.repeats = repeats;
                this.repeated = 0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.repeated == this.repeats) {
                    StatusBar.this.jobStatusIndicator.setFont(StatusBar.this.jobStatusIndicator.getFont().deriveFont(0));
                    ((Timer)e.getSource()).stop();
                    return;
                }
                if (this.isBold) {
                    StatusBar.this.jobStatusIndicator.setFont(StatusBar.this.jobStatusIndicator.getFont().deriveFont(0));
                    this.isBold = false;
                } else {
                    StatusBar.this.jobStatusIndicator.setFont(StatusBar.this.jobStatusIndicator.getFont().deriveFont(1));
                    this.isBold = true;
                }
                ++this.repeated;
            }
        }
        this.blinker = new Timer(350, new Blinker(6));
        this.blinker.start();
    }

    public void updateMemoryIndicator() {
        this.memoryIndicator.setString("Used memory " + SystemMonitorUtil.getMemInfo());
        this.memoryIndicator.setValue((int)((float)SystemMonitorUtil.getUsed() / (float)Runtime.getRuntime().maxMemory() * 100.0f));
    }

    public void setFontSize(float fontSize) {
        this.jobStatusIndicator.setFont(this.jobStatusIndicator.getFont().deriveFont(fontSize));
    }
}

