/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dialog;

import fi.csc.microarray.client.ServiceAccessor;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.filebroker.FileBrokerException;
import fi.csc.microarray.filebroker.NotEnoughDiskSpaceException;
import fi.csc.microarray.messaging.message.FeedbackMessage;
import fi.csc.microarray.security.CryptoKey;
import fi.csc.microarray.util.IOUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.jms.JMSException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class FeedbackDialog
extends JDialog
implements ActionListener {
    private static final Logger logger = Logger.getLogger(FeedbackDialog.class);
    private SwingClientApplication application;
    private final Dimension BUTTON_SIZE = new Dimension(70, 25);
    private JButton okButton;
    private JButton cancelButton;
    private JTextArea detailArea;
    private JTextField emailField;
    private JCheckBox attachSessionBox;
    private JCheckBox attachLogsBox;
    private String errorMessage;

    public FeedbackDialog(SwingClientApplication application, String errorMessage) {
        this(application, errorMessage, false);
    }

    public FeedbackDialog(SwingClientApplication application, String errorMessage, boolean sendSessionByDefault) {
        super((Frame)application.getMainFrame(), true);
        this.application = application;
        this.setTitle("Contact support");
        this.errorMessage = errorMessage;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.insets.set(10, 10, 5, 10);
        ++c.gridy;
        this.add((Component)new JLabel("Message"), c);
        this.detailArea = new JTextArea();
        this.detailArea.setLineWrap(true);
        this.detailArea.setWrapStyleWord(true);
        this.detailArea.setPreferredSize(new Dimension(300, 150));
        c.insets.set(0, 10, 10, 10);
        ++c.gridy;
        this.add((Component)this.detailArea, c);
        c.insets.set(10, 10, 5, 10);
        ++c.gridy;
        this.add((Component)new JLabel("Your email"), c);
        this.emailField = new JTextField();
        this.emailField.setPreferredSize(new Dimension(300, 20));
        c.insets.set(0, 10, 10, 10);
        ++c.gridy;
        this.add((Component)this.emailField, c);
        c.insets.set(10, 10, 5, 10);
        ++c.gridy;
        this.attachSessionBox = new JCheckBox("Attach data and workflow information");
        this.attachSessionBox.setSelected(sendSessionByDefault);
        this.add((Component)this.attachSessionBox, c);
        c.insets.set(10, 10, 5, 10);
        ++c.gridy;
        this.attachLogsBox = new JCheckBox("Attach log files");
        this.attachLogsBox.setSelected(true);
        this.add((Component)this.attachLogsBox, c);
        this.okButton = new JButton("OK");
        this.okButton.setPreferredSize(this.BUTTON_SIZE);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setPreferredSize(this.BUTTON_SIZE);
        this.cancelButton.addActionListener(this);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.okButton);
        buttonsPanel.add(this.cancelButton);
        c.fill = 2;
        c.insets.set(10, 10, 5, 10);
        ++c.gridy;
        this.add((Component)buttonsPanel, c);
    }

    public void showDialog() {
        this.setLocationRelativeTo(this.application.getMainFrame());
        this.setResizable(false);
        this.pack();
        this.setModal(true);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.okButton) {
            if (this.detailArea.getText().length() == 0) {
                JOptionPane.showMessageDialog(this.getParent(), "Please, provide some details in the feedback area.", "Info", 1);
                return;
            }
            this.dispose();
            this.application.runBlockingTask("sending feedback, with large session this may take a while", new Runnable(){

                @Override
                public void run() {
                    try {
                        FeedbackDialog.this.sendFeedback();
                    }
                    catch (Exception e) {
                        FeedbackDialog.this.application.reportException(e);
                    }
                }
            });
        } else {
            this.dispose();
        }
    }

    private void sendFeedback() throws Exception, JMSException, FileBrokerException, IOException, NotEnoughDiskSpaceException, FileNotFoundException {
        String sessionUrl;
        ServiceAccessor serviceAccessor = Session.getSession().getServiceAccessor();
        FileBrokerClient fileBrokerClient = serviceAccessor.getFileBrokerClient();
        if (this.attachSessionBox.isSelected()) {
            String sessionId = this.application.getSessionManager().saveFeedbackSession();
            sessionUrl = fileBrokerClient.getExternalURL(sessionId);
        } else {
            sessionUrl = "";
        }
        String messageText = this.detailArea.getText() + "\n\nError message:\n" + this.errorMessage;
        FeedbackMessage message = new FeedbackMessage(messageText, this.emailField.getText(), sessionUrl);
        if (this.attachLogsBox.isSelected()) {
            File logDir = DirectoryLayout.getInstance().getLogsDir();
            for (File logFile : logDir.listFiles()) {
                File copyOfLog = File.createTempFile("chipster-temp-file", "");
                copyOfLog.deleteOnExit();
                IOUtils.copy(logFile, copyOfLog);
                String dataId = CryptoKey.generateRandom();
                fileBrokerClient.addFile(dataId, FileBrokerClient.FileBrokerArea.CACHE, new FileInputStream(copyOfLog), copyOfLog.length(), null);
                String url = fileBrokerClient.getExternalURL(dataId);
                message.addLog(logFile.getName(), url);
                copyOfLog.delete();
            }
        }
        serviceAccessor.sendFeedbackMessage(message);
    }
}

