/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.parameter.IntegerParameter;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.operation.parameter.ParameterInputComponent;
import fi.csc.microarray.client.operation.parameter.ParameterPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import javax.swing.AbstractSpinnerModel;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IntegerInputComponent
extends ParameterInputComponent
implements CaretListener,
ChangeListener {
    private JSpinner spinner;
    private JFormattedTextField field;
    private IntegerParameter param;
    private int state;

    public IntegerInputComponent(IntegerParameter param, ParameterPanel parameterPanel) {
        super(parameterPanel);
        this.param = param;
        this.state = 0;
        NullableSpinnerModel model = new NullableSpinnerModel();
        model.setValue(param.getValue());
        this.spinner = new JSpinner(model);
        this.spinner.addFocusListener(this);
        this.spinner.setPreferredSize(ParameterInputComponent.PREFERRED_SIZE);
        this.spinner.setEditor(new NullableSpinnerEditor(this.spinner, "0"));
        this.spinner.addChangeListener(this);
        this.field = ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField();
        this.field.addCaretListener(this);
        this.field.setBackground(BG_VALID);
        this.add((Component)this.spinner, "Center");
    }

    @Override
    public Parameter getParameter() {
        return this.param;
    }

    @Override
    public boolean inputIsValid() {
        return this.state == 0 || this.state == 1;
    }

    private void setFromSpinner() {
        NullableSpinnerModel numberModel = (NullableSpinnerModel)this.spinner.getModel();
        Integer value = numberModel.getNumber();
        if (value == null && !this.param.isOptional()) {
            this.setState(-3);
        } else if (this.param.checkValidityOf(value)) {
            this.param.setValue(value);
            this.setState(1);
        } else {
            this.setState(-1);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            this.setFromSpinner();
        }
        catch (NumberFormatException nfe) {
            this.setState(-2);
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        try {
            this.setFromSpinner();
        }
        catch (NumberFormatException nfe) {
            this.setState(-2);
        }
    }

    private void setState(int newState) {
        String message = null;
        this.state = newState;
        switch (this.state) {
            case 1: {
                this.field.setBackground(ParameterInputComponent.BG_VALID);
                message = this.param.getDescription();
                this.getParentPanel().setMessage(message, Color.black);
                break;
            }
            case -1: {
                this.field.setBackground(ParameterInputComponent.BG_INVALID);
                message = "Value for " + this.param.getID() + " must be between " + this.param.getMinValue() + " and " + this.param.getMaxValue() + ".";
                this.getParentPanel().setMessage(message, Color.red);
                break;
            }
            case -2: {
                this.field.setBackground(ParameterInputComponent.BG_INVALID);
                message = "Value for " + this.param.getID() + " must be a valid integer.";
                this.getParentPanel().setMessage(message, Color.red);
                break;
            }
            case -3: {
                this.field.setBackground(ParameterInputComponent.BG_INVALID);
                message = "Parameter " + this.param.getID() + " is required and can not be empty.";
                this.getParentPanel().setMessage(message, Color.red);
            }
        }
    }

    @Override
    public JComponent getParameterComponent() {
        return this.spinner;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.getParentPanel().setMessage(this.param.getDescription(), Color.black);
    }

    public class NullableSpinnerEditor
    extends JSpinner.DefaultEditor {
        private JSpinner spinner;
        private DecimalFormat format;
        private JTextField textField;

        public NullableSpinnerEditor(JSpinner spinner, String format) {
            super(spinner);
            this.spinner = spinner;
            this.format = new DecimalFormat(format);
            this.textField = this.getTextField();
            this.textField.setEditable(true);
            this.textField.setHorizontalAlignment(4);
        }

        public DecimalFormat getFormat() {
            return this.format;
        }

        public NullableSpinnerModel getModel() {
            return (NullableSpinnerModel)this.spinner.getModel();
        }
    }

    public class NullableSpinnerModel
    extends AbstractSpinnerModel {
        protected String value = "";

        @Override
        public void setValue(Object o) {
            this.value = o != null ? o.toString() : "";
            this.fireStateChanged();
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object getPreviousValue() {
            Integer i = this.getNumber();
            if (i == null) {
                return "0";
            }
            return "" + (i - 1);
        }

        @Override
        public Object getNextValue() {
            Integer i = this.getNumber();
            if (i == null) {
                return "0";
            }
            return "" + (i + 1);
        }

        private Integer getNumber() {
            if (this.value.equals("")) {
                return null;
            }
            try {
                return new Integer(this.value);
            }
            catch (NumberFormatException exc) {
                throw new NumberFormatException();
            }
        }
    }
}

