/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.session;

import de.schlichtherle.truezip.zip.ZipFile;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class UserSession {
    public static final String SESSION_FILE_EXTENSION = "zip";
    public static final String SESSION_DATA_FILENAME = "session.xml";
    protected static final String SESSION_BACKUP_PREFIX = "backup_session";
    private static final Logger logger = Logger.getLogger(UserSession.class);
    public static final String ROOT_FOLDER_ID = "0";
    public static final Integer SESSION_VERSION = 2;
    public static final Integer PREVIOUS_SESSION_VERSION = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isValidSessionFile(File file) {
        block25: {
            if (file == null) {
                return false;
            }
            if (!file.exists()) {
                return false;
            }
            if (!file.getName().endsWith(".zip")) {
                return false;
            }
            ZipFile zipFile = null;
            try {
                try {
                    zipFile = new ZipFile(file);
                }
                catch (ZipException e) {
                    boolean bl = false;
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException e2) {
                            logger.warn((Object)("could not close zip file: " + file.getName()));
                        }
                    }
                    return bl;
                }
                catch (IOException e) {
                    boolean bl;
                    block24: {
                        bl = false;
                        if (zipFile == null) break block24;
                        try {
                            zipFile.close();
                        }
                        catch (IOException e3) {
                            logger.warn((Object)("could not close zip file: " + file.getName()));
                        }
                    }
                    return bl;
                }
                if (zipFile.getEntry(SESSION_DATA_FILENAME) == null) {
                    boolean e = false;
                    return e;
                }
                break block25;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException e) {
                        logger.warn((Object)("could not close zip file: " + file.getName()));
                    }
                }
            }
        }
        return true;
    }

    public static boolean validateMetadataFile() throws IOException, SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(new StreamSource(UserSession.class.getResourceAsStream("/session2.xsd")));
        Validator validator = schema.newValidator();
        try {
            validator.validate(new StreamSource(UserSession.class.getResourceAsStream("/session.xml")));
            System.out.println("input is valid.");
        }
        catch (SAXException ex) {
            System.out.println("input is not valid because ");
            System.out.println(ex.getMessage());
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws IOException, SAXException {
        UserSession.validateMetadataFile();
    }

    public static JAXBContext getJAXBContext() throws JAXBException {
        return JAXBContext.newInstance((String)"fi.csc.microarray.client.session.schema2");
    }

    public static JAXBContext getPreviousJAXBContext() throws JAXBException {
        return JAXBContext.newInstance((String)"fi.csc.microarray.client.session.schema");
    }

    public static Schema getSchema() throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        return factory.newSchema(new StreamSource(UserSession.class.getResourceAsStream("session2.xsd")));
    }

    public static Schema getPreviousSchema() throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        return factory.newSchema(new StreamSource(UserSession.class.getResourceAsStream("session.xsd")));
    }

    public static File findBackupFile(File directory, boolean oneAfterLast) {
        File sessionFile = null;
        File candidateSessionFile = new File(directory, "backup_session.zip");
        int i = 0;
        while (candidateSessionFile.exists()) {
            sessionFile = candidateSessionFile;
            candidateSessionFile = new File(directory, SESSION_BACKUP_PREFIX + i + "." + SESSION_FILE_EXTENSION);
            ++i;
        }
        if (oneAfterLast) {
            sessionFile = candidateSessionFile;
        }
        return sessionFile;
    }
}

