/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.tasks;

import fi.csc.chipster.tools.ngs.LocalNGSPreprocess;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.client.tasks.TaskException;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.filebroker.NotEnoughDiskSpaceException;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.TempTopicMessagingListenerBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.messaging.message.ResultMessage;
import fi.csc.microarray.util.Exceptions;
import fi.csc.microarray.util.IOUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.jms.JMSException;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.SwingPropertyChangeSupport;
import org.apache.log4j.Logger;

public class TaskExecutor {
    private static final Logger logger = Logger.getLogger(TaskExecutor.class);
    private DataManager manager;
    private MessagingTopic requestTopic;
    private LinkedList<Task> tasks = new LinkedList();
    private LinkedList<Task> runningTasks = new LinkedList();
    private SwingPropertyChangeSupport jobExecutorStateChangeSupport;
    private boolean eventsEnabled = false;

    public TaskExecutor(MessagingEndpoint endpoint, DataManager manager) throws Exception {
        this.manager = manager;
        this.requestTopic = endpoint.createTopic(Topics.Name.REQUEST_TOPIC, MessagingTopic.AccessMode.WRITE);
        this.jobExecutorStateChangeSupport = new SwingPropertyChangeSupport(this);
    }

    protected TaskExecutor(DataManager manager) throws JMSException {
        this.manager = manager;
        this.jobExecutorStateChangeSupport = new SwingPropertyChangeSupport(this);
    }

    public Task createNewTask(OperationRecord operationRecord, boolean local) {
        Task task = new Task(operationRecord, local);
        operationRecord.setJobId(task.getId());
        return task;
    }

    public Task createContinuedTask(OperationRecord operationRecord, boolean local) {
        Task task = new Task(operationRecord, operationRecord.getJobId(), operationRecord.getStartTime(), operationRecord.getEndTime(), local);
        return task;
    }

    public void startExecuting(Task task) throws TaskException {
        this.startExecuting(task, -1);
    }

    public void startExecuting(final Task task, int timeout) throws TaskException {
        logger.debug((Object)("Starting task " + task.getName()));
        if (task.isLocal()) {
            LocalNGSPreprocess taskRunnable = new LocalNGSPreprocess(task);
            ClientApplication app = Session.getSession().getApplication();
            app.runBlockingTask("running " + task.getFullName(), taskRunnable);
            return;
        }
        try {
            List<String> parameters = task.getParameters();
            logger.debug((Object)("we have " + parameters.size() + " parameters"));
            for (String parameter : parameters) {
                logger.debug((Object)("parameter: " + parameter));
            }
        }
        catch (MicroarrayException e1) {
            logger.error((Object)"Could not log parameters.");
        }
        task.setStartTime(new Date());
        this.addToRunningTasks(task);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JobMessage jobMessage = new JobMessage(task.getId(), task.getOperationID(), task.getParameters());
                    logger.debug((Object)"adding inputs to job message");
                    TaskExecutor.this.updateTaskState(task, Task.State.TRANSFERRING_INPUTS, null, -1);
                    int i = 0;
                    for (OperationRecord.InputRecord input : task.getInputRecords()) {
                        String operationsInputName = input.getNameID().getID();
                        final DataBean bean = input.getValue();
                        final int fi = i++;
                        IOUtils.CopyProgressListener progressListener = new IOUtils.CopyProgressListener(){
                            long length;
                            {
                                this.length = Session.getSession().getApplication().getDataManager().getContentLength(bean);
                            }

                            @Override
                            public void progress(long bytes) {
                                float overall = (float)fi / (float)task.getInputCount();
                                float current = (float)bytes / (float)this.length;
                                float total = overall + current / (float)task.getInputCount();
                                TaskExecutor.this.updateTaskState(task, Task.State.TRANSFERRING_INPUTS, null, Math.round(total * 100.0f));
                            }
                        };
                        TaskExecutor.this.manager.uploadToCacheIfNeeded(bean, progressListener);
                        jobMessage.addPayload(operationsInputName, bean.getId(), bean.getName());
                        logger.debug((Object)("added input " + bean.getName() + " to job message."));
                    }
                    TaskExecutor.this.updateTaskState(task, Task.State.WAITING, null, -1);
                    ResultMessageListener replyListener = new ResultMessageListener(task);
                    logger.debug((Object)("sending job message, jobId: " + jobMessage.getJobId()));
                    TaskExecutor.this.requestTopic.sendReplyableMessage(jobMessage, replyListener);
                }
                catch (NotEnoughDiskSpaceException nedse) {
                    logger.warn((Object)"received not enough disk space when uploading input", (Throwable)nedse);
                    TaskExecutor.this.updateTaskState(task, Task.State.FAILED_USER_ERROR, "Not enough disk space", -1);
                    task.setErrorMessage("There was not enough disk space in Chipster server to run the task. Please try again later.");
                    TaskExecutor.this.removeFromRunningTasks(task);
                }
                catch (Exception e) {
                    if (e instanceof IOException && "Stream Closed".equals(e.getMessage())) {
                        String msg = "Uploading input data was interrupted. \n\nSource of the input data was lost before \nupload was completed. This may happen \nthe current session file is replace by \nsaving a new session with the same file name. \n\nPlease run the tool again.\n";
                        TaskExecutor.this.updateTaskState(task, Task.State.ERROR, msg, -1);
                        TaskExecutor.this.removeFromRunningTasks(task);
                    }
                    logger.error((Object)"Could not send job message.", (Throwable)e);
                    TaskExecutor.this.updateTaskState(task, Task.State.ERROR, "Sending message failed: " + e.getMessage(), -1);
                    TaskExecutor.this.removeFromRunningTasks(task);
                }
            }
        }).start();
        logger.debug((Object)"task starter thread started");
        this.setupTimeoutTimer(task, timeout);
    }

    public void continueExecuting(Task task) throws TaskException {
        this.continueExecuting(task, -1);
    }

    public void continueExecuting(final Task task, int timeout) throws TaskException {
        logger.debug((Object)("Continuing task " + task.getName()));
        if (task.isLocal()) {
            throw new IllegalArgumentException("local tasks cannot be continued");
        }
        this.addToRunningTasks(task);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CommandMessage commandMsg = new CommandMessage("get-job");
                    commandMsg.addNamedParameter("job-id", task.getId());
                    TaskExecutor.this.updateTaskState(task, Task.State.WAITING, null, -1);
                    ResultMessageListener replyListener = new ResultMessageListener(task);
                    logger.debug((Object)("sending get-job message, jobId: " + task.getId()));
                    TaskExecutor.this.requestTopic.sendReplyableMessage(commandMsg, replyListener);
                }
                catch (Exception e) {
                    logger.error((Object)"Could not send get-job message.", (Throwable)e);
                    TaskExecutor.this.updateTaskState(task, Task.State.ERROR, "Sending message failed: " + e.getMessage(), -1);
                    TaskExecutor.this.removeFromRunningTasks(task);
                }
            }
        }).start();
        logger.debug((Object)"task starter thread started");
        this.setupTimeoutTimer(task, timeout);
    }

    private void setupTimeoutTimer(Task task, int timeout) {
        if (timeout != -1) {
            Timer timer = new Timer(timeout, new TimeoutListener(task));
            timer.setRepeats(false);
            timer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Task task) throws TaskException {
        this.startExecuting(task);
        LinkedList<Task> linkedList = this.runningTasks;
        synchronized (linkedList) {
            while (!task.getState().isFinished()) {
                try {
                    this.runningTasks.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill(Task task) {
        logger.debug((Object)("TaskExecutor killing task " + task.getId()));
        Task task2 = task;
        synchronized (task2) {
            if (task.getState().isFinished()) {
                logger.debug((Object)"Task already finished, no need to cancel.");
                return;
            }
            this.updateTaskState(task, Task.State.CANCELLED, null, -1);
        }
        this.sendCancelMessage(task);
        this.removeFromRunningTasks(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAll() {
        LinkedList<Task> linkedList = this.runningTasks;
        synchronized (linkedList) {
            LinkedList<Task> tasksToKill = new LinkedList<Task>(this.runningTasks);
            this.killAll(tasksToKill);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAll(List<Task> tasks) {
        LinkedList<Task> linkedList = this.runningTasks;
        synchronized (linkedList) {
            for (Task task : tasks) {
                this.kill(task);
            }
            SwingUtilities.invokeLater(new TaskExecutorChangeNotifier(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killUploadingTasks() {
        LinkedList<Task> linkedList = this.runningTasks;
        synchronized (linkedList) {
            this.killAll(this.getUploadingTasks());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Task> getTasks(boolean onlyRunning, boolean showHidden) {
        LinkedList<Task> linkedList = this.runningTasks;
        synchronized (linkedList) {
            LinkedList<Task> taskList;
            LinkedList<Task> linkedList2 = taskList = onlyRunning ? this.runningTasks : this.tasks;
            if (showHidden) {
                return taskList;
            }
            LinkedList<Task> prunedTaskList = new LinkedList<Task>();
            for (Task task : taskList) {
                if (task.isHidden()) continue;
                prunedTaskList.add(task);
            }
            return prunedTaskList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Task> getUploadingTasks() {
        LinkedList<Task> linkedList = this.runningTasks;
        synchronized (linkedList) {
            List<Task> allTasks = this.getTasks(true, true);
            LinkedList<Task> uploadingTasks = new LinkedList<Task>();
            for (Task task : allTasks) {
                if (task.getState() != Task.State.NEW && task.getState() != Task.State.TRANSFERRING_INPUTS) continue;
                uploadingTasks.add(task);
            }
            return uploadingTasks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRunningTaskCount() {
        LinkedList<Task> linkedList = this.runningTasks;
        synchronized (linkedList) {
            List<Task> taskList = this.getTasks(true, false);
            return taskList.size();
        }
    }

    public int getUploadingTaskCount() {
        return this.getUploadingTasks().size();
    }

    public void addChangeListener(PropertyChangeListener listener) {
        this.jobExecutorStateChangeSupport.addPropertyChangeListener(listener);
    }

    public boolean isEventsEnabled() {
        return this.eventsEnabled;
    }

    public void setEventsEnabled(boolean eventsEnabled) {
        this.eventsEnabled = eventsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTaskState(Task task, Task.State state, String stateDetail, int completionPercentage) {
        Task.State oldState;
        Task task2 = task;
        synchronized (task2) {
            if (task.getState().isFinished()) {
                return;
            }
            oldState = task.getState();
            task.setState(state);
            if (stateDetail != null) {
                task.setStateDetail(stateDetail);
            }
            task.setCompletionPercentage(completionPercentage);
            SwingUtilities.invokeLater(new TaskExecutorChangeNotifier(this));
        }
        if (oldState != null) {
            task.notifyTaskStateChangeListener(oldState, state);
        }
    }

    private void dispatch(PropertyChangeEvent event) {
        if (this.eventsEnabled) {
            this.jobExecutorStateChangeSupport.firePropertyChange(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToRunningTasks(Task task) {
        LinkedList<Task> linkedList = this.runningTasks;
        synchronized (linkedList) {
            this.tasks.add(task);
            this.runningTasks.add(task);
            this.runningTasks.notifyAll();
        }
        SwingUtilities.invokeLater(new TaskExecutorChangeNotifier(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromRunningTasks(Task task) {
        LinkedList<Task> linkedList = this.runningTasks;
        synchronized (linkedList) {
            this.runningTasks.remove(task);
            this.runningTasks.notifyAll();
        }
        SwingUtilities.invokeLater(new TaskExecutorChangeNotifier(this));
    }

    private void sendCancelMessage(final Task task) {
        logger.debug((Object)("Sending cancel message for " + task.getId()));
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CommandMessage commandMessage = new CommandMessage("cancel");
                    commandMessage.addNamedParameter("job-id", task.getId());
                    logger.debug((Object)"Sending cancel message.");
                    TaskExecutor.this.requestTopic.sendMessage(commandMessage);
                }
                catch (Exception e) {
                    logger.error((Object)("Could not send cancel message for " + task.getId()), (Throwable)e);
                }
            }
        }).start();
        logger.debug((Object)"Message cancel thread started.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList<Task> linkedList = this.runningTasks;
        synchronized (linkedList) {
            this.runningTasks.clear();
            this.tasks.clear();
        }
        SwingUtilities.invokeLater(new TaskExecutorChangeNotifier(this));
    }

    private class ResultMessageListener
    extends TempTopicMessagingListenerBase {
        Task pendingTask;
        ResultListenerState internalState;

        public ResultMessageListener(Task pendingTask) {
            this.pendingTask = pendingTask;
            this.internalState = ResultListenerState.WAIT_FOR_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChipsterMessage(ChipsterMessage msg) {
            ResultMessage resultMessage;
            logger.debug((Object)("Task " + this.pendingTask.getId() + " got message (" + msg.getMessageID() + ") of type " + msg.getClass().getName()));
            LinkedList linkedList = TaskExecutor.this.runningTasks;
            synchronized (linkedList) {
                if (!TaskExecutor.this.runningTasks.contains(this.pendingTask)) {
                    return;
                }
            }
            if (this.internalState.equals((Object)ResultListenerState.FINISHED)) {
                return;
            }
            if (this.pendingTask.getState().isFinished()) {
                logger.debug((Object)("Task " + this.pendingTask.getId() + " already finished, ignoring message."));
                this.internalState = ResultListenerState.FINISHED;
                return;
            }
            if (msg instanceof ResultMessage) {
                resultMessage = (ResultMessage)msg;
                if (JobState.ERROR.equals((Object)resultMessage.getState())) {
                    logger.debug((Object)("Task " + this.pendingTask.getId() + " got result message with ERROR."));
                    this.taskFinished(Task.State.ERROR, resultMessage.getStateDetail(), resultMessage);
                    return;
                }
                if (JobState.FAILED_USER_ERROR.equals((Object)resultMessage.getState())) {
                    this.taskFinished(Task.State.FAILED_USER_ERROR, resultMessage.getStateDetail(), resultMessage);
                    return;
                }
            }
            block3 : switch (this.internalState) {
                case WAIT_FOR_STATUS: {
                    if (!(msg instanceof ResultMessage)) break;
                    resultMessage = (ResultMessage)msg;
                    JobState jobState = resultMessage.getState();
                    switch (jobState) {
                        case NEW: {
                            break block3;
                        }
                        case RUNNING: {
                            TaskExecutor.this.updateTaskState(this.pendingTask, Task.State.RUNNING, resultMessage.getStateDetail(), -1);
                            break block3;
                        }
                        case COMPLETED: {
                            TaskExecutor.this.updateTaskState(this.pendingTask, Task.State.TRANSFERRING_OUTPUTS, null, -1);
                            try {
                                this.extractOutputs(resultMessage);
                            }
                            catch (Exception e) {
                                logger.error((Object)"Getting outputs failed", (Throwable)e);
                                e.printStackTrace();
                                this.pendingTask.setErrorMessage(Exceptions.getStackTrace(e));
                                this.taskFinished(Task.State.ERROR, "Transferring outputs failed", null);
                                break block3;
                            }
                            this.taskFinished(Task.State.COMPLETED, null, resultMessage);
                            break block3;
                        }
                        case CANCELLED: {
                            this.taskFinished(Task.State.CANCELLED, resultMessage.getStateDetail(), resultMessage);
                            break block3;
                        }
                        case FAILED: {
                            this.taskFinished(Task.State.FAILED, resultMessage.getStateDetail(), resultMessage);
                            break block3;
                        }
                        case FAILED_USER_ERROR: {
                            this.taskFinished(Task.State.FAILED_USER_ERROR, resultMessage.getStateDetail(), resultMessage);
                            break block3;
                        }
                        case TIMEOUT: {
                            this.taskFinished(Task.State.FAILED, resultMessage.getStateDetail(), resultMessage);
                            break block3;
                        }
                    }
                    break;
                }
            }
            if (this.pendingTask.getState().isFinished() && this.internalState != ResultListenerState.FINISHED) {
                this.internalState = ResultListenerState.FINISHED;
            }
        }

        @Override
        public void cancel() {
            this.taskFinished(Task.State.CANCELLED, null, null);
        }

        private void extractOutputs(ResultMessage resultMessage) throws JMSException, MicroarrayException, IOException {
            for (String key : resultMessage.getKeys()) {
                logger.debug((Object)("output " + key));
                String dataId = resultMessage.getId(key);
                String name = resultMessage.getName(key);
                if (name == null) {
                    name = key;
                }
                DataBean bean = TaskExecutor.this.manager.createDataBean(name, dataId, true);
                this.pendingTask.addOutput(bean);
            }
        }

        private void taskFinished(Task.State state, String stateDetail, ResultMessage resultMessage) {
            this.cleanUp();
            if (resultMessage != null) {
                if (resultMessage.getOutputText() != null) {
                    this.pendingTask.setScreenOutput(resultMessage.getOutputText());
                }
                if (resultMessage.getErrorMessage() != null) {
                    this.pendingTask.setErrorMessage(resultMessage.getErrorMessage());
                }
                this.pendingTask.getOperationRecord().setSourceCode(resultMessage.getSourceCode());
            }
            this.pendingTask.setEndTime(new Date());
            this.pendingTask.getOperationRecord().setJobId(null);
            TaskExecutor.this.updateTaskState(this.pendingTask, state, stateDetail, -1);
            this.internalState = ResultListenerState.FINISHED;
            TaskExecutor.this.removeFromRunningTasks(this.pendingTask);
        }
    }

    private static enum ResultListenerState {
        WAIT_FOR_STATUS,
        FINISHED,
        TIMEOUT;

    }

    private class TaskExecutorChangeNotifier
    implements Runnable {
        private TaskExecutor parent;

        public TaskExecutorChangeNotifier(TaskExecutor parent) {
            this.parent = parent;
        }

        @Override
        public void run() {
            TaskExecutor.this.dispatch(new PropertyChangeEvent(this.parent, "runningJobCount", null, TaskExecutor.this.getRunningTaskCount()));
        }
    }

    private class TimeoutListener
    implements ActionListener {
        Task taskToMonitor;

        TimeoutListener(Task taskToMonitor) {
            this.taskToMonitor = taskToMonitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Task task = this.taskToMonitor;
            synchronized (task) {
                if (!this.taskToMonitor.getState().isFinished()) {
                    TaskExecutor.this.updateTaskState(this.taskToMonitor, Task.State.TIMEOUT, null, -1);
                }
            }
            TaskExecutor.this.removeFromRunningTasks(this.taskToMonitor);
            TaskExecutor.this.sendCancelMessage(this.taskToMonitor);
        }
    }
}

