/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.selection.IntegratedSelectionManager;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.exception.MicroarrayException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class VisualisationUtilities {
    private static final ClientApplication application = Session.getSession().getApplication();

    public static DataBean filterBySelection(List<DataBean> datas, boolean invert) {
        try {
            if (datas.size() == 1) {
                IntegratedSelectionManager selectionManager = application.getSelectionManager().getSelectionManager(datas.get(0));
                List<String> lines = invert ? selectionManager.getUnselectedLines() : selectionManager.getSelectedLines();
                return IntegratedSelectionManager.createDataset(lines, datas.toArray(new DataBean[datas.size()]));
            }
            if (invert) {
                throw new IllegalArgumentException("inverted filtering isn't implemented for multiple datasets");
            }
            LinkedList<String[]> allColumns = new LinkedList<String[]>();
            for (DataBean data : datas) {
                if (application.getSelectionManager().getSelectionManager(data).getSelectionAsRows().length <= 0) continue;
                String[] table = data.queryFeatures("/column/*").asTable();
                Throwable throwable = null;
                try {
                    allColumns.add(table.getColumnNames());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (table == null) continue;
                    if (throwable != null) {
                        try {
                            table.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    table.close();
                }
            }
            ArrayList<String> columnOrder = new ArrayList<String>();
            while (allColumns.size() > 0) {
                int mostColumns = 0;
                for (String[] columnList : allColumns) {
                    if (columnList.length <= ((String[])allColumns.get(mostColumns)).length) continue;
                    mostColumns = allColumns.indexOf(columnList);
                }
                for (String col : (String[])allColumns.get(mostColumns)) {
                    if (columnOrder.contains(col)) continue;
                    columnOrder.add(col);
                }
                allColumns.remove(mostColumns);
            }
            Map<String, Map<String, String>> values = VisualisationUtilities.getSelectedFromMultipleDatas(datas);
            ArrayList<String> lines = new ArrayList<String>();
            String newLine = "";
            for (int i = 0; i < columnOrder.size(); ++i) {
                String colName = (String)columnOrder.get(i);
                if (i == 0 && " ".equals(colName)) continue;
                newLine = newLine + colName + "\t";
            }
            if (newLine.endsWith("\t")) {
                newLine = newLine.substring(0, newLine.length() - 1);
            }
            lines.add(newLine);
            for (String id : values.keySet()) {
                newLine = "";
                Map<String, String> rowValues = values.get(id);
                for (String colName : columnOrder) {
                    String value = rowValues.get(colName);
                    if (value == null) {
                        value = "";
                    }
                    newLine = newLine + value + "\t";
                }
                if (newLine.endsWith("\t")) {
                    newLine = newLine.substring(0, newLine.length() - 1);
                }
                lines.add(newLine);
            }
            return IntegratedSelectionManager.createDataset(lines, datas.toArray(new DataBean[datas.size()]));
        }
        catch (Exception exp) {
            application.reportException(new MicroarrayException("Unable to create user filtered dataset", exp));
            return null;
        }
    }

    public static Map<String, Map<String, String>> getSelectedFromMultipleDatas(List<DataBean> datas) throws Exception {
        HashMap<String, Map<String, String>> lines = new HashMap<String, Map<String, String>>();
        for (DataBean data : datas) {
            Table columns = data.queryFeatures("/column/*").asTable();
            Throwable throwable = null;
            try {
                int[] indexes = application.getSelectionManager().getSelectionManager(data).getSelectionAsRows();
                Arrays.sort(indexes);
                int i = 0;
                while (columns.nextRow()) {
                    if (Arrays.binarySearch(indexes, i) >= 0) {
                        String id;
                        HashMap<String, String> newColumns = new HashMap<String, String>();
                        for (String columnName : columns.getColumnNames()) {
                            newColumns.put(columnName, columns.getValue(columnName).toString());
                        }
                        String string = id = newColumns.containsKey(" ") ? (String)newColumns.get(" ") : (String)newColumns.get("identifier");
                        if (!lines.containsKey(id)) {
                            lines.put(id, newColumns);
                        }
                        ((Map)lines.get(id)).putAll(newColumns);
                    }
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (columns == null) continue;
                if (throwable != null) {
                    try {
                        columns.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                columns.close();
            }
        }
        return lines;
    }

    public static Visualisation.Variable[] getVariablesFilteredInclusive(DataBean dataBean, String startsWith, boolean removeStart) {
        String exprHeader = "/column/";
        LinkedList<Visualisation.Variable> vars = new LinkedList<Visualisation.Variable>();
        try (Table columns = dataBean.queryFeatures("/column/*").asTable();){
            for (String columnName : columns.getColumnNames()) {
                if (!columnName.startsWith(startsWith)) continue;
                String chipName = removeStart ? columnName.substring(startsWith.length()) : columnName;
                String expression = exprHeader + columnName;
                vars.add(new Visualisation.Variable(chipName, expression));
            }
        }
        catch (MicroarrayException e) {
            application.reportException(new MicroarrayException("no chips to visualise"));
        }
        return vars.toArray(new Visualisation.Variable[0]);
    }

    public static Visualisation.Variable[] getVariablesFilteredExclusive(DataBean dataBean, Collection<String> columnsToRemove, boolean removeStart) {
        LinkedList filteredVars = new LinkedList();
        LinkedList<Visualisation.Variable> allVars = new LinkedList<Visualisation.Variable>();
        allVars.addAll(Arrays.asList(VisualisationUtilities.getVariablesFilteredInclusive(dataBean, "", false)));
        filteredVars.addAll(allVars);
        String hidden = "chip.";
        for (Visualisation.Variable var : allVars) {
            for (String colToRemove : columnsToRemove) {
                if (!var.getName().startsWith(colToRemove)) continue;
                filteredVars.remove(var);
            }
            if (removeStart && var.getName().startsWith(hidden)) {
                String chipName = var.getName().substring(hidden.length());
                filteredVars.set(filteredVars.indexOf(var), new Visualisation.Variable(chipName, var.getExpression()));
            }
            if (!filteredVars.contains(var) || !var.getName().equals(" ")) continue;
            filteredVars.set(filteredVars.indexOf(var), new Visualisation.Variable("identifier", var.getExpression()));
        }
        return filteredVars.toArray(new Visualisation.Variable[0]);
    }
}

